/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Configurable;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PlaceMarker;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.i18n.TranslatableMarker;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.i18n.Translation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentI18nData {
    protected String prefix;
    protected Translatable parent;
    protected Configurable myComponent;
    protected Map<String, Property> translatableProperties = new TreeMap<String, Property>();
    protected Map<String, Property> allProperties = new TreeMap<String, Property>();
    protected List<Translatable> children = new ArrayList<Translatable>();

    public ComponentI18nData(AbstractConfigurable abstractConfigurable, String string) {
        this.init((Configurable)abstractConfigurable, string, abstractConfigurable.getAttributeNames(), abstractConfigurable.getAttributeTypes(), abstractConfigurable.getAttributeDescriptions());
    }

    public ComponentI18nData(AbstractConfigurable abstractConfigurable, String string, ArrayList<String> arrayList, ArrayList<Class<?>> arrayList2, ArrayList<String> arrayList3) {
        this.init((Configurable)abstractConfigurable, string, arrayList.toArray(new String[0]), arrayList2.toArray(new Class[0]), arrayList3.toArray(new String[0]));
    }

    public ComponentI18nData(AutoConfigurable autoConfigurable, String string) {
        this.prefix = string;
        this.parent = null;
        this.init((Configurable)autoConfigurable, string, autoConfigurable.getAttributeNames(), autoConfigurable.getAttributeTypes(), autoConfigurable.getAttributeDescriptions());
    }

    protected void init(Configurable configurable, String string, String[] stringArray, Class<?>[] classArray, String[] stringArray2) {
        boolean[] blArray = new boolean[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            blArray[i] = classArray[i] != null && (classArray[i].equals(String.class) || TranslatableConfigurerFactory.class.isAssignableFrom(classArray[i]));
        }
        this.init(configurable, string, stringArray, stringArray2, blArray);
    }

    protected void init(Configurable configurable, String string, String[] stringArray, String[] stringArray2, boolean[] blArray) {
        this.prefix = string;
        this.myComponent = configurable;
        for (Configurable configurable2 : this.myComponent.getConfigureComponents()) {
            this.children.add(configurable2);
        }
        for (int i = 0; i < blArray.length; ++i) {
            Property property = new Property(stringArray[i], stringArray2[i]);
            this.allProperties.put(stringArray[i], property);
            if (!blArray[i]) continue;
            this.translatableProperties.put(stringArray[i], property);
        }
    }

    public ComponentI18nData(Configurable configurable, String string, Translatable translatable, String[] stringArray, boolean[] blArray, String[] stringArray2) {
        this.myComponent = configurable;
        this.prefix = string;
        this.parent = translatable;
        this.init(configurable, string, stringArray, stringArray2, blArray);
    }

    public ComponentI18nData(Configurable configurable, String string, Translatable translatable) {
        this(configurable, string, translatable, new String[0], new boolean[0], new String[0]);
    }

    public ComponentI18nData(Configurable configurable, String string) {
        this(configurable, string, null);
    }

    public ComponentI18nData(Configurable configurable, GamePiece gamePiece) {
        this.myComponent = configurable;
        this.prefix = "Piece.";
        this.parent = null;
        GamePiece gamePiece2 = gamePiece;
        while (gamePiece2 != null) {
            if (gamePiece2 instanceof TranslatablePiece) {
                PieceI18nData pieceI18nData = ((TranslatablePiece)gamePiece2).getI18nData();
                for (PieceI18nData.Property property : pieceI18nData.getProperties()) {
                    Property property2 = new Property(property.getName(), property.getDescription());
                    this.translatableProperties.put(property.getName(), property2);
                    this.allProperties.put(property.getName(), property2);
                }
            }
            if (gamePiece2 instanceof PlaceMarker && ((PlaceMarker)gamePiece2).isMarkerStandalone()) {
                this.children.add(new TranslatableMarker((PlaceMarker)gamePiece2));
            }
            if (gamePiece2 instanceof BasicPiece) {
                gamePiece2 = null;
                continue;
            }
            gamePiece2 = ((Decorator)gamePiece2).getInner();
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public String getFullPrefix() {
        String string;
        if ("Piece.".equals(this.prefix)) {
            return this.prefix;
        }
        String string2 = string = this.getOwningComponent() == null ? "" : this.getOwningComponent().getI18nData().getFullPrefix();
        if (string.length() > 0 && this.prefix.length() > 0) {
            string = string + ".";
        }
        return string + this.prefix;
    }

    public Collection<String> getAttributeKeys() {
        return this.translatableProperties.keySet();
    }

    public void setOwningComponent(Translatable translatable) {
        this.parent = translatable;
    }

    public Translatable getOwningComponent() {
        return this.parent;
    }

    public boolean isAttributeTranslatable(String string) {
        return this.translatableProperties.containsKey(string);
    }

    public boolean isTranslatable() {
        if (this.translatableProperties.size() > 0) {
            return true;
        }
        for (Translatable translatable : this.children) {
            if (!translatable.getI18nData().isTranslatable()) continue;
            return true;
        }
        return false;
    }

    public void setAttributeTranslatable(String string, boolean bl) {
        if (bl) {
            this.translatableProperties.put(string, this.allProperties.get(string));
        } else {
            this.translatableProperties.remove(string);
        }
    }

    public void setAllAttributesUntranslatable() {
        this.translatableProperties.clear();
    }

    public void applyTranslation(String string, String string2) {
        Property property = this.translatableProperties.get(string);
        if (string != null) {
            property.setUntranslatedValue(this.myComponent.getAttributeValueString(string));
            this.myComponent.setAttribute(string, string2);
        }
    }

    public String getAttributeDescription(String string) {
        return this.allProperties.get(string).getDescription();
    }

    public String getLocalUntranslatedValue(String string) {
        Property property = this.allProperties.get(string);
        String string2 = property == null || property.getUntranslatedValue() == null ? this.myComponent.getAttributeValueString(string) : property.getUntranslatedValue();
        return string2;
    }

    public void setUntranslatedValue(String string, String string2) {
        this.allProperties.get(string).setUntranslatedValue(string2);
    }

    public String getTranslatedValue(String string, Translation translation) {
        String string2 = this.getFullPrefix() + string;
        return translation.translate(string2);
    }

    public List<Translatable> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public boolean hasUntranslatedAttributes(Translation translation) {
        if (translation == null) {
            return false;
        }
        for (Property object : this.translatableProperties.values()) {
            String string;
            String string2 = this.myComponent.getAttributeValueString(object.getName());
            if (string2 == null || string2.length() <= 0 || (string = this.getTranslatedValue(object.getName(), translation)) != null && string.length() != 0) continue;
            return true;
        }
        for (Translatable translatable : this.children) {
            if (!translatable.getI18nData().hasUntranslatedAttributes(translation)) continue;
            return true;
        }
        return false;
    }

    public static class Property {
        private String name;
        private String description;
        private String untranslatedValue;

        public Property(String string, String string2) {
            this.name = string;
            this.description = string2;
            this.untranslatedValue = string;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public String getUntranslatedValue() {
            return this.untranslatedValue;
        }

        public void setUntranslatedValue(String string) {
            this.untranslatedValue = string;
        }
    }
}

