/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.Info;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.i18n.BundleHelper;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ErrorDialog;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resources {
    protected static BundleHelper vassalBundle;
    protected static BundleHelper editorBundle;
    private static VassalPropertyClassLoader bundleLoader;
    public static final String LOCALE_PREF_KEY = "Locale";
    protected static final List<Locale> supportedLocales;
    protected static Locale locale;
    protected static String DATE_FORMAT;
    protected static String MODULE_BUNDLE;
    public static final String VASSAL = "General.VASSAL";
    public static final String ADD = "General.add";
    public static final String REMOVE = "General.remove";
    public static final String INSERT = "General.insert";
    public static final String YES = "General.yes";
    public static final String NO = "General.no";
    public static final String CANCEL = "General.cancel";
    public static final String SAVE = "General.save";
    public static final String OK = "General.ok";
    public static final String MENU = "General.menu";
    public static final String LOAD = "General.load";
    public static final String QUIT = "General.quit";
    public static final String EDIT = "General.edit";
    public static final String NEW = "General.new";
    public static final String FILE = "General.file";
    public static final String TOOLS = "General.tools";
    public static final String HELP = "General.help";
    public static final String CLOSE = "General.close";
    public static final String DATE_DISPLAY = "General.date_display";
    public static final String NEXT = "General.next";
    public static final String REFRESH = "General.refresh";
    public static final String SELECT = "General.select";
    public static final String EDITOR_PREFIX = "Editor.";
    public static final String BUTTON_TEXT = "Editor.button_text_label";
    public static final String TOOLTIP_TEXT = "Editor.tooltip_text_label";
    public static final String BUTTON_ICON = "Editor.button_icon_label";
    public static final String HOTKEY_LABEL = "Editor.hotkey_label";
    public static final String COLOR_LABEL = "Editor.color_label";
    public static final String NAME_LABEL = "Editor.name_label";
    protected static final String BASE_BUNDLE = "VASSAL.properties";
    protected static final String EN_BUNDLE = "VASSAL_en.properties";

    public static Collection<Locale> getSupportedLocales() {
        return supportedLocales;
    }

    public static void addSupportedLocale(Locale locale) {
        if (!supportedLocales.contains(locale = new Locale(locale.getLanguage()))) {
            supportedLocales.add(0, locale);
            StringEnumConfigurer stringEnumConfigurer = (StringEnumConfigurer)Prefs.getGlobalPrefs().getOption(LOCALE_PREF_KEY);
            if (stringEnumConfigurer != null) {
                ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringEnumConfigurer.getValidValues()));
                arrayList.add(0, locale.getLanguage());
                stringEnumConfigurer.setValidValues(arrayList.toArray(new String[arrayList.size()]));
            }
        }
    }

    public static Collection<String> getVassalKeys() {
        return Collections.list(vassalBundle.getResourceBundle().getKeys());
    }

    public static Collection<String> getEditorKeys() {
        return Collections.list(editorBundle.getResourceBundle().getKeys());
    }

    public static String getString(String string) {
        return Resources.getBundleForKey(string).getString(string);
    }

    protected static BundleHelper getBundleForKey(String string) {
        return string.startsWith(EDITOR_PREFIX) ? Resources.getEditorBundle() : Resources.getVassalBundle();
    }

    protected static BundleHelper getEditorBundle() {
        if (editorBundle == null) {
            editorBundle = new BundleHelper(ResourceBundle.getBundle("VASSAL.i18n.Editor", locale, bundleLoader));
        }
        return editorBundle;
    }

    protected static BundleHelper getVassalBundle() {
        if (vassalBundle == null) {
            vassalBundle = new BundleHelper(ResourceBundle.getBundle("VASSAL.i18n.VASSAL", locale, bundleLoader));
        }
        return vassalBundle;
    }

    @Deprecated
    public static String getVassalString(String string) {
        return Resources.getVassalBundle().getString(string);
    }

    @Deprecated
    public static String getEditorString(String string) {
        return Resources.getEditorBundle().getString(string);
    }

    @Deprecated
    public static String getString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
        }
        catch (Exception exception) {
            System.err.println("No Translation: " + string);
        }
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    public static String getString(String string, Object ... objectArray) {
        return Resources.getBundleForKey(string).getString(string, objectArray);
    }

    public static void setLocale(Locale locale) {
        Resources.locale = locale;
        editorBundle = null;
        vassalBundle = null;
        UIManager.put("OptionPane.yesButtonText", Resources.getString(YES));
        UIManager.put("OptionPane.cancelButtonText", Resources.getString(CANCEL));
        UIManager.put("OptionPane.noButtonText", Resources.getString(NO));
        UIManager.put("OptionPane.okButtonText", Resources.getString(OK));
    }

    public static Locale getLocale() {
        return locale;
    }

    public static String formatDate(Date date) {
        return new MessageFormat(DATE_FORMAT).format(new Object[]{date});
    }

    static {
        bundleLoader = new VassalPropertyClassLoader();
        supportedLocales = new ArrayList<Locale>(Arrays.asList(Locale.ENGLISH, Locale.GERMAN, Locale.FRENCH, Locale.ITALIAN, new Locale("es"), Locale.JAPANESE, new Locale("nl")));
        locale = Locale.getDefault();
        DATE_FORMAT = "{0,date}";
        if (ResourceBundle.getBundle("VASSAL.i18n.VASSAL", Locale.getDefault(), bundleLoader).getLocale().getLanguage().equals(Locale.getDefault().getLanguage())) {
            Resources.addSupportedLocale(Locale.getDefault());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Locale object2 : Resources.getSupportedLocales()) {
            arrayList.add(object2.getLanguage());
        }
        Object object3 = Locale.getDefault();
        String string = Prefs.getGlobalPrefs().getStoredValue(LOCALE_PREF_KEY);
        object3 = string == null ? supportedLocales.iterator().next() : new Locale(string);
        Resources.setLocale((Locale)object3);
        StringEnumConfigurer stringEnumConfigurer = new StringEnumConfigurer(LOCALE_PREF_KEY, Resources.getString("Prefs.language"), arrayList.toArray(new String[arrayList.size()])){

            public Component getControls() {
                if (this.box == null) {
                    Component component = super.getControls();
                    this.box.setRenderer(new DefaultListCellRenderer(){
                        private static final long serialVersionUID = 1L;

                        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                            jLabel.setText(new Locale((String)object).getDisplayLanguage());
                            return jLabel;
                        }
                    });
                    return component;
                }
                return super.getControls();
            }
        };
        stringEnumConfigurer.setValue(Resources.getLocale().getLanguage());
        Prefs.getGlobalPrefs().addOption(Resources.getString("Prefs.general_tab"), stringEnumConfigurer);
        MODULE_BUNDLE = "Module";
    }

    public static class VassalPropertyClassLoader
    extends ClassLoader {
        public URL getResource(String string) {
            URL uRL = this.getAResource(string);
            if (uRL == null && string.endsWith(Resources.EN_BUNDLE)) {
                uRL = this.getAResource(string.substring(0, string.lastIndexOf(47) + 1) + Resources.BASE_BUNDLE);
            }
            return uRL;
        }

        public URL getAResource(String string) {
            URL uRL = null;
            String string2 = string.substring(string.lastIndexOf(47) + 1);
            File file = new File(Info.getHomeDir(), string2);
            if (file.exists()) {
                try {
                    uRL = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorDialog.bug(malformedURLException);
                }
            }
            if (uRL == null) {
                uRL = this.getClass().getClassLoader().getResource(string);
            }
            return uRL;
        }
    }
}

