/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Language;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.i18n.Translatable;
import VASSAL.i18n.Translation;
import VASSAL.tools.WriteErrorDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;

public class TranslateWindow
extends JDialog
implements ListSelectionListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    protected static Color TRANSLATION_NEEDED_COLOR = Color.red;
    protected static Color TRANSLATION_DONE_COLOR = Color.blue;
    protected static Color NO_TRANSLATION_NEEDED_COLOR = Color.black;
    protected Translatable target;
    protected String[] keys;
    protected JTable keyTable;
    protected Translatable keyTarget;
    protected JTree tree;
    protected Translation currentTranslation = null;
    protected JComboBox langBox;
    protected ActionListener boxListener;
    protected int lastSelectedLangIndex;
    protected String currentKey = "";
    protected ConfigureTree myConfigureTree;
    protected CopyButton[] copyButtons;
    static final int ATTR_COL = 0;
    static final int SOURCE_COL = 1;
    static final int CC_COL = 2;
    static final int TRAN_COL = 3;

    public TranslateWindow(Frame frame, boolean bl, Translatable translatable, HelpWindow helpWindow, ConfigureTree configureTree) {
        super(frame, bl);
        this.target = translatable;
        this.myConfigureTree = configureTree;
        this.initComponents();
    }

    protected void initComponents() {
        this.setTitle("Translate " + ConfigureTree.getConfigureName((Configurable)this.target));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(this.getHeaderPanel(), "First");
        jPanel.add(this.buildMainPanel(), "Center");
        jPanel.add(this.getButtonPanel(), "Last");
        this.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TranslateWindow.this.cancel();
            }
        });
    }

    protected Component getHeaderPanel() {
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Language:  "));
        this.langBox = new JComboBox<String>(Localization.getInstance().getTranslationList());
        jPanel.add(this.langBox);
        this.boxListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslateWindow.this.commitTableEdit();
                String string = (String)((JComboBox)actionEvent.getSource()).getSelectedItem();
                TranslateWindow.this.changeLanguage(string);
            }
        };
        this.langBox.addActionListener(this.boxListener);
        if (Localization.getInstance().getTranslationList().length > 0) {
            this.langBox.setSelectedIndex(0);
        }
        jPanel.setMinimumSize(new Dimension(800, 0));
        JButton jButton = new JButton("Add translation");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslateWindow.this.getNewTranslation();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    protected void getNewTranslation() {
        Translation translation = new Translation();
        MyPropertiesWindow myPropertiesWindow = new MyPropertiesWindow((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), false, translation, null, this);
        myPropertiesWindow.setVisible(true);
    }

    protected void refreshTranslationList(Configurable configurable) {
        Language language = GameModule.getGameModule().getComponentsOf(Language.class).iterator().next();
        if (language != null) {
            this.myConfigureTree.externalInsert(language, configurable);
        }
        this.langBox.removeAllItems();
        String[] stringArray = Localization.getInstance().getTranslationList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.langBox.addItem(stringArray[i]);
        }
        this.langBox.setSelectedItem(((Translation)configurable).getDescription());
        this.keyTable.setEnabled(true);
        this.tree.repaint();
    }

    protected Component buildMainPanel() {
        JPanel jPanel = this.buildKeyTablePanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        MyTreeNode myTreeNode = new MyTreeNode(this.target);
        this.createNodes(myTreeNode);
        this.tree = new JTree(myTreeNode);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.tree.setSelectionRow(0);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.tree, 20, 30);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.setMinimumSize(new Dimension(400, 100));
        jPanel2.setPreferredSize(new Dimension(800, 300));
        JSplitPane jSplitPane = new JSplitPane(0, jPanel2, jPanel);
        jSplitPane.setResizeWeight(0.5);
        return jSplitPane;
    }

    protected JPanel buildKeyTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setMinimumSize(new Dimension(800, 100));
        this.keyTable = new MyTable();
        this.keyTable.setSelectionMode(0);
        this.keyTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                TranslateWindow.this.commitTableEdit();
            }
        });
        this.keyTable.getSelectionModel().addListSelectionListener(this);
        this.keyTable.setEnabled(this.currentTranslation != null);
        JScrollPane jScrollPane = new JScrollPane(this.keyTable, 20, 30);
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.setMinimumSize(new Dimension(400, 100));
        jPanel.setPreferredSize(new Dimension(800, 200));
        return jPanel;
    }

    protected Component getButtonPanel() {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton(Resources.getString("General.help"));
        jButton.addActionListener(new ShowHelpAction(HelpFile.getReferenceManualPage("Translations.htm", "module").getContents(), null));
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Resources.getString("General.ok"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TranslateWindow.this.save();
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, GameModule.getGameModule().getArchiveWriter().getName());
                }
            }
        });
        jPanel.add(jButton2);
        JButton jButton3 = new JButton(Resources.getString("General.cancel"));
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TranslateWindow.this.cancel();
            }
        });
        jPanel.add(jButton3);
        return jPanel;
    }

    protected void commitTableEdit() {
        if (this.keyTable != null && this.keyTable.isEditing()) {
            int n = this.keyTable.getEditingRow();
            int n2 = this.keyTable.getEditingColumn();
            if (n != -1 && n2 != -1) {
                this.keyTable.editCellAt(n, n2);
            }
        }
    }

    protected void changeLanguage(String string) {
        if (this.currentTranslation != null && this.currentTranslation.isDirty()) {
            try {
                if (!this.querySave()) {
                    this.langBox.removeActionListener(this.boxListener);
                    this.langBox.setSelectedItem(this.lastSelectedLangIndex);
                    this.langBox.addActionListener(this.boxListener);
                }
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, GameModule.getGameModule().getArchiveWriter().getName());
            }
        }
        this.currentTranslation = Localization.getInstance().getTranslation(string);
        this.lastSelectedLangIndex = this.langBox.getSelectedIndex();
        if (this.keyTable != null) {
            ((MyTableModel)this.keyTable.getModel()).update();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.commitTableEdit();
        MyTreeNode myTreeNode = (MyTreeNode)this.tree.getLastSelectedPathComponent();
        if (myTreeNode == null) {
            return;
        }
        this.keys = myTreeNode.getTarget().getI18nData().getAttributeKeys().toArray(new String[0]);
        this.copyButtons = new CopyButton[this.keys.length];
        this.keyTarget = myTreeNode.getTarget();
        ((AbstractTableModel)this.keyTable.getModel()).fireTableStructureChanged();
        if (this.keys != null && this.keys.length > 0) {
            this.keyTable.getSelectionModel().setSelectionInterval(0, 0);
        }
        ((MyTableModel)this.keyTable.getModel()).update();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        String string = this.keys[listSelectionModel.getMinSelectionIndex()];
        this.currentKey = this.keyTarget.getI18nData().getFullPrefix() + string;
    }

    protected void createNodes(MyTreeNode myTreeNode) {
        for (Translatable translatable : myTreeNode.getTarget().getI18nData().getChildren()) {
            MyTreeNode myTreeNode2 = new MyTreeNode(translatable);
            this.createNodes(myTreeNode2);
            myTreeNode.add(myTreeNode2);
        }
    }

    public static String getDisplayName(Translatable translatable) {
        if (translatable == null) {
            return "";
        }
        String string = ConfigureTree.getConfigureName(translatable.getClass());
        String string2 = "";
        if (translatable instanceof Configurable) {
            string2 = ((Configurable)translatable).getConfigureName();
        }
        String string3 = string2 == null ? "" : string2 + " ";
        return string3 + " [" + string + "]";
    }

    protected void cancel() {
        this.commitTableEdit();
        if (this.currentTranslation != null && this.currentTranslation.isDirty()) {
            try {
                if (!this.querySave()) {
                    return;
                }
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, GameModule.getGameModule().getArchiveWriter().getName());
            }
        }
        this.dispose();
    }

    protected boolean querySave() throws IOException {
        switch (JOptionPane.showConfirmDialog(this, "Do you want to save these changes now?", "Unsaved Changes", 1)) {
            case 0: {
                this.saveTranslation();
                return true;
            }
            case 1: {
                this.reloadTranslation();
                return true;
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    protected void save() throws IOException {
        this.commitTableEdit();
        if (this.saveTranslation()) {
            this.dispose();
        }
    }

    protected boolean saveTranslation() throws IOException {
        if (this.currentTranslation != null) {
            this.currentTranslation.saveProperties();
        }
        return true;
    }

    protected void reloadTranslation() throws IOException {
        if (this.currentTranslation != null) {
            this.currentTranslation.reloadProperties();
        }
    }

    class MyTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        Translatable component;

        public MyTreeNode(Translatable translatable) {
            this.component = translatable;
        }

        public Translatable getTarget() {
            return this.component;
        }

        public String toString() {
            return TranslateWindow.getDisplayName(this.component);
        }
    }

    class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Translatable translatable = ((MyTreeNode)object).getTarget();
            if (translatable.getI18nData().hasUntranslatedAttributes(TranslateWindow.this.currentTranslation)) {
                component.setForeground(TRANSLATION_NEEDED_COLOR);
            } else {
                component.setForeground(NO_TRANSLATION_NEEDED_COLOR);
            }
            return component;
        }
    }

    class CopyButton
    extends JButton
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        int row;

        public CopyButton(int n) {
            super("->");
            this.row = n;
            this.addActionListener(this);
            this.setMargin(new Insets(1, 1, 1, 1));
            this.checkEnabled();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = TranslateWindow.this.keys[this.row];
            TranslateWindow.this.currentKey = TranslateWindow.this.keyTarget.getI18nData().getFullPrefix() + string;
            TranslateWindow.this.currentTranslation.setProperty(TranslateWindow.this.currentKey, TranslateWindow.this.keyTarget.getAttributeValueString(TranslateWindow.this.keys[this.row]));
            this.checkEnabled();
            ((MyTableModel)TranslateWindow.this.keyTable.getModel()).update();
        }

        public void checkEnabled() {
            if (TranslateWindow.this.keyTarget != null && TranslateWindow.this.keys != null && TranslateWindow.this.keys[this.row] != null) {
                String string = TranslateWindow.this.currentTranslation == null ? "" : TranslateWindow.this.currentTranslation.translate(TranslateWindow.this.keyTarget.getI18nData().getFullPrefix() + TranslateWindow.this.keys[this.row]);
                this.setEnabled(string == null || string.length() == 0);
            } else {
                this.setEnabled(true);
            }
        }
    }

    class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Translatable target;

        public MyTableCellRenderer(Translatable translatable) {
            this.target = translatable;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            String string = this.target.getI18nData().getFullPrefix() + TranslateWindow.this.keys[n];
            String string2 = TranslateWindow.this.currentTranslation == null ? "" : TranslateWindow.this.currentTranslation.translate(string);
            String string3 = this.target.getAttributeValueString(TranslateWindow.this.keys[n]);
            if (string3 == null || string3.length() == 0) {
                component.setForeground(NO_TRANSLATION_NEEDED_COLOR);
            } else if (string2 == null || string2.length() == 0) {
                component.setForeground(TRANSLATION_NEEDED_COLOR);
            } else {
                component.setForeground(TRANSLATION_DONE_COLOR);
            }
            return component;
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        MyTableModel() {
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Attribute";
                }
                case 1: {
                    return "Source Text";
                }
                case 2: {
                    return "cc";
                }
                case 3: {
                    return "Translation";
                }
            }
            return null;
        }

        public int getRowCount() {
            return TranslateWindow.this.keys == null ? 0 : TranslateWindow.this.keys.length;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return TranslateWindow.this.keys == null ? null : TranslateWindow.this.keyTarget.getI18nData().getAttributeDescription(TranslateWindow.this.keys[n]);
                }
                case 1: {
                    return TranslateWindow.this.keys == null ? null : TranslateWindow.this.keyTarget.getAttributeValueString(TranslateWindow.this.keys[n]);
                }
                case 2: {
                    if (TranslateWindow.this.copyButtons[n] == null) {
                        TranslateWindow.this.copyButtons[n] = new CopyButton(n);
                    }
                    return TranslateWindow.this.copyButtons[n];
                }
                case 3: {
                    if (TranslateWindow.this.currentTranslation == null) break;
                    String string = TranslateWindow.this.keyTarget.getI18nData().getFullPrefix() + TranslateWindow.this.keys[n];
                    return TranslateWindow.this.currentTranslation.translate(string);
                }
            }
            return null;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 3) {
                TranslateWindow.this.currentTranslation.setProperty(TranslateWindow.this.currentKey, (String)object);
                TranslateWindow.this.copyButtons[n].checkEnabled();
                this.fireTableCellUpdated(n, n2);
                TranslateWindow.this.tree.repaint();
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 3 || n2 == 2;
        }

        public void update() {
            this.fireTableStructureChanged();
            TranslateWindow.this.keyTable.getColumnModel().getColumn(0).setCellRenderer(new MyTableCellRenderer(TranslateWindow.this.keyTarget));
            TranslateWindow.this.keyTable.getColumnModel().getColumn(2).setMaxWidth(25);
        }
    }

    public class JComponentCellEditor
    implements TableCellEditor,
    TreeCellEditor,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected JComponent editorComponent = null;
        protected JComponent container = null;

        public Component getComponent() {
            return this.editorComponent;
        }

        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            if (this.editorComponent != null && eventObject instanceof MouseEvent && ((MouseEvent)eventObject).getID() == 501) {
                Component component = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
                ((CopyButton)component).setSelected(true);
            }
            return false;
        }

        public boolean stopCellEditing() {
            return true;
        }

        public void cancelCellEditing() {
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.editorComponent = (JComponent)object;
            this.container = jTree;
            return this.editorComponent;
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editorComponent = (JComponent)object;
            this.container = jTable;
            return this.editorComponent;
        }
    }

    class JComponentCellRenderer
    implements TableCellRenderer {
        JComponentCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return (JComponent)object;
        }
    }

    class MyTable
    extends JTable {
        private static final long serialVersionUID = 1L;

        public MyTable() {
            super(new MyTableModel());
            this.setDefaultRenderer(JComponent.class, new JComponentCellRenderer());
            this.setDefaultEditor(JComponent.class, new JComponentCellEditor());
        }

        public TableCellRenderer getCellRenderer(int n, int n2) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            TableCellRenderer tableCellRenderer = tableColumn.getCellRenderer();
            if (tableCellRenderer == null) {
                Object object;
                Class<?> clazz = this.getColumnClass(n2);
                if (clazz.equals(Object.class) && (object = this.getValueAt(n, n2)) != null) {
                    clazz = this.getValueAt(n, n2).getClass();
                }
                tableCellRenderer = this.getDefaultRenderer(clazz);
            }
            return tableCellRenderer;
        }

        public TableCellEditor getCellEditor(int n, int n2) {
            TableColumn tableColumn = this.getColumnModel().getColumn(n2);
            TableCellEditor tableCellEditor = tableColumn.getCellEditor();
            if (tableCellEditor == null) {
                Object object;
                Class<?> clazz = this.getColumnClass(n2);
                if (clazz.equals(Object.class) && (object = this.getValueAt(n, n2)) != null) {
                    clazz = this.getValueAt(n, n2).getClass();
                }
                tableCellEditor = this.getDefaultEditor(clazz);
            }
            return tableCellEditor;
        }
    }

    protected class MyPropertiesWindow
    extends PropertiesWindow {
        private static final long serialVersionUID = 1L;
        protected Configurable myTarget;
        protected TranslateWindow owningWindow;

        public MyPropertiesWindow(Frame frame, boolean bl, Configurable configurable, HelpWindow helpWindow, TranslateWindow translateWindow2) {
            super(frame, bl, configurable, helpWindow);
            this.myTarget = configurable;
            this.owningWindow = translateWindow2;
        }

        public void save() {
            super.save();
            this.owningWindow.refreshTranslationList(this.myTarget);
        }

        public void cancel() {
            this.dispose();
        }
    }
}

