/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.i18n.LocaleConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.i18n.VassalResourceBundle;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translation
extends AbstractConfigurable
implements Comparable<Translation> {
    public static final String LOCALE = "locale";
    protected Locale locale = new Locale(Locale.getDefault().getLanguage());
    protected boolean dirty = false;
    protected Properties localProperties;

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Locale:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{LocalePrompt.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{LOCALE};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (LOCALE.equals(string)) {
            return LocaleConfigurer.localeToString(this.locale);
        }
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (LOCALE.equals(string)) {
            this.locale = LocaleConfigurer.stringToLocale((String)object);
            this.setConfigureName(this.locale.getDisplayName());
        }
    }

    protected String getDescription() {
        return this.locale.getDisplayName(Locale.getDefault());
    }

    public String getLanguageCode() {
        return this.locale.getLanguage();
    }

    @Override
    public String getConfigureName() {
        return this.getDescription();
    }

    @Override
    public Class[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    @Override
    public void removeFrom(Buildable buildable) {
        Localization.getInstance().removeTranslation(this);
    }

    @Override
    public void addTo(Buildable buildable) {
        Localization.getInstance().addTranslation(this);
        if (!GameModule.getGameModule().isLocalizationEnabled()) {
            try {
                this.loadProperties();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setProperty(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            this.getProperties().remove(string);
        } else {
            this.getProperties().setProperty(string, string2);
        }
        this.dirty = true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String translate(String string) {
        return this.getProperties().getProperty(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadProperties() throws IOException {
        if (this.localProperties == null) {
            this.localProperties = new Properties();
        }
        if (GameModule.getGameModule() != null) {
            BufferedInputStream bufferedInputStream = null;
            try {
                try {
                    bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getInputStream(this.getBundleFileName()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.dirty = false;
                    IOUtils.closeQuietly(bufferedInputStream);
                    return;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            this.localProperties.load(bufferedInputStream);
            bufferedInputStream.close();
            IOUtils.closeQuietly(bufferedInputStream);
        }
        this.dirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VassalResourceBundle getBundle() throws IOException {
        VassalResourceBundle vassalResourceBundle;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(GameModule.getGameModule().getDataArchive().getInputStream(this.getBundleFileName()));
            VassalResourceBundle vassalResourceBundle2 = new VassalResourceBundle(bufferedInputStream);
            bufferedInputStream.close();
            vassalResourceBundle = vassalResourceBundle2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedInputStream);
        return vassalResourceBundle;
    }

    public void reloadProperties() throws IOException {
        this.localProperties = new Properties();
        this.loadProperties();
    }

    protected void saveProperties() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.getProperties().store(byteArrayOutputStream, "Module translation");
        ArchiveWriter archiveWriter = GameModule.getGameModule().getArchiveWriter();
        if (archiveWriter != null) {
            archiveWriter.addFile(this.getBundleFileName(), byteArrayOutputStream.toByteArray());
            this.dirty = false;
        }
    }

    public Properties getProperties() {
        if (this.localProperties == null) {
            try {
                this.loadProperties();
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, this.getBundleFileName());
                this.localProperties = new Properties();
            }
        }
        return this.localProperties;
    }

    public String getBundleName() {
        return Resources.MODULE_BUNDLE + "_" + this.locale.getLanguage() + (this.locale.getCountry().length() > 0 ? "_" + this.locale.getCountry() : "");
    }

    public String getBundleFileName() {
        return this.getBundleName() + ".properties";
    }

    @Override
    public int compareTo(Translation translation) {
        return this.getDescription().compareTo(translation.getDescription());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public static class LocalePrompt
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new LocaleConfigurer(string, string2, "");
        }
    }
}

