/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.launch.Command;
import VASSAL.launch.CommandClient;
import VASSAL.launch.CommandServer;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.ReadOnlyPrefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FutureUtils;
import VASSAL.tools.MemoryUtils;
import VASSAL.tools.StringUtils;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ModuleFileFilter;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.LogEntry;
import VASSAL.tools.logging.Logger;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.jdesktop.swingworker.SwingWorker;

public abstract class AbstractLaunchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    protected static final int PHYS_MEMORY;
    protected static final int DEFAULT_INITIAL_HEAP = 256;
    protected static final int DEFAULT_MAXIMUM_HEAP = 512;
    protected static final int FAILSAFE_INITIAL_HEAP = 64;
    protected static final int FAILSAFE_MAXIMUM_HEAP = 128;
    protected final Window window;
    protected final String entryPoint;
    protected final LaunchRequest lr;
    protected static final Set<File> editing;
    protected static final Map<File, Integer> using;
    protected static final List<CommandClient> children;
    protected static final AtomicInteger nextId;

    public AbstractLaunchAction(String string, Window window, String string2, LaunchRequest launchRequest) {
        super(string);
        this.window = window;
        this.entryPoint = string2;
        this.lr = launchRequest;
    }

    public static boolean isInUse(File file) {
        return using.containsKey(file);
    }

    public static boolean isEditing(File file) {
        return editing.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutDown() {
        ModuleManagerWindow.getInstance().toBack();
        List<CommandClient> list = children;
        synchronized (list) {
            for (CommandClient commandClient : children) {
                try {
                    if (!"NOK".equals(commandClient.request(new Launcher.CloseRequest()))) continue;
                    return false;
                }
                catch (EOFException eOFException) {
                }
                catch (SocketException socketException) {
                }
                catch (IOException iOException) {
                    ErrorDialog.showDetails(iOException, ThrowableUtils.getStackTrace(iOException), "Error.socket_error", new Object[0]);
                }
            }
        }
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setWaitCursor(true);
        this.getLaunchTask().execute();
    }

    protected void setWaitCursor(boolean bl) {
        this.window.setCursor(Cursor.getPredefinedCursor(bl ? 3 : 0));
    }

    protected abstract LaunchTask getLaunchTask();

    protected File promptForFile() {
        FileChooser fileChooser = FileChooser.createFileChooser(this.window, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        this.addFileFilters(fileChooser);
        if (fileChooser.showOpenDialog() == 0) {
            this.lr.module = fileChooser.getSelectedFile();
            if (this.lr.module != null) {
                if (this.lr.module.exists()) {
                    AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(this.lr.module);
                    if (abstractMetaData == null || !(abstractMetaData instanceof ModuleMetaData)) {
                        ErrorDialog.show("Error.invalid_vassal_module", this.lr.module.getAbsolutePath());
                        Logger.log("-- Load of " + this.lr.module.getAbsolutePath() + " failed: Not a Vassal module");
                        this.lr.module = null;
                    }
                } else {
                    this.lr.module = null;
                }
            }
        }
        return this.lr.module;
    }

    protected void addFileFilters(FileChooser fileChooser) {
        fileChooser.addChoosableFileFilter(new ModuleFileFilter());
    }

    static {
        long l = MemoryUtils.getPhysicalMemory();
        PHYS_MEMORY = l < 0L ? -1 : (int)(l >> 20);
        editing = Collections.synchronizedSet(new HashSet());
        using = Collections.synchronizedMap(new HashMap());
        children = Collections.synchronizedList(new ArrayList());
        nextId = new AtomicInteger(1);
    }

    private static class StreamPump
    implements Runnable {
        private final InputStream in;
        private final OutputStream out;

        public StreamPump(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
        }

        public void run() {
            try {
                IOUtils.copy(this.in, this.out);
            }
            catch (IOException iOException) {
                ErrorDialog.showDetails(iOException, ThrowableUtils.getStackTrace(iOException), "Error.socket_error", new Object[0]);
            }
        }
    }

    private class LaunchCommandServer
    extends CommandServer {
        public LaunchCommandServer(ServerSocket serverSocket) {
            super(serverSocket);
        }

        public void init(Command command) {
            if (command instanceof LaunchCommand) {
                ((LaunchCommand)command).init(AbstractLaunchAction.this);
            }
        }
    }

    public static class EnqueueLogEntry
    implements Command {
        private static final long serialVersionUID = 1L;
        private final LogEntry entry;

        public EnqueueLogEntry(LogEntry logEntry) {
            this.entry = logEntry;
        }

        public Object execute() {
            Future<?> future = Logger.enqueue(this.entry);
            if (this.entry.wait) {
                FutureUtils.wait(future);
            }
            return "OK";
        }
    }

    public static class NotifySaveFileOk
    implements Command {
        private static final long serialVersionUID = 1L;
        private final File file;

        public NotifySaveFileOk(File file) {
            this.file = file;
        }

        public Object execute() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow.getInstance().update(NotifySaveFileOk.this.file);
                }
            });
            return "OK";
        }
    }

    public static class NotifyOpenModuleFailed
    extends LaunchCommand {
        private static final long serialVersionUID = 1L;
        private final Throwable thrown;

        public NotifyOpenModuleFailed(Throwable throwable) {
            this.thrown = throwable;
        }

        public Object execute() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NotifyOpenModuleFailed.this.theLaunchAction.setWaitCursor(false);
                }
            });
            ErrorDialog.showDetails(this.thrown, ThrowableUtils.getStackTrace(this.thrown), "Error.module_load_failed", this.thrown.getMessage());
            return "OK";
        }
    }

    public static class NotifyImportModuleOk
    extends LaunchCommand {
        private static final long serialVersionUID = 1L;

        public Object execute() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NotifyImportModuleOk.this.theLaunchAction.setWaitCursor(false);
                }
            });
            return "OK";
        }
    }

    public static class NotifyNewModuleOk
    extends LaunchCommand {
        private static final long serialVersionUID = 1L;

        public Object execute() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    NotifyNewModuleOk.this.theLaunchAction.setWaitCursor(false);
                }
            });
            return "OK";
        }
    }

    public static class NotifyOpenModuleOk
    extends LaunchCommand {
        private static final long serialVersionUID = 1L;

        public Object execute() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ModuleManagerWindow.getInstance().addModule(NotifyOpenModuleOk.this.theLaunchAction.lr.module);
                    NotifyOpenModuleOk.this.theLaunchAction.setWaitCursor(false);
                }
            });
            return "OK";
        }
    }

    private static abstract class LaunchCommand
    implements Command {
        private static final long serialVersionUID = 1L;
        protected AbstractLaunchAction theLaunchAction;

        private LaunchCommand() {
        }

        public void init(AbstractLaunchAction abstractLaunchAction) {
            this.theLaunchAction = abstractLaunchAction;
        }

        public abstract Object execute();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LaunchTask
    extends SwingWorker<Void, Void> {
        protected final int id = nextId.getAndIncrement();
        protected final LaunchRequest lr;
        protected ServerSocket serverSocket;
        protected Socket clientSocket;
        protected CommandClient cmdC;
        protected CommandServer cmdS;

        protected LaunchTask() {
            this.lr = new LaunchRequest(AbstractLaunchAction.this.lr);
            this.serverSocket = null;
            this.clientSocket = null;
            this.cmdC = null;
            this.cmdS = null;
        }

        public Void doInBackground() throws InterruptedException, IOException {
            Object object;
            Object object2;
            String[] stringArray;
            Object object3;
            Object object4;
            if (this.lr.module != null) {
                Logger.log("-- Loading module file " + this.lr.module.getAbsolutePath());
            }
            if (this.lr.game != null) {
                Logger.log("-- Loading game file " + this.lr.game.getAbsolutePath());
            }
            if (this.lr.importFile != null) {
                Logger.log("-- Importing module file " + this.lr.importFile.getAbsolutePath());
            }
            int n = 256;
            int n2 = 512;
            String string = null;
            if (this.lr.module != null) {
                object4 = MetaDataFactory.buildMetaData(this.lr.module);
                if (object4 == null) {
                    ErrorDialog.show("Error.invalid_vassal_file", this.lr.module.getAbsolutePath());
                    AbstractLaunchAction.this.setWaitCursor(false);
                    return null;
                }
                if (object4 instanceof ModuleMetaData) {
                    string = ((ModuleMetaData)object4).getName();
                    Logger.log("-- Loading module " + string);
                    object3 = new ReadOnlyPrefs(string);
                    n = this.getHeapSize((ReadOnlyPrefs)object3, "initialHeap", 256);
                    n2 = this.getHeapSize((ReadOnlyPrefs)object3, "maximumHeap", 512);
                }
            } else if (this.lr.importFile != null) {
                object4 = Prefs.getGlobalPrefs();
                n = this.getHeapSize((Prefs)object4, "initialHeap", 256);
                n2 = this.getHeapSize((Prefs)object4, "maximumHeap", 512);
            }
            if (n2 > PHYS_MEMORY && PHYS_MEMORY > 0) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            } else if (n2 < 128) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_small", 128));
            } else if (n < 64) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.initial_heap_too_small", 64));
            } else if (n > n2) {
                n = 64;
                n2 = 128;
                FutureUtils.wait(WarningDialog.show("Warning.initial_heap_too_large", 64));
            }
            this.serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
            this.cmdS = new LaunchCommandServer(this.serverSocket);
            new Thread((Runnable)this.cmdS, "command server " + this.id).start();
            object4 = new ArrayList<String>();
            ((ArrayList)object4).add(Info.javaBinPath);
            ((ArrayList)object4).add("");
            ((ArrayList)object4).add("");
            ((ArrayList)object4).add("-DVASSAL.id=" + this.id);
            object3 = System.getProperty("user.home");
            if (object3 != null) {
                ((ArrayList)object4).add("-Duser.home=" + (String)object3);
            }
            ((ArrayList)object4).add("-cp");
            ((ArrayList)object4).add(System.getProperty("java.class.path"));
            if (Info.isMacOSX()) {
                stringArray = string != null && string.length() > 0 ? string : "Unnamed module";
                object2 = new File(Info.getBaseDir(), "Contents/Resources/VASSAL.icns").getAbsolutePath();
                ((ArrayList)object4).add("-Xdock:name=" + (String)stringArray);
                ((ArrayList)object4).add("-Xdock:icon=" + (String)object2);
                object = (Boolean)Prefs.getGlobalPrefs().getValue("disableD3d");
                ((ArrayList)object4).add("-Dapple.awt.graphics.UseQuartz=" + (Boolean.TRUE.equals(object) ? "false" : "true"));
            } else if (Info.isWindows() && Boolean.TRUE.equals(stringArray = (Boolean)Prefs.getGlobalPrefs().getValue("disableD3d"))) {
                ((ArrayList)object4).add("-Dsun.java2d.d3d=false");
            }
            ((ArrayList)object4).add(AbstractLaunchAction.this.entryPoint);
            stringArray = ((ArrayList)object4).toArray(new String[((ArrayList)object4).size()]);
            stringArray[1] = "-Xms" + n + "M";
            stringArray[2] = "-Xmx" + n2 + "M";
            object2 = this.launch(stringArray);
            if (object2 == null) {
                stringArray[1] = "-Xms64M";
                stringArray[2] = "-Xmx128M";
                object2 = this.launch(stringArray);
                if (object2 == null) {
                    throw new IOException("failed to start child process");
                }
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            }
            object = new DataInputStream(((Process)object2).getInputStream());
            int n3 = ((DataInputStream)object).readInt();
            new Thread((Runnable)new StreamPump(((Process)object2).getErrorStream(), System.err), "err pump " + this.id).start();
            new Thread((Runnable)new StreamPump(((Process)object2).getInputStream(), System.out), "out pump " + this.id).start();
            if (n3 < 0 || n3 > 65535) {
                throw new IOException("port out of range: " + n3);
            }
            this.clientSocket = new Socket((String)null, n3);
            this.cmdC = new CommandClient(this.clientSocket);
            children.add(this.cmdC);
            ((Process)object2).waitFor();
            return null;
        }

        protected int getHeapSize(ReadOnlyPrefs readOnlyPrefs, String string, int n) {
            String string2 = readOnlyPrefs.getStoredValue(string);
            if (string2 == null) {
                return n;
            }
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        protected int getHeapSize(Prefs prefs, String string, int n) {
            Object object = prefs.getValue(string);
            if (object == null) {
                return n;
            }
            try {
                return Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Process launch(String[] stringArray) throws IOException {
            Logger.log(StringUtils.join(stringArray, " "));
            ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
            processBuilder.directory(Info.getBinDir());
            Process process = processBuilder.start();
            ObjectOutputStream objectOutputStream = null;
            try {
                objectOutputStream = new ObjectOutputStream(process.getOutputStream());
                objectOutputStream.writeInt(this.serverSocket.getLocalPort());
                objectOutputStream.writeObject(this.lr);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objectOutputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(objectOutputStream);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                process.exitValue();
                Logger.log(IOUtils.toString(process.getErrorStream()));
                return null;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                return process;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void done() {
            try {
                this.get();
            }
            catch (CancellationException cancellationException) {
                ErrorDialog.bug(cancellationException);
            }
            catch (InterruptedException interruptedException) {
                ErrorDialog.bug(interruptedException);
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof IOException) {
                    ErrorDialog.showDetails(executionException, ThrowableUtils.getStackTrace(executionException), "Error.socket_error", new Object[0]);
                } else {
                    ErrorDialog.bug(executionException);
                }
            }
            finally {
                IOUtils.closeQuietly(this.clientSocket);
                IOUtils.closeQuietly(this.serverSocket);
                children.remove(this.cmdC);
            }
        }
    }
}

