/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.PluginsLoader;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.gamepieceimage.GamePieceImageDefinitions;
import VASSAL.build.module.properties.GlobalProperties;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.DynamicClientFactory;
import VASSAL.chat.HybridClient;
import VASSAL.chat.ServerConfigurer;
import VASSAL.chat.jabber.JabberClientFactory;
import VASSAL.chat.node.NodeClientFactory;
import VASSAL.chat.peer2peer.P2PClientFactory;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Language;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PositionOption;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ReflectionUtils;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.menu.MenuManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicModule
extends GameModule {
    public static final String PREFER_MEMORY_MAPPED = "preferMemoryMapped";
    public static final String SCALER_ALGORITHM = "scalerAlgorithm";
    private static char COMMAND_SEPARATOR = (char)27;
    protected ChatServerControls serverControls;

    public BasicModule(DataArchive dataArchive) {
        super(dataArchive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void build() throws IOException {
        BufferedInputStream bufferedInputStream;
        block7: {
            bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(this.getDataArchive().getInputStream("buildFile"));
            }
            catch (IOException iOException) {
                if (!new File(this.getDataArchive().getName()).exists()) break block7;
                throw new IOException(Resources.getString("BasicModule.not_a_module"));
            }
        }
        if (bufferedInputStream == null) {
            this.build(null);
        } else {
            try {
                Document document = Builder.createDocument(bufferedInputStream);
                this.build(document.getDocumentElement());
                bufferedInputStream.close();
            }
            finally {
                IOUtils.closeQuietly(bufferedInputStream);
            }
        }
        MenuManager.getInstance().addAction("Prefs.edit_preferences", this.getPrefs().getEditor().getEditAction());
    }

    @Override
    public void build(Element element) {
        if (element != null) {
            this.gameName = element.getAttribute("name");
            if (element.getAttribute("VassalVersion").length() > 0) {
                this.vassalVersionCreated = element.getAttribute("VassalVersion");
            }
        }
        this.initIdentityPreferences();
        this.initImagePreferences();
        Prefs.initSharedGlobalPrefs();
        this.initGameState();
        this.initLogger();
        this.initServer();
        new PluginsLoader().addTo(this);
        if (element != null) {
            super.build(element);
            this.ensureComponent(GamePieceImageDefinitions.class);
            this.ensureComponent(GlobalProperties.class);
            this.ensureComponent(Language.class);
        } else {
            this.buildDefaultComponents();
        }
        this.initFrame();
    }

    protected void initIdentityPreferences() {
        StringConfigurer stringConfigurer = new StringConfigurer("RealName", Resources.getString("Prefs.name_label"), Resources.getString("Prefs.newbie"));
        TextConfigurer textConfigurer = new TextConfigurer("Profile", Resources.getString("Prefs.personal_info"), "");
        PasswordConfigurer passwordConfigurer = new PasswordConfigurer("SecretName", Resources.getString("Prefs.password_label"), Resources.getString("Prefs.password_prompt", System.getProperty("user.name")));
        passwordConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                GameModule.setUserId((String)propertyChangeEvent.getNewValue());
            }
        });
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), stringConfigurer);
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), passwordConfigurer);
        GameModule.getGameModule().getPrefs().addOption(Resources.getString("Prefs.personal_tab"), textConfigurer);
        GameModule.setUserId(passwordConfigurer.getValueString());
    }

    protected void initImagePreferences() {
        final BooleanConfigurer booleanConfigurer = new BooleanConfigurer(PREFER_MEMORY_MAPPED, "Prefer memory-mapped files for large images?", Boolean.FALSE);
        booleanConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImageUtils.setPreferMemoryMappedFiles(Boolean.TRUE.equals(booleanConfigurer.getValue()));
            }
        });
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer);
        final BooleanConfigurer booleanConfigurer2 = new BooleanConfigurer(SCALER_ALGORITHM, "High-quality scaling?", Boolean.TRUE);
        booleanConfigurer2.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ImageUtils.setHighQualityScaling(Boolean.TRUE.equals(booleanConfigurer2.getValue()));
            }
        });
        GameModule.getGameModule().getPrefs().addOption(booleanConfigurer2);
    }

    protected void initServer() {
        DynamicClientFactory dynamicClientFactory = new DynamicClientFactory();
        ChatServerFactory.register("default", dynamicClientFactory);
        ChatServerFactory.register("node", NodeClientFactory.getInstance());
        ChatServerFactory.register("dynamic", dynamicClientFactory);
        ChatServerFactory.register("peer2peer", new P2PClientFactory());
        ChatServerFactory.register("jabber", new JabberClientFactory());
        this.server = new HybridClient();
        ServerConfigurer serverConfigurer = new ServerConfigurer("ServerImpl", "Server", (HybridClient)this.server);
        Prefs.getGlobalPrefs().addOption(Resources.getString("Chat.server"), serverConfigurer);
        this.serverControls = new ChatServerControls();
        this.serverControls.addTo(this);
    }

    protected void initLogger() {
        this.logger = new BasicLogger();
        ((BasicLogger)this.logger).build(null);
        ((BasicLogger)this.logger).addTo(this);
    }

    protected void initGameState() {
        this.theState = new GameState();
        this.theState.addTo(this);
        this.addCommandEncoder(this.theState);
    }

    @Override
    public Command decode(String string) {
        if (string == null) {
            return null;
        }
        Command command = null;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, COMMAND_SEPARATOR);
        String string2 = decoder.nextToken();
        if (string.equals(string2)) {
            command = this.decodeSubCommand(string2);
        } else {
            Command command2 = null;
            command = this.decode(string2);
            while (decoder.hasMoreTokens()) {
                command2 = this.decode(decoder.nextToken());
                command = command == null ? command2 : command.append(command2);
            }
        }
        return command;
    }

    private Command decodeSubCommand(String string) {
        Command command = null;
        for (int i = 0; i < this.commandEncoders.length && command == null; ++i) {
            command = this.commandEncoders[i].decode(string);
        }
        return command;
    }

    @Override
    public String encode(Command command) {
        if (command == null) {
            return null;
        }
        String string = this.encodeSubCommand(command);
        Command[] commandArray = command.getSubCommands();
        if (commandArray.length > 0) {
            SequenceEncoder sequenceEncoder = new SequenceEncoder(string, COMMAND_SEPARATOR);
            for (int i = 0; i < commandArray.length; ++i) {
                String string2 = this.encode(commandArray[i]);
                if (string2 == null) continue;
                sequenceEncoder.append(string2);
            }
            string = sequenceEncoder.getValue();
        }
        return string;
    }

    private String encodeSubCommand(Command command) {
        String string = null;
        for (int i = 0; i < this.commandEncoders.length && string == null; ++i) {
            string = this.commandEncoders[i].encode(command);
        }
        return string;
    }

    protected void buildDefaultComponents() {
        this.addComponent(BasicCommandEncoder.class);
        this.addComponent(Documentation.class);
        this.addComponent(PlayerRoster.class);
        this.addComponent(GlobalOptions.class);
        this.addComponent(Map.class);
        this.addComponent(GamePieceImageDefinitions.class);
        this.addComponent(GlobalProperties.class);
        this.addComponent(PrototypesContainer.class);
        this.addComponent(PieceWindow.class);
        this.addComponent(Chatter.class);
        this.addComponent(Language.class);
    }

    protected void initFrame() {
        Rectangle rectangle = Info.getScreenBounds(this.frame);
        if (GlobalOptions.getInstance().isUseSingleWindow()) {
            this.frame.setLocation(rectangle.getLocation());
            this.frame.setSize(rectangle.width, rectangle.height / 3);
        } else {
            Rectangle rectangle2 = new Rectangle(0, 0, rectangle.width, rectangle.height / 4);
            this.getPrefs().addOption(new PositionOption("BoundsOfGameModule", this.frame, rectangle2));
        }
        String string = Resources.getString("BasicModule.version_message", this.getLocalizedGameName(), this.moduleVersion);
        this.warn(string);
        System.err.println("-- " + string);
        this.initFrameTitle();
    }

    protected void ensureComponent(Class<? extends Buildable> clazz) {
        if (this.getComponentsOf(clazz).isEmpty()) {
            this.addComponent(clazz);
        }
    }

    protected void addComponent(Class<? extends Buildable> clazz) {
        Buildable buildable = null;
        try {
            buildable = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            ReflectionUtils.handleNewInstanceFailure(throwable, clazz);
        }
        if (buildable != null) {
            buildable.build(null);
            buildable.addTo(this);
            this.add(buildable);
        }
    }

    public ChatServerControls getServerControls() {
        return this.serverControls;
    }

    @Override
    public String getI18nPrefix() {
        return "";
    }
}

