/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.i18n.Resources;
import VASSAL.launch.AbstractLaunchAction;
import VASSAL.launch.Command;
import VASSAL.launch.CommandClient;
import VASSAL.launch.CommandServer;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.MacOSXStartUp;
import VASSAL.launch.StartUp;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.logging.CommandClientAdapter;
import VASSAL.tools.logging.LogOutputStreamAdapter;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.logging.Logger;
import VASSAL.tools.menu.MenuManager;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.SwingUtilities;

public abstract class Launcher {
    protected CommandClient cmdC = null;
    protected CommandServer cmdS = null;
    protected final LaunchRequest lr;
    private static Launcher instance = null;

    public static Launcher getInstance() {
        return instance;
    }

    protected Launcher(String[] stringArray) {
        Object object;
        StartUp startUp;
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        boolean bl = stringArray.length > 0;
        LaunchRequest launchRequest = null;
        if (bl) {
            try {
                launchRequest = LaunchRequest.parseArgs(stringArray);
            }
            catch (LaunchRequestException launchRequestException) {
                System.err.println("VASSAL: " + launchRequestException.getMessage());
                System.exit(1);
            }
        }
        StartUp startUp2 = startUp = Info.isMacOSX() ? new MacOSXStartUp() : new StartUp();
        if (bl) {
            object = new File(Info.getHomeDir(), "errorLog");
            try {
                Logger.addLogListener(new LogOutputStreamAdapter(new FileOutputStream((File)object)));
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, (File)object);
            }
        }
        startUp.startErrorLog();
        System.setErr(new PrintStream(new LoggedOutputStream(Info.getInstanceID()), true));
        Logger.log("-- " + this.getClass().getSimpleName());
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        startUp.initSystemProperties();
        if (!bl) {
            try {
                object = new ServerSocket(0, 0, InetAddress.getByName(null));
                this.cmdS = new CommandServer((ServerSocket)object);
                new Thread((Runnable)this.cmdS, "command server").start();
                DataOutputStream dataOutputStream = new DataOutputStream(System.out);
                dataOutputStream.writeInt(((ServerSocket)object).getLocalPort());
                dataOutputStream.flush();
                ObjectInputStream objectInputStream = new ObjectInputStream(System.in);
                int n = objectInputStream.readInt();
                launchRequest = (LaunchRequest)objectInputStream.readObject();
                this.cmdC = new CommandClient(new Socket((String)null, n));
                Logger.addLogListener(new CommandClientAdapter(this.cmdC));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ErrorDialog.bug(classNotFoundException);
                System.exit(1);
            }
            catch (IOException iOException) {
                ErrorDialog.show(iOException, "Error.communication_error", Resources.getString(this.getClass().getSimpleName() + ".app_name"));
                System.exit(1);
            }
        }
        this.lr = launchRequest;
        this.createMenuManager();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Launcher.this.launch();
                }
                catch (ExtensionsLoader.LoadExtensionException loadExtensionException) {
                    this.warn(loadExtensionException);
                }
                catch (IOException iOException) {
                    this.warn(iOException);
                }
            }

            private void warn(Exception exception) {
                if (Launcher.this.cmdC == null) {
                    ErrorDialog.showDetails(exception, ThrowableUtils.getStackTrace(exception), "Error.module_load_failed", exception.getMessage());
                } else {
                    try {
                        Launcher.this.cmdC.request(new AbstractLaunchAction.NotifyOpenModuleFailed(exception));
                    }
                    catch (IOException iOException) {
                        ErrorDialog.showDetails(exception, ThrowableUtils.getStackTrace(exception), "Error.module_load_failed", exception.getMessage());
                        ErrorDialog.show(iOException, "Error.communication_error", Resources.getString(this.getClass().getSimpleName() + ".app_name"));
                    }
                }
                System.exit(1);
            }
        });
    }

    protected abstract void launch() throws IOException;

    protected abstract MenuManager createMenuManager();

    public void sendSaveCmd(File file) {
        if (this.cmdC != null) {
            try {
                this.cmdC.request(new AbstractLaunchAction.NotifySaveFileOk(file));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class CloseRequest
    implements Command {
        private static final long serialVersionUID = 1L;
        private boolean shutdown = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() {
            final GameModule gameModule = GameModule.getGameModule();
            if (gameModule != null) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        public void run() {
                            gameModule.getFrame().toFront();
                            CloseRequest.this.shutdown = gameModule.shutDown();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    Logger.log(interruptedException);
                    this.shutdown = false;
                }
                catch (InvocationTargetException invocationTargetException) {
                    ErrorDialog.bug(invocationTargetException);
                    this.shutdown = false;
                }
            }
            try {
                String string = this.shutdown ? "OK" : "NOK";
                return string;
            }
            finally {
                if (this.shutdown) {
                    System.exit(0);
                }
            }
        }
    }
}

