/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsLoader;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.BasicModule;
import VASSAL.launch.GameModuleAction;
import VASSAL.preferences.Prefs;
import VASSAL.tools.DataArchive;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;

public class LoadModuleAction
extends GameModuleAction {
    private static final long serialVersionUID = 1L;
    private File moduleFile;
    protected FileChooser fc;

    public LoadModuleAction(Component component) {
        super(Resources.getString("Main.play_module"), component);
    }

    public LoadModuleAction(File file) {
        super(Resources.getString("Main.play_module"), (Component)null);
        this.moduleFile = file;
    }

    public void performAction(ActionEvent actionEvent) throws IOException {
        this.actionCancelled = true;
        File file = this.moduleFile;
        if (file == null) {
            File file2;
            if (this.fc == null) {
                this.fc = FileChooser.createFileChooser(this.comp, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
            }
            if (this.fc.showOpenDialog() == 0 && (file2 = this.fc.getSelectedFile()) != null && file2.exists()) {
                file = file2;
            }
            if (file == null) {
                return;
            }
        }
        this.loadModule(file);
        this.actionCancelled = false;
    }

    protected void loadModule(File file) throws IOException {
        GameModule.init(new BasicModule(new DataArchive(file.getPath())));
        Localization.getInstance().translate();
        new ExtensionsLoader().addTo(GameModule.getGameModule());
        GameModule.getGameModule().getWizardSupport().showWelcomeWizard();
    }
}

