/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import java.awt.Component;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicPreference
extends AbstractConfigurable {
    public static final String NAME = "name";
    public static final String TAB = "tab";
    public static final String DESC = "desc";
    public static final String DEFAULT = "default";
    protected String tabName = "";
    protected String variableName = "";
    protected MutableProperty.Impl property = new MutableProperty.Impl("", this);

    public BasicPreference() {
        this.tabName = GameModule.getGameModule().getConfigureName();
        this.setAttributeTranslatable(NAME, false);
        this.setAttributeTranslatable(DEFAULT, false);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"note", TAB, DESC, NAME, DEFAULT};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"", "Preference Tab Name:  ", "Preference Description:  ", "Global Variable Name:  ", "Default Value:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{NoteConfig.class, String.class, String.class, String.class, this.getDefaultClass()};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.variableName = (String)object;
            this.property.setPropertyName(this.variableName);
        } else if (TAB.equals(string)) {
            this.tabName = (String)object;
        } else if (DESC.equals(string)) {
            this.setConfigureName((String)object);
        } else if (DEFAULT.equals(string)) {
            this.setDefaultValue(object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getVariableName();
        }
        if (TAB.equals(string)) {
            return this.tabName;
        }
        if (DESC.equals(string)) {
            return this.getConfigureName();
        }
        if (DEFAULT.equals(string)) {
            return this.getDefaultValue();
        }
        return null;
    }

    public abstract Class<?> getDefaultClass();

    public abstract String getDefaultValue();

    public abstract void setDefaultValue(Object var1);

    public abstract Configurer getPreferenceConfigurer();

    @Override
    public void addTo(Buildable buildable) {
        this.property.addTo(GameModule.getGameModule());
        if (this.tabName != null && this.tabName.length() > 0) {
            GameModule.getGameModule().getPrefs().addOption(this.tabName, this.getPreferenceConfigurer());
        }
        if (this.getVariableName().length() > 0) {
            this.updateGlobalProperty(GameModule.getGameModule().getPrefs().getStoredValue(this.getVariableName()));
        }
    }

    protected void updateGlobalProperty(String string) {
        this.property.setPropertyValue(string);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.property.removeFromContainer();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalOptions.htm");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public String getDescription() {
        return this.getConfigureName();
    }

    public String getVariableName() {
        return this.variableName;
    }

    public static class NoteConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new Configurer(null, "note"){

                public String getValueString() {
                    return null;
                }

                public void setValue(String string) {
                }

                public Component getControls() {
                    return new JLabel("Note:  The Preferences window will only be updated after you save and reload the module.");
                }
            };
        }
    }
}

