/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.Info;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.PrefsEditor;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Prefs
implements Closeable {
    public static final String MODULES_DIR_KEY = "modulesDir";
    public static final String DISABLE_D3D = "disableD3d";
    public static final String DISABLE_QUARTZ = "disableD3d";
    private static Prefs globalPrefs;
    private Map<String, Configurer> options = new HashMap<String, Configurer>();
    private Properties storedValues = new Properties();
    private PrefsEditor editor;
    private String name;
    private Set<String> changed = new HashSet<String>();
    private PropertyChangeListener changeListener;

    public Prefs(PrefsEditor prefsEditor, String string) {
        this.editor = prefsEditor;
        this.name = string;
        this.changeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Prefs.this.changed.add(propertyChangeEvent.getPropertyName());
            }
        };
        prefsEditor.addPrefs(this);
        this.init(string);
    }

    public PrefsEditor getEditor() {
        return this.editor;
    }

    public File getFile() {
        return new File(this.editor.getArchive().getName());
    }

    public void addOption(Configurer configurer) {
        this.addOption(Resources.getString("Prefs.general_tab"), configurer);
    }

    public void addOption(String string, Configurer configurer) {
        this.addOption(string, configurer, null);
    }

    public void addOption(String string, Configurer configurer, String string2) {
        if (configurer != null && this.options.get(configurer.getKey()) == null) {
            this.options.put(configurer.getKey(), configurer);
            String string3 = this.storedValues.getProperty(configurer.getKey());
            if (string3 != null) {
                configurer.setValue(string3);
                string2 = null;
            }
            if (string != null && configurer.getControls() != null) {
                this.editor.addOption(string, configurer, string2);
            }
        }
        configurer.addPropertyChangeListener(this.changeListener);
    }

    public void setValue(String string, Object object) {
        this.options.get(string).setValue(object);
    }

    public Configurer getOption(String string) {
        return this.options.get(string);
    }

    public Object getValue(String string) {
        Configurer configurer = this.options.get(string);
        return configurer == null ? null : configurer.getValue();
    }

    public String getStoredValue(String string) {
        return this.storedValues.getProperty(string);
    }

    public void init(String string) {
        this.name = string;
        this.read();
        this.editor.getArchive().closeWhenNotInUse();
        Enumeration<Object> enumeration = this.storedValues.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.storedValues.getProperty(string2);
            Configurer configurer = this.options.get(string2);
            if (configurer == null) continue;
            configurer.setValue(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void read() {
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(this.editor.getArchive().getInputStream(this.name));
            this.storedValues.clear();
            this.storedValues.load(bufferedInputStream);
            bufferedInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtils.closeQuietly(bufferedInputStream);
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, this.editor.getArchive().getName());
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bufferedInputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(bufferedInputStream);
        }
        IOUtils.closeQuietly(bufferedInputStream);
    }

    public void save() throws IOException {
        this.editor.getArchive().uncacheFile(this.name);
        this.read();
        for (Configurer configurer : this.options.values()) {
            if (!this.changed.contains(configurer.getKey())) continue;
            String string = configurer.getValueString();
            if (string != null) {
                this.storedValues.put(configurer.getKey(), string);
                continue;
            }
            this.storedValues.remove(configurer.getKey());
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.storedValues.store(byteArrayOutputStream, null);
        this.editor.getArchive().addFile(this.name, new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        this.changed.clear();
    }

    public void write() throws IOException {
        this.editor.write();
    }

    public void close() throws IOException {
        this.editor.close();
        if (this == globalPrefs) {
            globalPrefs = null;
        }
    }

    public static Prefs getGlobalPrefs() {
        if (globalPrefs == null) {
            File file = new File(Info.getHomeDir(), "Preferences");
            try {
                ArchiveWriter.ensureExists(file, "VASSAL");
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, file);
            }
            globalPrefs = new Prefs(new PrefsEditor(new ArchiveWriter(file.getPath())), "VASSAL");
            try {
                globalPrefs.write();
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, file);
            }
            DirectoryConfigurer directoryConfigurer = new DirectoryConfigurer(MODULES_DIR_KEY, null);
            directoryConfigurer.setValue(new File(System.getProperty("user.home")));
            globalPrefs.addOption(null, directoryConfigurer);
        }
        return globalPrefs;
    }

    public static void initSharedGlobalPrefs() {
        BooleanConfigurer booleanConfigurer;
        Prefs.getGlobalPrefs();
        if (Info.isWindows()) {
            booleanConfigurer = new BooleanConfigurer("disableD3d", Resources.getString("Prefs.disable_d3d"), Boolean.FALSE);
            globalPrefs.addOption(booleanConfigurer);
        }
        if (Info.isMacOSX()) {
            booleanConfigurer = new BooleanConfigurer("disableD3d", Resources.getString("Prefs.disable_quartz"), Boolean.TRUE);
            globalPrefs.addOption(booleanConfigurer);
        }
        booleanConfigurer = new BooleanConfigurer("welcomeWizard", Resources.getString("WizardSupport.ShowWizard"), Boolean.TRUE);
        globalPrefs.addOption(booleanConfigurer);
    }
}

