/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.IntConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ScrollPane;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class AdjustableSpeedScrollPane
extends ScrollPane {
    private static final long serialVersionUID = 1L;
    private static final String SCROLL_SPEED = "scrollSpeed";
    private static final int defaultSpeed = 50;

    public AdjustableSpeedScrollPane(Component component) {
        this(component, 20, 30);
    }

    public AdjustableSpeedScrollPane(Component component, int n, int n2) {
        super(component, n, n2);
        IntConfigurer intConfigurer = new IntConfigurer(SCROLL_SPEED, Resources.getString("AdjustableSpeedScrollPane.scroll_increment"), new Integer(50));
        intConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (AdjustableSpeedScrollPane.SCROLL_SPEED.equals(propertyChangeEvent.getPropertyName())) {
                    AdjustableSpeedScrollPane.this.setSpeed((Integer)propertyChangeEvent.getNewValue());
                }
            }
        });
        GameModule gameModule = GameModule.getGameModule();
        if (gameModule == null) {
            this.setSpeed(50);
        } else {
            Prefs prefs = gameModule.getPrefs();
            prefs.addOption(Resources.getString("Prefs.general_tab"), intConfigurer);
            this.setSpeed((Integer)prefs.getValue(SCROLL_SPEED));
        }
    }

    private void setSpeed(int n) {
        this.verticalScrollBar.setUnitIncrement(n);
        this.horizontalScrollBar.setUnitIncrement(n);
    }
}

