/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.DataArchive;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveWriter
extends DataArchive {
    private final Map<String, Object> files = new ConcurrentHashMap<String, Object>();
    private final ArrayList<String> removedImages = new ArrayList();
    private String archiveName;
    private boolean closeWhenNotInUse;

    public ArchiveWriter(String string) {
        File file;
        this.archiveName = string;
        this.closeWhenNotInUse = false;
        if (this.archiveName != null && (file = new File(this.archiveName)).exists()) {
            try {
                this.archive = new ZipFile(file);
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, this.archiveName);
            }
        }
    }

    public ArchiveWriter(String string, boolean bl) {
        this(string);
        this.closeWhenNotInUse();
    }

    public ArchiveWriter(ZipFile zipFile) {
        this.archive = zipFile;
        this.archiveName = zipFile.getName();
    }

    public void closeWhenNotInUse() {
        this.closeWhenNotInUse = true;
        if (this.archive != null) {
            try {
                this.archive.close();
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, this.archive.getName());
            }
            this.archive = null;
        }
    }

    public void addImage(String string, String string2) {
        if (string2.toLowerCase().endsWith(".svg")) {
            for (String string3 : SVGImageUtils.getExternalReferences(string)) {
                File file = new File(string3);
                String string4 = file.getName();
                this.files.put(this.imageDir + string4, file.getPath());
            }
        } else {
            this.files.put(this.imageDir + string2, string);
        }
        Op.load(string2).update();
        this.localImages = null;
    }

    public void addImage(String string, byte[] byArray) {
        this.files.put(this.imageDir + string, byArray);
        this.removedImages.remove(this.imageDir + string);
        this.localImages = null;
    }

    public void addSound(String string, String string2) {
        this.addFile(string, this.soundDir + string2);
    }

    public boolean isImageAdded(String string) {
        return this.files.containsKey(this.imageDir + string);
    }

    public void removeImage(String string) {
        String string2 = this.imageDir + string;
        this.files.remove(string2);
        if (!this.removedImages.contains(string2)) {
            this.removedImages.add(string2);
        }
        this.localImages = null;
    }

    public void uncacheFile(String string) {
        this.files.remove(string);
    }

    public void addFile(String string, String string2) {
        this.files.put(string2, string);
    }

    public void addFile(String string, InputStream inputStream) {
        try {
            this.files.put(string, IOUtils.toByteArray(inputStream));
        }
        catch (IOException iOException) {
            ReadErrorDialog.error(iOException, string);
        }
    }

    public void addFile(String string, byte[] byArray) {
        this.files.put(string, byArray);
    }

    private void openIfClosed() throws IOException {
        if (this.closeWhenNotInUse && this.archive == null && this.archiveName != null) {
            this.archive = new ZipFile(this.archiveName);
        }
    }

    @Override
    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        Object object = this.files.get(string);
        if (object instanceof String) {
            return new FileInputStream((String)object);
        }
        if (object instanceof byte[]) {
            return new ByteArrayInputStream((byte[])object);
        }
        this.openIfClosed();
        if (this.archive != null) {
            return super.getInputStream(string);
        }
        throw new FileNotFoundException(string + " not found");
    }

    @Override
    public URL getURL(String string) throws IOException, FileNotFoundException {
        Object object = this.files.get(string);
        if (object instanceof String) {
            return new URL("file", null, (String)object);
        }
        this.openIfClosed();
        if (this.archive != null) {
            return super.getURL(string);
        }
        throw new FileNotFoundException(string + " not found");
    }

    public void saveAs() throws IOException {
        this.saveAs(false);
    }

    public void saveAs(boolean bl) throws IOException {
        this.archiveName = null;
        this.write(bl);
    }

    public void write() throws IOException {
        this.write(false);
    }

    /*
     * Exception decompiling
     */
    public void write(boolean var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 11[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public SortedSet<String> getImageNameSet() {
        SortedSet<String> sortedSet = super.getImageNameSet();
        for (String string : this.files.keySet()) {
            if (!string.startsWith(this.imageDir)) continue;
            sortedSet.add(string.substring(this.imageDir.length()));
        }
        return sortedSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureExists(File file, String string) throws IOException {
        if (file.exists()) {
            return;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            zipOutputStream.putNextEntry(new ZipEntry(string));
            zipOutputStream.close();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(zipOutputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(zipOutputStream);
    }

    @Override
    @Deprecated
    protected SortedSet<String> setOfImageNames() {
        return this.getImageNameSet();
    }

    @Override
    @Deprecated
    protected void listImageNames(Collection collection) {
        collection.addAll(this.setOfImageNames());
    }

    @Override
    @Deprecated
    public InputStream getFileStream(String string) throws IOException {
        return this.getInputStream(string);
    }
}

