/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.SystemUtils;

public class BrowserSupport {
    private static final BrowserLauncher browserLauncher;
    private static final HyperlinkListener listener;

    public static void openURL(String string) {
        Desktop desktop;
        if (!SystemUtils.IS_JAVA_1_5 && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(string));
                return;
            }
            catch (IOException iOException) {
                if (!SystemUtils.IS_OS_WINDOWS) {
                    ErrorDialog.bug(iOException);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorDialog.bug(illegalArgumentException);
                return;
            }
            catch (URISyntaxException uRISyntaxException) {
                ErrorDialog.bug(uRISyntaxException);
                return;
            }
        }
        if (browserLauncher != null) {
            browserLauncher.openURLinBrowser(string);
        } else {
            ErrorDialog.show("BrowserSupport.unable_to_launch", string);
        }
    }

    public static HyperlinkListener getListener() {
        return listener;
    }

    static {
        BrowserLauncher browserLauncher = null;
        if (SystemUtils.IS_JAVA_1_5) {
            try {
                browserLauncher = new BrowserLauncher();
            }
            catch (BrowserLaunchingInitializingException browserLaunchingInitializingException) {
                ErrorDialog.bug(browserLaunchingInitializingException);
            }
            catch (UnsupportedOperatingSystemException unsupportedOperatingSystemException) {
                ErrorDialog.bug(unsupportedOperatingSystemException);
            }
        }
        BrowserSupport.browserLauncher = browserLauncher;
        listener = new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    BrowserSupport.openURL(hyperlinkEvent.getURL().toString());
                }
            }
        };
    }
}

