/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.i18n.Resources;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.BugUtils;
import VASSAL.tools.swing.DetailsButton;
import VASSAL.tools.swing.FlowLabel;
import VASSAL.tools.version.VassalVersion;
import VASSAL.tools.version.VersionUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingworker.SwingWorker;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXHeader;

public class BugDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private Throwable thrown;
    private String errorLog;
    private JPanel contents;
    private CardLayout deck;
    private JPanel buttons;
    private CardLayout button_deck;
    private JTextArea descriptionArea;
    private JTextField emailField;
    private JScrollPane descriptionScroll;
    private CheckRequest checkRequest = null;
    private SendRequest sendRequest = null;

    public BugDialog(Frame frame, Throwable throwable) {
        super(frame, true);
        this.thrown = throwable;
        this.errorLog = BugUtils.getErrorLog();
        JXHeader jXHeader = new JXHeader(Resources.getString("BugDialog.heading"), Resources.getString("BugDialog.message"), (Icon)new ImageIcon(BugDialog.class.getResource("/icons/48x48/bug.png")));
        this.setTitle(Resources.getString("BugDialog.title"));
        this.setLocationRelativeTo(frame);
        this.setDefaultCloseOperation(2);
        this.setResizable(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (BugDialog.this.checkRequest != null) {
                    BugDialog.this.checkRequest.cancel(true);
                }
                if (BugDialog.this.sendRequest != null) {
                    BugDialog.this.sendRequest.cancel(true);
                }
            }
        });
        this.add((Component)jXHeader, "North");
        this.add(this.buildContentsPanel(), "Center");
        this.add(this.buildButtonPanel(), "South");
        this.showVersionCheckPanel();
        this.pack();
    }

    private Component buildContentsPanel() {
        this.deck = new CardLayout();
        this.contents = new JPanel(this.deck);
        this.contents.setBorder(BorderFactory.createEmptyBorder(12, 12, 0, 12));
        this.contents.add(this.buildVersionCheckPanel(), "versionCheckPanel");
        this.contents.add(this.buildCurrentVersionPanel(), "currentVersionPanel");
        this.contents.add(this.buildSendingBugReportPanel(), "sendingBugReportPanel");
        this.contents.add(this.buildOldVersionPanel(), "oldVersionPanel");
        this.contents.add(this.buildConnectionFailedPanel(), "connectionFailedPanel");
        this.contents.add(this.buildEmergencySavePanel(), "emergencySavePanel");
        return this.contents;
    }

    private Component buildButtonPanel() {
        this.button_deck = new CardLayout();
        this.buttons = new JPanel(this.button_deck);
        this.buttons.add(this.buildVersionCheckButtons(), "versionCheckButtons");
        this.buttons.add(this.buildCurrentVersionButtons(), "currentVersionButtons");
        this.buttons.add(this.buildSendingBugReportButtons(), "sendingBugReportButtons");
        this.buttons.add(this.buildOldVersionButtons(), "oldVersionButtons");
        this.buttons.add(this.buildConnectionFailedButtons(), "connectionFailedButtons");
        this.buttons.add(this.buildEmergencySaveButtons(), "emergencySaveButtons");
        return this.buttons;
    }

    private Component buildVersionCheckPanel() {
        JXBusyLabel jXBusyLabel = new JXBusyLabel(new Dimension(40, 40));
        jXBusyLabel.setBusy(true);
        FlowLabel flowLabel = new FlowLabel(Resources.getString("BugDialog.collecting_details"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "", "[]push[]push"));
        jPanel.add((Component)flowLabel, "cell 0 0");
        jPanel.add((Component)jXBusyLabel, "cell 0 1, align center");
        return jPanel;
    }

    private Component buildVersionCheckButtons() {
        JButton jButton = new JButton(new AbstractAction(Resources.getString("General.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("align right"));
        jPanel.add((Component)jButton, "tag cancel");
        return jPanel;
    }

    private Component buildCurrentVersionPanel() {
        FlowLabel flowLabel = new FlowLabel(Resources.getString("BugDialog.current_version_instructions"));
        this.descriptionArea = new JTextArea(10, 1);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        this.descriptionScroll = new JScrollPane(this.descriptionArea);
        JLabel jLabel = new JLabel(Resources.getString("BugDialog.bug_description"));
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setLabelFor(this.descriptionScroll);
        this.emailField = new JTextField(26);
        JLabel jLabel2 = new JLabel(Resources.getString("BugDialog.user_email_address"));
        jLabel2.setLabelFor(this.emailField);
        JScrollPane jScrollPane = this.buildDetailsScroll();
        DetailsButton detailsButton = new DetailsButton(Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), jScrollPane);
        detailsButton.setBuddy(flowLabel);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", "[]unrel[]rel[]unrel[]unrel[]rel[]"));
        jPanel.add((Component)flowLabel, "cell 0 0, growx, pushx");
        jPanel.add((Component)jLabel, "cell 0 1");
        jPanel.add((Component)this.descriptionScroll, "cell 0 2, grow, push");
        jPanel.add((Component)jLabel2, "cell 0 3");
        jPanel.add((Component)this.emailField, "cell 0 3, growx, pushx");
        jPanel.add((Component)detailsButton, "cell 0 4");
        jPanel.add((Component)jScrollPane, "cell 0 5, grow, push");
        return jPanel;
    }

    private Component buildCurrentVersionButtons() {
        JButton jButton = new JButton(new AbstractAction(Resources.getString("BugDialog.send_button")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.showSendingBugReportPanel();
            }
        });
        JButton jButton2 = new JButton(new AbstractAction(Resources.getString("BugDialog.dont_send_button")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.showEmergencySavePanel();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("align right"));
        jPanel.add((Component)jButton, "tag ok");
        jPanel.add((Component)jButton2, "tag cancel");
        return jPanel;
    }

    private JScrollPane buildDetailsScroll() {
        JTextArea jTextArea = new JTextArea(this.errorLog, 10, 20);
        jTextArea.setEditable(false);
        jTextArea.setTabSize(2);
        return new JScrollPane(jTextArea);
    }

    private Component buildOldVersionPanel() {
        FlowLabel flowLabel = new FlowLabel(Resources.getString("BugDialog.old_version_instructions"));
        flowLabel.addHyperlinkListener(BrowserSupport.getListener());
        JScrollPane jScrollPane = this.buildDetailsScroll();
        DetailsButton detailsButton = new DetailsButton(Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), jScrollPane);
        detailsButton.setBuddy(flowLabel);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", "[]unrel[]rel[]"));
        jPanel.add((Component)flowLabel, "cell 0 0, growx, pushx");
        jPanel.add((Component)detailsButton, "cell 0 1");
        jPanel.add((Component)jScrollPane, "cell 0 2, grow, push");
        return jPanel;
    }

    private Component buildOldVersionButtons() {
        JButton jButton = new JButton(new AbstractAction(Resources.getString("General.ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.showEmergencySavePanel();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("align right"));
        jPanel.add((Component)jButton, "tag ok");
        return jPanel;
    }

    private Component buildConnectionFailedPanel() {
        String string = new File(Info.getConfDir(), "errorLog").getAbsolutePath();
        FlowLabel flowLabel = new FlowLabel(Resources.getString("BugDialog.connection_failed_instructions", string));
        flowLabel.addHyperlinkListener(BrowserSupport.getListener());
        JScrollPane jScrollPane = this.buildDetailsScroll();
        DetailsButton detailsButton = new DetailsButton(Resources.getString("Dialogs.show_details"), Resources.getString("Dialogs.hide_details"), jScrollPane);
        detailsButton.setBuddy(flowLabel);
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "", "[]unrel[]rel[]"));
        jPanel.add((Component)flowLabel, "cell 0 0, growx, pushx");
        jPanel.add((Component)detailsButton, "cell 0 1");
        jPanel.add((Component)jScrollPane, "cell 0 2, grow, push");
        return jPanel;
    }

    private Component buildConnectionFailedButtons() {
        JButton jButton = new JButton(new AbstractAction(Resources.getString("General.ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.showEmergencySavePanel();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("align right"));
        jPanel.add((Component)jButton, "tag ok");
        return jPanel;
    }

    private Component buildEmergencySavePanel() {
        FlowLabel flowLabel = new FlowLabel(Resources.getString("BugDialog.how_to_proceed"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "", "[]push"));
        jPanel.add((Component)flowLabel, "cell 0 0, growx, pushx");
        return jPanel;
    }

    private Component buildEmergencySaveButtons() {
        JButton jButton = new JButton(new AbstractAction(Resources.getString("General.ok")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("align right"));
        jPanel.add((Component)jButton, "tag ok");
        return jPanel;
    }

    private void showVersionCheckPanel() {
        this.deck.show(this.contents, "versionCheckPanel");
        this.button_deck.show(this.buttons, "versionCheckButtons");
    }

    private void showCurrentVersionPanel() {
        this.deck.show(this.contents, "currentVersionPanel");
        this.button_deck.show(this.buttons, "currentVersionButtons");
    }

    private void showSendingBugReportPanel() {
        this.deck.show(this.contents, "sendingBugReportPanel");
        this.button_deck.show(this.buttons, "sendingBugReportButtons");
        this.sendRequest = new SendRequest();
        this.sendRequest.execute();
    }

    private void showOldVersionPanel() {
        this.deck.show(this.contents, "oldVersionPanel");
        this.button_deck.show(this.buttons, "oldVersionButtons");
    }

    private void showConnectionFailedPanel() {
        this.deck.show(this.contents, "connectionFailedPanel");
        this.button_deck.show(this.buttons, "connectionFailedButtons");
    }

    private void showEmergencySavePanel() {
        this.deck.show(this.contents, "emergencySavePanel");
        this.button_deck.show(this.buttons, "emergencySaveButtons");
    }

    public void setVisible(boolean bl) {
        if (bl && !this.isVisible()) {
            this.checkRequest = new CheckRequest();
            this.checkRequest.execute();
        }
        super.setVisible(bl);
    }

    private Component buildSendingBugReportPanel() {
        JXBusyLabel jXBusyLabel = new JXBusyLabel(new Dimension(40, 40));
        jXBusyLabel.setBusy(true);
        FlowLabel flowLabel = new FlowLabel(Resources.getString("BugDialog.sending_bug_report"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "", "[]push[]push"));
        jPanel.add((Component)flowLabel, "cell 0 0");
        jPanel.add((Component)jXBusyLabel, "cell 0 1, align center");
        return jPanel;
    }

    private Component buildSendingBugReportButtons() {
        JButton jButton = new JButton(new AbstractAction(Resources.getString("General.cancel")){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent actionEvent) {
                BugDialog.this.dispose();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("align right"));
        jPanel.add((Component)jButton, "tag cancel");
        return jPanel;
    }

    private void emergencySave() {
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BugDialog bugDialog = new BugDialog(null, null);
                bugDialog.setVisible(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SendRequest
    extends SwingWorker<Void, Void> {
        private Timer timer = null;

        private SendRequest() {
        }

        protected Void doInBackground() throws Exception {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            this.timer = new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    countDownLatch.countDown();
                }
            });
            this.timer.start();
            BugUtils.sendBugReport(BugDialog.this.emailField.getText(), BugDialog.this.descriptionArea.getText(), BugDialog.this.errorLog, BugDialog.this.thrown);
            countDownLatch.await();
            return null;
        }

        protected void done() {
            try {
                this.get(10L, TimeUnit.SECONDS);
                BugDialog.this.showEmergencySavePanel();
            }
            catch (CancellationException cancellationException) {
                this.timer.stop();
            }
            catch (InterruptedException interruptedException) {
                this.timer.stop();
                interruptedException.printStackTrace();
                BugDialog.this.showConnectionFailedPanel();
            }
            catch (ExecutionException executionException) {
                this.timer.stop();
                executionException.printStackTrace();
                BugDialog.this.showConnectionFailedPanel();
            }
            catch (TimeoutException timeoutException) {
                this.timer.stop();
                timeoutException.printStackTrace();
                BugDialog.this.showConnectionFailedPanel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CheckRequest
    extends SwingWorker<Boolean, Void> {
        private Timer timer = null;

        private CheckRequest() {
        }

        protected Boolean doInBackground() throws Exception {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            this.timer = new Timer(2000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    countDownLatch.countDown();
                }
            });
            this.timer.start();
            VassalVersion vassalVersion = new VassalVersion(Info.getVersion());
            Boolean bl = VersionUtils.isCurrent(vassalVersion);
            countDownLatch.await();
            return bl;
        }

        protected void done() {
            try {
                if (((Boolean)this.get(10L, TimeUnit.SECONDS)).booleanValue()) {
                    BugDialog.this.showCurrentVersionPanel();
                } else {
                    BugDialog.this.showOldVersionPanel();
                }
            }
            catch (CancellationException cancellationException) {
                this.timer.stop();
            }
            catch (InterruptedException interruptedException) {
                this.timer.stop();
                interruptedException.printStackTrace();
                BugDialog.this.showConnectionFailedPanel();
            }
            catch (ExecutionException executionException) {
                this.timer.stop();
                executionException.printStackTrace();
                BugDialog.this.showConnectionFailedPanel();
            }
            catch (TimeoutException timeoutException) {
                this.timer.stop();
                timeoutException.printStackTrace();
                BugDialog.this.showConnectionFailedPanel();
            }
        }
    }
}

