/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.io.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRCUtils {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static long getCRC(List<File> list) throws IOException {
        CRC32 cRC32 = new CRC32();
        byte[] byArray = new byte[8192];
        for (File file : list) {
            CRCUtils.buildCRC(file, cRC32, byArray);
        }
        return cRC32.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void buildCRC(File file, CRC32 cRC32, byte[] byArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            CRCUtils.buildCRC(fileInputStream, cRC32, byArray);
        }
        finally {
            IOUtils.closeQuietly(fileInputStream);
        }
    }

    private static void buildCRC(InputStream inputStream, CRC32 cRC32, byte[] byArray) throws IOException {
        int n;
        while ((n = inputStream.read(byArray)) >= 0) {
            cRC32.update(byArray, 0, n);
        }
    }
}

