/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ImageSource;
import VASSAL.tools.ImprovedAveragingScaleFilter;
import VASSAL.tools.IterableEnumeration;
import VASSAL.tools.URLUtils;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.svg.SVGImageUtils;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.logging.Logger;
import java.applet.AudioClip;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import sun.applet.AppletAudioClip;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataArchive
extends SecureClassLoader
implements Closeable {
    protected ZipFile archive = null;
    protected List<DataArchive> extensions = new ArrayList<DataArchive>();
    private final Map<String, AudioClip> soundCache = new HashMap<String, AudioClip>();
    protected SortedSet<String> localImages = null;
    public static final String IMAGE_DIR = "images/";
    protected String imageDir = "images/";
    public static final String SOUND_DIR = "sounds/";
    protected String soundDir = "sounds/";
    private static final CodeSource cs = new CodeSource((URL)null, (Certificate[])null);
    @Deprecated
    public static final String SOUNDS_DIR = "sounds/";
    @Deprecated
    protected String soundsDir = "sounds/";
    @Deprecated
    private final Map<String, ImageSource> imageSources = new HashMap<String, ImageSource>();
    @Deprecated
    protected String[] imageNames;

    protected DataArchive() {
        super(DataArchive.class.getClassLoader());
    }

    public DataArchive(String string, String string2) throws IOException {
        this();
        this.archive = new ZipFile(string);
        this.imageDir = string2;
    }

    public DataArchive(String string) throws IOException {
        this(string, IMAGE_DIR);
    }

    @Override
    public String getName() {
        return this.archive == null ? "data archive" : this.archive.getName();
    }

    public String getImagePrefix() {
        return this.imageDir;
    }

    public ZipFile getArchive() {
        return this.archive;
    }

    public AudioClip getCachedAudioClip(String string) throws IOException {
        String string2 = this.soundDir + string;
        AudioClip audioClip = this.soundCache.get(string2);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(IOUtils.toByteArray(this.getInputStream(string2)));
            this.soundCache.put(string2, audioClip);
        }
        return audioClip;
    }

    public InputStream getImageInputStream(String string) throws IOException, FileNotFoundException {
        if (string.startsWith("/")) {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                return inputStream;
            }
            throw new FileNotFoundException("Resource not found: " + string);
        }
        try {
            return this.getInputStream(this.imageDir + string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            try {
                return this.getInputStream(this.imageDir + string + ".gif");
            }
            catch (FileNotFoundException fileNotFoundException2) {
                InputStream inputStream = this.getClass().getResourceAsStream("/" + this.imageDir + string + ".gif");
                if (inputStream != null) {
                    return inputStream;
                }
                throw new FileNotFoundException("'" + this.imageDir + string + "' not found in " + this.getName());
            }
        }
    }

    public InputStream getInputStream(String string) throws IOException, FileNotFoundException {
        ZipEntry zipEntry = this.archive.getEntry(string);
        if (zipEntry != null) {
            return this.archive.getInputStream(zipEntry);
        }
        for (DataArchive dataArchive : this.extensions) {
            try {
                return dataArchive.getInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("'" + string + "' not found in " + this.getName());
    }

    public URL getURL() throws IOException {
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        return URLUtils.toJarURL(this.archive.getName());
    }

    public URL getURL(String string) throws IOException, FileNotFoundException {
        if (string.startsWith("/")) {
            return this.getClass().getResource(string);
        }
        if (this.archive == null) {
            throw new IOException("Must save before accessing contents");
        }
        ZipEntry zipEntry = this.archive.getEntry(string);
        if (zipEntry != null) {
            return new URL(this.getURL(), string);
        }
        for (DataArchive dataArchive : this.extensions) {
            try {
                return dataArchive.getURL(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
        }
        throw new FileNotFoundException("'" + string + "' not found in " + this.getName());
    }

    public URL getImageURL(String string) throws IOException, FileNotFoundException {
        return this.getURL(string.startsWith("/") ? string : this.getImagePrefix() + string);
    }

    @Override
    public void close() throws IOException {
        if (this.archive != null) {
            this.archive.close();
        }
    }

    public String[] getImageNames() {
        SortedSet<String> sortedSet = this.getImageNameSet();
        return sortedSet.toArray(new String[sortedSet.size()]);
    }

    public SortedSet<String> getImageNameSet() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        this.getImageNamesRecursively(treeSet);
        return treeSet;
    }

    protected void getImageNamesRecursively(SortedSet<String> sortedSet) {
        if (this.localImages == null) {
            this.localImages = this.getLocalImageNames();
        }
        sortedSet.addAll(this.localImages);
        for (DataArchive dataArchive : this.extensions) {
            dataArchive.getImageNamesRecursively(sortedSet);
        }
    }

    protected SortedSet<String> getLocalImageNames() {
        TreeSet<String> treeSet = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        if (this.archive != null) {
            for (ZipEntry zipEntry : IterableEnumeration.iterate(this.archive.entries())) {
                if (!zipEntry.getName().startsWith(this.imageDir) || zipEntry.getName().equals(this.imageDir)) continue;
                treeSet.add(zipEntry.getName().substring(this.imageDir.length()));
            }
        }
        return treeSet;
    }

    public void addExtension(DataArchive dataArchive) {
        this.extensions.add(dataArchive);
    }

    public ArchiveWriter getWriter() {
        if (this instanceof ArchiveWriter) {
            return (ArchiveWriter)this;
        }
        for (DataArchive dataArchive : this.extensions) {
            ArchiveWriter archiveWriter = dataArchive.getWriter();
            if (archiveWriter == null) continue;
            return archiveWriter;
        }
        return null;
    }

    @Override
    public synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        try {
            clazz = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.findLoadedClass(string);
        }
        if (clazz == null) {
            return this.findClass(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection permissionCollection = super.getPermissions(codeSource);
        permissionCollection.add(new AllPermission());
        return permissionCollection;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            String string2 = string.replace('.', '/');
            byte[] byArray = IOUtils.toByteArray(this.getInputStream(string2 + ".class"));
            return this.defineClass(string, byArray, 0, byArray.length, cs);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Unable to load class " + string, iOException);
        }
    }

    @Deprecated
    public boolean addImageSource(String string, ImageSource imageSource) {
        if (!this.imageSources.containsKey(string)) {
            this.imageSources.put(string, imageSource);
            this.localImages = null;
            return true;
        }
        return false;
    }

    @Deprecated
    public void removeImageSource(String string) {
        this.imageSources.remove(string);
        this.localImages = null;
    }

    @Deprecated
    public Dimension getImageSize(String string) throws IOException {
        if (string.startsWith("/")) {
            if (string.toLowerCase().endsWith(".svg")) {
                return SVGImageUtils.getImageSize(string, this.getImageInputStream(string));
            }
            return ImageUtils.getImageSize(string, this.getImageInputStream(string));
        }
        ImageSource imageSource = this.imageSources.get(string);
        if (imageSource != null) {
            Image image = imageSource.getImage();
            return image != null ? new Dimension(image.getWidth(null), image.getHeight(null)) : new Dimension();
        }
        if (string.toLowerCase().endsWith(".svg")) {
            return SVGImageUtils.getImageSize(string, this.getImageInputStream(string));
        }
        return ImageUtils.getImageSize(string, this.getImageInputStream(string));
    }

    @Deprecated
    public BufferedImage getImage(String string) throws IOException {
        if (string.startsWith("/")) {
            if (string.toLowerCase().endsWith(".svg")) {
                return new SVGRenderer(this.getImageURL(string), this.getImageInputStream(string)).render();
            }
            return ImageUtils.getImage(string, this.getImageInputStream(string));
        }
        ImageSource imageSource = this.imageSources.get(string);
        if (imageSource != null) {
            return ImageUtils.toBufferedImage(imageSource.getImage());
        }
        if (string.toLowerCase().endsWith(".svg")) {
            return new SVGRenderer(this.getImageURL(string), this.getImageInputStream(string)).render();
        }
        return ImageUtils.getImage(string, this.getImageInputStream(string));
    }

    @Deprecated
    protected boolean isNameCacheStale() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected SortedSet<String> setOfImageNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (this.archive != null) {
            Object object = null;
            try {
                ZipEntry zipEntry;
                object = new ZipInputStream(new FileInputStream(this.archive.getName()));
                Object object2 = null;
                while ((zipEntry = ((ZipInputStream)object).getNextEntry()) != null) {
                    if (!zipEntry.getName().startsWith(this.imageDir)) continue;
                    treeSet.add(zipEntry.getName().substring(this.imageDir.length()));
                }
                ((ZipInputStream)object).close();
                IOUtils.closeQuietly((Closeable)object);
            }
            catch (IOException iOException) {
                Logger.log(iOException);
            }
            finally {
                IOUtils.closeQuietly(object);
            }
        }
        for (DataArchive dataArchive : this.extensions) {
            treeSet.addAll(dataArchive.setOfImageNames());
        }
        return treeSet;
    }

    @Deprecated
    public void unCacheImage(String string) {
    }

    @Deprecated
    public void unCacheImage(Image image) {
    }

    @Deprecated
    public void clearTransformedImageCache() {
    }

    @Deprecated
    public void clearScaledImageCache() {
    }

    @Deprecated
    public Image getCachedImage(String string) throws IOException {
        return Op.load(string).getImage();
    }

    @Deprecated
    public Image getTransformedImage(Image image, double d, double d2) {
        return Op.rotateScale(Op.load(ImageUtils.toBufferedImage(image)), d2, d).getImage();
    }

    @Deprecated
    public Image getTransformedImage(Image image, double d, double d2, boolean bl) {
        return this.getTransformedImage(image, d, d2);
    }

    @Deprecated
    public Image getScaledImage(Image image, double d, boolean bl, boolean bl2) {
        return this.getTransformedImage(image, d, bl ? 180.0 : 0.0);
    }

    @Deprecated
    public Image getScaledImage(Image image, double d) {
        return this.getTransformedImage(image, d, 0.0, true);
    }

    @Deprecated
    public static Image findImage(File file, String string) throws IOException {
        return DataArchive.getImage(DataArchive.getFileStream(file, string));
    }

    @Deprecated
    public static Image findImage(File file, String string, String string2) throws IOException {
        if (new File(file, string).exists()) {
            return DataArchive.getImage(DataArchive.getFileStream(file, string, string2));
        }
        if (new File(file, string2).exists()) {
            return Toolkit.getDefaultToolkit().getImage(file.getPath() + File.separatorChar + string2);
        }
        throw new IOException("Image " + string2 + " not found in " + file + File.separator + string);
    }

    @Deprecated
    public static InputStream getFileStream(File file, String string) throws IOException {
        try {
            ZipFile zipFile = new ZipFile(file);
            return zipFile.getInputStream(zipFile.getEntry(string));
        }
        catch (Exception exception) {
            throw new IOException("Couldn't locate " + string + " in " + file.getName() + ": " + exception.getMessage());
        }
    }

    @Deprecated
    public static InputStream getFileStream(File file, String string, String string2) {
        try {
            if (new File(file, string).exists()) {
                ZipFile zipFile = new ZipFile(new File(file, string));
                return zipFile.getInputStream(zipFile.getEntry(string2));
            }
            return new FileInputStream(new File(file, string2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Deprecated
    public InputStream getFileStream(String string) throws IOException {
        return this.getInputStream(string);
    }

    @Deprecated
    public static Image getImage(InputStream inputStream) throws IOException {
        return ImageUtils.getImage(inputStream);
    }

    @Deprecated
    public String getArchiveURL() {
        return this.archive != null ? "jar:file://" + this.archive.getName() + "!/" : "";
    }

    @Deprecated
    public static byte[] getBytes(InputStream inputStream) throws IOException {
        return IOUtils.toByteArray(inputStream);
    }

    @Deprecated
    protected void listImageNames(Collection collection) {
        collection.addAll(this.setOfImageNames());
    }

    @Deprecated
    public static Rectangle getImageBounds(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        return new Rectangle(-imageIcon.getIconWidth() / 2, -imageIcon.getIconHeight() / 2, imageIcon.getIconWidth(), imageIcon.getIconHeight());
    }

    @Deprecated
    public Image improvedScaling(Image image, int n, int n2) {
        ImprovedAveragingScaleFilter improvedAveragingScaleFilter = new ImprovedAveragingScaleFilter(image.getWidth(null), image.getHeight(null), n, n2);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), improvedAveragingScaleFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }
}

