/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.BugDialog;
import VASSAL.tools.DialogUtils;
import VASSAL.tools.FutureUtils;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.logging.Logger;
import java.awt.Component;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorDialog {
    private static final Set<String> reportedDataErrors = Collections.synchronizedSet(new HashSet());

    private ErrorDialog() {
    }

    public static void bug(final Throwable throwable) {
        OutOfMemoryError outOfMemoryError = ThrowableUtils.getRecent(OutOfMemoryError.class, throwable);
        if (outOfMemoryError != null) {
            Logger.log(throwable);
            ErrorDialog.show("Error.out_of_memory", new Object[0]);
        } else if (!DialogUtils.setDisabled(BugDialog.class, true)) {
            FutureUtils.wait(Logger.logAndWait(throwable, 3));
            final JFrame jFrame = GameModule.getGameModule() == null ? null : GameModule.getGameModule().getFrame();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    new BugDialog(jFrame, throwable).setVisible(true);
                }
            });
        }
    }

    public static Future<?> show(String string, Object ... objectArray) {
        return ProblemDialog.show(0, string, objectArray);
    }

    public static Future<?> show(Component component, String string, Object ... objectArray) {
        return ProblemDialog.show(0, component, string, objectArray);
    }

    public static Future<?> show(Throwable throwable, String string, Object ... objectArray) {
        return ProblemDialog.show(0, throwable, string, objectArray);
    }

    public static Future<?> show(Component component, Throwable throwable, String string, Object ... objectArray) {
        return ProblemDialog.show(0, component, throwable, string, objectArray);
    }

    public static Future<?> show(Component component, Throwable throwable, String string, String string2, String string3) {
        return ProblemDialog.show(0, component, throwable, string, string2, string3);
    }

    public static Future<?> showDisableable(Object object, String string, Object ... objectArray) {
        return ProblemDialog.showDisableable(0, object, string, objectArray);
    }

    public static Future<?> showDisableable(Component component, Object object, String string, Object ... objectArray) {
        return ProblemDialog.showDisableable(0, component, object, string, objectArray);
    }

    public static Future<?> showDisableable(Throwable throwable, Object object, String string, Object ... objectArray) {
        return ProblemDialog.showDisableable(0, throwable, object, string, objectArray);
    }

    public static Future<?> showDisableable(Component component, Throwable throwable, Object object, String string, Object ... objectArray) {
        return ProblemDialog.showDisableable(0, component, throwable, object, string, objectArray);
    }

    public static Future<?> showDisableable(Component component, Throwable throwable, Object object, String string, String string2, String string3) {
        return ProblemDialog.showDisableable(0, component, throwable, object, string, string2, string3);
    }

    public static Future<?> showDetails(String string, String string2, Object ... objectArray) {
        return ProblemDialog.showDetails(0, string, string2, objectArray);
    }

    public static Future<?> showDetails(Component component, String string, String string2, Object ... objectArray) {
        return ProblemDialog.showDetails(0, component, string, string2, objectArray);
    }

    public static Future<?> showDetails(Throwable throwable, String string, String string2, Object ... objectArray) {
        return ProblemDialog.showDetails(0, throwable, string, string2, objectArray);
    }

    public static Future<?> showDetails(Component component, Throwable throwable, String string, String string2, Object ... objectArray) {
        return ProblemDialog.showDetails(0, component, throwable, string, string2, objectArray);
    }

    public static Future<?> showDetails(Component component, Throwable throwable, String string, String string2, String string3, String string4) {
        return ProblemDialog.showDetails(0, component, throwable, string, string2, string3, string4);
    }

    public static Future<?> showDetailsDisableable(String string, Object object, String string2, Object ... objectArray) {
        return ProblemDialog.showDetailsDisableable(0, string, object, string2, objectArray);
    }

    public static Future<?> showDetailsDisableable(Component component, String string, Object object, String string2, Object ... objectArray) {
        return ProblemDialog.showDetailsDisableable(0, component, string, object, string2, objectArray);
    }

    public static Future<?> showDetailsDisableable(Throwable throwable, String string, Object object, String string2, Object ... objectArray) {
        return ProblemDialog.showDetailsDisableable(0, throwable, string, object, string2, objectArray);
    }

    public static Future<?> showDetailsDisableable(Component component, Throwable throwable, String string, Object object, String string2, Object ... objectArray) {
        return ProblemDialog.showDetailsDisableable(0, component, throwable, string, object, string2, objectArray);
    }

    public static Future<?> showDetailsDisableable(Component component, Throwable throwable, String string, Object object, String string2, String string3, String string4) {
        return ProblemDialog.showDetailsDisableable(0, component, throwable, string, object, string2, string3, string4);
    }

    public static void infiniteLoop(RecursionLimitException recursionLimitException) {
        ErrorDialog.showDetails(recursionLimitException, ThrowableUtils.getStackTrace(recursionLimitException), "Error.infinite_loop", recursionLimitException.getComponentTypeName(), recursionLimitException.getComponentName());
    }

    public static void dataError(BadDataReport badDataReport) {
        Logger.log(badDataReport.getMessage() + ": " + badDataReport.getData(), 1);
        if (badDataReport.getCause() != null) {
            Logger.log(badDataReport.getCause());
        }
        if (!reportedDataErrors.contains(badDataReport.getData())) {
            reportedDataErrors.add(badDataReport.getData());
            GameModule.getGameModule().warn(Resources.getString("Error.data_error_message", badDataReport.getMessage(), badDataReport.getData()));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        while (!DialogUtils.isDisabled(0)) {
            ErrorDialog.showDisableable(null, null, (Object)0, "Oh Shit!", "Oh Shit!", "Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
            Thread.sleep(1000L);
        }
        System.exit(0);
    }
}

