/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.EditablePiece;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.SequenceEncoder;
import java.util.HashMap;
import java.util.Map;

public class FormattedString {
    protected String formatString;
    protected Map<String, String> props = new HashMap<String, String>();
    protected PropertySource defaultProperties;

    public FormattedString() {
        this("");
    }

    public FormattedString(String string) {
        this(string, GameModule.getGameModule());
    }

    public FormattedString(PropertySource propertySource) {
        this("", propertySource);
    }

    public FormattedString(String string, PropertySource propertySource) {
        this.formatString = string;
        this.defaultProperties = propertySource;
    }

    public void setFormat(String string) {
        this.formatString = string;
    }

    public String getFormat() {
        return this.formatString;
    }

    public void setProperty(String string, String string2) {
        this.props.put(string, string2);
    }

    public void clearProperties() {
        this.props.clear();
    }

    public String getText() {
        return this.getText(this.defaultProperties, false);
    }

    public String getLocalizedText() {
        return this.getText(this.defaultProperties, true);
    }

    public String getText(PropertySource propertySource) {
        return this.getText(propertySource, false);
    }

    public String getText(PropertySource propertySource, String string) {
        String string2 = this.getText(propertySource, false);
        if (string2 == null || string2.length() == 0) {
            string2 = string;
        }
        return string2;
    }

    public String getLocalizedText(PropertySource propertySource) {
        return this.getText(propertySource, true);
    }

    protected String getText(PropertySource propertySource, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(this.formatString, '$');
        boolean bl2 = true;
        while (decoder.hasMoreTokens()) {
            Object object;
            String string = decoder.nextToken();
            boolean bl3 = bl2 = !bl2;
            if (string.length() <= 0) continue;
            if (!bl2 || !decoder.hasMoreTokens()) {
                stringBuilder.append(string);
                continue;
            }
            if (this.props.containsKey(string)) {
                object = this.props.get(string);
                if (object == null) continue;
                stringBuilder.append((String)object);
                continue;
            }
            if (propertySource != null) {
                Object object2 = object = bl ? propertySource.getLocalizedProperty(string) : propertySource.getProperty(string);
                if (object != null) {
                    stringBuilder.append(object.toString());
                    continue;
                }
                if (bl) continue;
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public int getTextAsInt(PropertySource propertySource, String string, EditablePiece editablePiece) {
        int n = 0;
        String string2 = this.getText(propertySource, "0");
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            ErrorDialog.dataError(new BadDataReport(editablePiece, Resources.getString("Error.non_number_error"), FormattedString.debugInfo(this, string2, string), (Throwable)numberFormatException));
        }
        return n;
    }

    public static String debugInfo(FormattedString formattedString, String string, String string2) {
        return string2 + (string.equals(formattedString.getFormat()) ? "" : "[" + formattedString.getFormat() + "]") + "=" + string;
    }

    public String debugInfo(String string, String string2) {
        return FormattedString.debugInfo(this, string, string2);
    }

    public PropertySource getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(PropertySource propertySource) {
        this.defaultProperties = propertySource;
    }
}

