/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.KeyStrokeListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.KeyStroke;

public class LaunchButton
extends JButton {
    private static final long serialVersionUID = 1L;
    public static final String UNTRANSLATED_TEXT = "unTranslatedText";
    protected String tooltipAtt;
    protected String nameAtt;
    protected String keyAtt;
    protected String iconAtt;
    protected IconConfigurer iconConfig;
    protected String toolTipText;
    protected KeyStrokeListener keyListener;
    protected Configurer nameConfig;
    protected Configurer keyConfig;

    public LaunchButton(String string, String string2, String string3, ActionListener actionListener) {
        this(string, string2, string3, null, actionListener);
    }

    public LaunchButton(String string, String string2, String string3, String string4, String string5, ActionListener actionListener) {
        this(string, string3, string4, string5, actionListener);
        this.tooltipAtt = string2;
    }

    public LaunchButton(String string, String string2, String string3, String string4, final ActionListener actionListener) {
        super(string);
        this.nameAtt = string2;
        this.keyAtt = string3;
        this.iconAtt = string4;
        this.iconConfig = new IconConfigurer(this.iconAtt, null, null);
        this.setAlignmentY(0.0f);
        this.keyListener = new KeyStrokeListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (LaunchButton.this.isEnabled() && LaunchButton.this.getParent() != null && LaunchButton.this.getParent().isShowing()) {
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
        if (actionListener != null) {
            GameModule.getGameModule().addKeyStrokeListener(this.keyListener);
            this.addActionListener(actionListener);
        }
        this.setFocusable(false);
        this.checkVisibility();
    }

    public String getNameAttribute() {
        return this.nameAtt;
    }

    public String getHotkeyAttribute() {
        return this.keyAtt;
    }

    public String getIconAttribute() {
        return this.iconAtt;
    }

    public String getAttributeValueString(String string) {
        if (string.equals(this.nameAtt)) {
            return this.getText();
        }
        if (string.equals(this.keyAtt)) {
            return HotKeyConfigurer.encode(this.keyListener.getKeyStroke());
        }
        if (string.equals(this.iconAtt)) {
            return this.iconConfig.getValueString();
        }
        if (string.equals(this.tooltipAtt)) {
            return this.toolTipText;
        }
        return null;
    }

    public void setAttribute(String string, Object object) {
        if (string != null) {
            if (string.equals(this.nameAtt)) {
                if (Localization.getInstance().isTranslationInProgress()) {
                    this.putClientProperty(UNTRANSLATED_TEXT, this.getText());
                }
                this.setText((String)object);
                this.checkVisibility();
            } else if (string.equals(this.keyAtt)) {
                if (object instanceof String) {
                    object = HotKeyConfigurer.decode((String)object);
                }
                this.keyListener.setKeyStroke((KeyStroke)object);
                this.setToolTipText(this.toolTipText);
            } else if (string.equals(this.tooltipAtt)) {
                this.toolTipText = (String)object;
                this.setToolTipText(this.toolTipText);
            } else if (string.equals(this.iconAtt)) {
                if (object instanceof String) {
                    this.iconConfig.setValue((String)object);
                    this.setIcon(this.iconConfig.getIconValue());
                }
                this.checkVisibility();
            }
        }
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
        if (this.keyListener.getKeyStroke() != null) {
            string = (string == null ? "" : string + " ") + "[" + HotKeyConfigurer.getString(this.keyListener.getKeyStroke()) + "]";
        }
        super.setToolTipText(string);
    }

    public Configurer getNameConfigurer() {
        if (this.nameConfig == null && this.nameAtt != null) {
            this.nameConfig = new StringConfigurer(this.nameAtt, Resources.getString("Editor.button_text_label"), this.getText());
        }
        return this.nameConfig;
    }

    public Configurer getHotkeyConfigurer() {
        if (this.keyConfig == null && this.keyAtt != null) {
            this.keyConfig = new HotKeyConfigurer(this.keyAtt, Resources.getString("Editor.hotkey_label"), this.keyListener.getKeyStroke());
        }
        return this.keyConfig;
    }

    protected void checkVisibility() {
        this.setVisible(this.getText() != null && this.getText().length() > 0 || this.getIcon() != null);
    }
}

