/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIFunctionMapper;
import com.sun.jna.win32.W32APITypeMapper;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.Map;

public class MemoryUtils {
    private MemoryUtils() {
    }

    public static long getPhysicalMemory() {
        String string = System.getProperty("os.name").toLowerCase();
        if (!string.startsWith("windows") || string.equals("windows 98") || string.equals("windows me")) {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            if (operatingSystemMXBean instanceof OperatingSystemMXBean) {
                OperatingSystemMXBean operatingSystemMXBean2 = (OperatingSystemMXBean)operatingSystemMXBean;
                return operatingSystemMXBean2.getTotalPhysicalMemorySize();
            }
            return -1L;
        }
        Windows.Kernel32.MEMORYSTATUSEX mEMORYSTATUSEX = new Windows.Kernel32.MEMORYSTATUSEX();
        if (Windows.Kernel32.INSTANCE.GlobalMemoryStatusEx(mEMORYSTATUSEX)) {
            return mEMORYSTATUSEX.ullTotalPhys;
        }
        PointerByReference pointerByReference = new PointerByReference();
        int n = Native.getLastError();
        int n2 = Windows.Kernel32.INSTANCE.FormatMessage(4352, Pointer.NULL, n, 0, pointerByReference, 0, Pointer.NULL);
        String string2 = n2 > 0 ? pointerByReference.getValue().getStringArray(0L)[0] : "no message";
        throw new RuntimeException("Error " + n + ": " + string2);
    }

    public static void main(String[] stringArray) {
        long l = MemoryUtils.getPhysicalMemory();
        if (l >= 0L) {
            System.out.println("System reports " + (l >> 20) + "MB RAM");
        } else {
            System.out.println("Could not determine amount of RAM");
        }
    }

    private static class Windows {
        private Windows() {
        }

        public static interface Kernel32
        extends StdCallLibrary {
            public static final int FORMAT_MESSAGE_ALLOCATE_BUFFER = 256;
            public static final int FORMAT_MESSAGE_FROM_SYSTEM = 4096;
            public static final Map<Object, Object> OPTIONS = new HashMap<Object, Object>(){
                private static final long serialVersionUID = 1L;
                {
                    this.put("type-mapper", W32APITypeMapper.UNICODE);
                    this.put("function-mapper", W32APIFunctionMapper.UNICODE);
                }
            };
            public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary("kernel32", Kernel32.class, OPTIONS);

            public boolean GlobalMemoryStatusEx(MEMORYSTATUSEX var1);

            public int FormatMessage(int var1, Pointer var2, int var3, int var4, PointerByReference var5, int var6, Pointer var7);

            public static final class MEMORYSTATUSEX
            extends Structure {
                public int dwLength = this.size();
                public int dwMemoryLoad;
                public long ullTotalPhys;
                public long ullAvailPhys;
                public long ullTotalPageFile;
                public long ullAvailPageFile;
                public long ullTotalVirtual;
                public long ullAvailVirtual;
                public long ullAvailExtendedVirtual;
            }
        }
    }
}

