/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.memmap;

import VASSAL.tools.image.memmap.MappedDataBufferByte;
import VASSAL.tools.image.memmap.MappedDataBufferInt;
import VASSAL.tools.image.memmap.MappedDataBufferUShort;
import VASSAL.tools.image.memmap.MappedWritableRaster;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class MappedBufferedImage
extends BufferedImage {
    private final int realType;

    public MappedBufferedImage(int n, int n2, int n3) {
        this(MappedBufferedImage.createMappedBufferedImage(n, n2, n3));
    }

    public MappedBufferedImage(ColorModel colorModel, SampleModel sampleModel, int n) {
        super(colorModel, MappedWritableRaster.createWritableRaster(sampleModel, MappedBufferedImage.createDataBuffer(sampleModel), new Point(0, 0)), colorModel.isAlphaPremultiplied(), null);
        this.realType = n;
    }

    private MappedBufferedImage(Object[] objectArray) {
        super((ColorModel)objectArray[0], (WritableRaster)objectArray[1], ((ColorModel)objectArray[0]).isAlphaPremultiplied(), null);
        this.realType = (Integer)objectArray[2];
    }

    public int getRealType() {
        return this.realType;
    }

    private static Object[] createMappedBufferedImage(int n, int n2, int n3) {
        ColorModel colorModel = MappedBufferedImage.createColorModel(n3);
        SampleModel sampleModel = MappedBufferedImage.createSampleModel(colorModel, n, n2, n3);
        DataBuffer dataBuffer = MappedBufferedImage.createDataBuffer(sampleModel);
        WritableRaster writableRaster = MappedWritableRaster.createWritableRaster(sampleModel, dataBuffer, new Point(0, 0));
        return new Object[]{colorModel, writableRaster, n3};
    }

    private static ColorModel createColorModel(int n) {
        switch (n) {
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
            }
            case 2: {
                return new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
            }
            case 3: {
                return new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
            }
            case 4: {
                return new DirectColorModel(24, 255, 65280, 0xFF0000);
            }
            case 5: {
                return new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
            }
            case 6: {
                return new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, false, 3, 0);
            }
            case 7: {
                return new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8, 8}, true, true, 3, 0);
            }
            case 10: {
                return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, true, 1, 0);
            }
            case 11: {
                return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, true, 1, 1);
            }
            case 12: {
                byte[] byArray = new byte[]{0, -1};
                return new IndexColorModel(1, 2, byArray, byArray, byArray);
            }
            case 13: {
                int n2;
                int n3;
                int[] nArray = new int[256];
                int n4 = 0;
                for (n3 = 0; n3 < 256; n3 += 51) {
                    for (n2 = 0; n2 < 256; n2 += 51) {
                        for (int i = 0; i < 256; i += 51) {
                            nArray[n4++] = n3 << 16 | n2 << 8 | i;
                        }
                    }
                }
                n3 = 256 / (256 - n4);
                n2 = n3 * 3;
                while (n4 < 256) {
                    nArray[n4] = n2 << 16 | n2 << 8 | n2;
                    n2 += n3;
                    ++n4;
                }
                return new IndexColorModel(8, 256, nArray, 0, false, -1, 0);
            }
            case 8: {
                return new DirectColorModel(16, 63488, 2016, 31);
            }
            case 9: {
                return new DirectColorModel(15, 31744, 992, 31);
            }
        }
        throw new IllegalArgumentException("Unsupported image type " + n);
    }

    private static SampleModel createSampleModel(ColorModel colorModel, int n, int n2, int n3) {
        switch (n3) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return colorModel.createCompatibleSampleModel(n, n2);
            }
            case 5: {
                return new PixelInterleavedSampleModel(0, n, n2, 3, 3 * n, new int[]{2, 1, 0});
            }
            case 6: {
                return new PixelInterleavedSampleModel(0, n, n2, 4, 4 * n, new int[]{3, 2, 1, 0});
            }
            case 7: {
                return new PixelInterleavedSampleModel(0, n, n2, 4, 4 * n, new int[]{3, 2, 1, 0});
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return colorModel.createCompatibleSampleModel(n, n2);
            }
        }
        throw new IllegalArgumentException("Unsupported image type " + n3);
    }

    private static DataBuffer createDataBuffer(SampleModel sampleModel) {
        int n;
        int n2;
        int n3 = 0;
        if (sampleModel instanceof ComponentSampleModel && (n2 = sampleModel.getNumBands()) != 1) {
            int[] nArray = ((ComponentSampleModel)sampleModel).getBankIndices();
            for (n = 0; n < n2; ++n) {
                if (nArray[n] <= n3) continue;
                n3 = nArray[n];
            }
        }
        n2 = sampleModel.getWidth();
        int n4 = sampleModel.getHeight();
        n = n3 + 1;
        int n5 = n2 * n4 * sampleModel.getNumDataElements() / n;
        try {
            int n6 = sampleModel.getDataType();
            switch (n6) {
                case 0: {
                    return new MappedDataBufferByte(n, n5);
                }
                case 1: {
                    return new MappedDataBufferUShort(n, n5);
                }
                case 3: {
                    return new MappedDataBufferInt(n, n5);
                }
            }
            throw new IllegalArgumentException("Unsupported image type " + n6);
        }
        catch (IOException iOException) {
            throw (OutOfMemoryError)new OutOfMemoryError().initCause(iOException);
        }
    }
}

