/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.memmap;

import VASSAL.tools.io.TempFileManager;
import java.awt.image.DataBuffer;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class MappedDataBufferByte
extends DataBuffer {
    private ByteBuffer buf = null;
    private final File file;
    private final int bankSize;
    private final int bankNum;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappedDataBufferByte(int n, int n2) throws IOException {
        super(0, n);
        this.bankSize = n;
        this.bankNum = n2;
        this.file = TempFileManager.getInstance().createTempFile("mem", null);
        this.file.deleteOnExit();
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.file, "rw");
        try {
            this.buf = randomAccessFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, this.bankSize * n2);
        }
        finally {
            randomAccessFile.close();
            if (this.buf == null) {
                this.dispose();
            }
        }
    }

    public void dispose() {
        this.file.delete();
    }

    protected void finalize() {
        this.dispose();
    }

    public int getElem(int n, int n2) {
        if (n >= this.bankNum) {
            throw new IllegalArgumentException();
        }
        return this.buf.get(n * this.bankSize + n2) & 0xFF;
    }

    public void setElem(int n, int n2, int n3) {
        if (n >= this.bankNum) {
            throw new IllegalArgumentException();
        }
        this.buf.put(n * this.bankSize + n2, (byte)n3);
    }
}

