/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.imageop.AbstractOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageOpObserver;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTileOpImpl
extends AbstractOpImpl {
    @Override
    public Dimension getTileSize() {
        return this.getSize();
    }

    @Override
    public int getTileHeight() {
        return this.getHeight();
    }

    @Override
    public int getTileWidth() {
        return this.getWidth();
    }

    @Override
    public int getNumXTiles() {
        return 1;
    }

    @Override
    public int getNumYTiles() {
        return 1;
    }

    @Override
    public BufferedImage getTile(int n, int n2, ImageOpObserver imageOpObserver) throws CancellationException, InterruptedException, ExecutionException {
        if (n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getImage(imageOpObserver);
    }

    @Override
    public Future<BufferedImage> getFutureTile(int n, int n2, ImageOpObserver imageOpObserver) throws ExecutionException {
        if (n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getFutureImage(imageOpObserver);
    }

    @Override
    public ImageOp getTileOp(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public Point[] getTileIndices(Rectangle rectangle) {
        Point[] pointArray;
        if (rectangle == null) {
            throw new IllegalArgumentException();
        }
        if (rectangle.intersects(new Rectangle(this.size))) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = new Point(0, 0);
        } else {
            pointArray = new Point[]{};
        }
        return pointArray;
    }
}

