/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.counters.GamePiece;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.opcache.Op;
import VASSAL.tools.opcache.OpObserver;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePieceOpImpl
extends AbstractTileOpImpl
implements GamePieceOp {
    private final GamePiece piece;
    private final String state;
    private final int hash;

    public GamePieceOpImpl(GamePiece gamePiece) {
        if (gamePiece == null) {
            throw new IllegalArgumentException();
        }
        this.piece = gamePiece;
        this.state = String.valueOf(this.piece.getProperty("visibleState"));
        this.hash = this.piece.hashCode();
    }

    @Override
    public BufferedImage get(OpObserver<BufferedImage> opObserver) throws CancellationException, InterruptedException, ExecutionException {
        if (opObserver != null) {
            throw new UnsupportedOperationException();
        }
        return super.get(opObserver);
    }

    @Override
    public Future<BufferedImage> getFuture(OpObserver<BufferedImage> opObserver) throws ExecutionException {
        if (opObserver != null) {
            throw new UnsupportedOperationException();
        }
        return super.getFuture(opObserver);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() {
        Rectangle rectangle = this.piece.boundingBox();
        BufferedImage bufferedImage = ImageUtils.createCompatibleTranslucentImage(Math.max(rectangle.width, 1), Math.max(rectangle.height, 1));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.piece.draw(graphics2D, -rectangle.x, -rectangle.y, null, 1.0);
        graphics2D.dispose();
        return bufferedImage;
    }

    @Override
    protected void fixSize() {
        this.size = this.piece.boundingBox().getSize();
        if (this.size.width < 1) {
            this.size.width = 1;
        }
        if (this.size.height < 1) {
            this.size.height = 1;
        }
    }

    @Override
    public GamePiece getPiece() {
        return this.piece;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public boolean isChanged() {
        return !this.state.equals(this.piece.getProperty("visibleState"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof GamePieceOp)) {
            return false;
        }
        GamePieceOp gamePieceOp = (GamePieceOp)object;
        return this.piece.equals(gamePieceOp.getPiece()) && this.state.equals(gamePieceOp.getState());
    }

    public int hashCode() {
        return this.hash;
    }
}

