/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.BadDataReport;
import VASSAL.counters.GamePiece;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.UnrecognizedImageTypeException;
import VASSAL.tools.imageop.AbstractOpImpl;
import VASSAL.tools.imageop.CropOp;
import VASSAL.tools.imageop.CropOpBitmapImpl;
import VASSAL.tools.imageop.GamePieceOp;
import VASSAL.tools.imageop.GamePieceOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ImageSourceOpBitmapImpl;
import VASSAL.tools.imageop.OrthoRotateOpBitmapImpl;
import VASSAL.tools.imageop.RotateOp;
import VASSAL.tools.imageop.RotateScaleOp;
import VASSAL.tools.imageop.RotateScaleOpBitmapImpl;
import VASSAL.tools.imageop.RotateScaleOpSVGImpl;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.imageop.ScaleOpBitmapImpl;
import VASSAL.tools.imageop.SourceOp;
import VASSAL.tools.imageop.SourceOpBitmapImpl;
import VASSAL.tools.imageop.SourceOpMappedBitmapImpl;
import VASSAL.tools.imageop.SourceOpSVGImpl;
import VASSAL.tools.opcache.OpFailedException;
import java.awt.image.BufferedImage;

public class Op {
    public static SourceOp load(String string) {
        if (string.endsWith(".svg")) {
            return new SourceOpSVGImpl(string);
        }
        return new SourceOpBitmapImpl(string);
    }

    public static SourceOp load(BufferedImage bufferedImage) {
        return new ImageSourceOpBitmapImpl(bufferedImage);
    }

    public static SourceOp loadLarge(String string) {
        if (string.endsWith(".svg")) {
            return new SourceOpSVGImpl(string);
        }
        if (ImageUtils.useMappedImages()) {
            return new SourceOpMappedBitmapImpl(string);
        }
        return new SourceOpBitmapImpl(string);
    }

    public static ScaleOp scale(ImageOp imageOp, double d) {
        if (imageOp instanceof SVGOp) {
            return new RotateScaleOpSVGImpl((SVGOp)imageOp, 0.0, d);
        }
        return new ScaleOpBitmapImpl(imageOp, d);
    }

    public static RotateOp rotate(ImageOp imageOp, double d) {
        if (imageOp instanceof SVGOp) {
            return new RotateScaleOpSVGImpl((SVGOp)imageOp, d, 1.0);
        }
        if (d % 90.0 == 0.0) {
            return new OrthoRotateOpBitmapImpl(imageOp, (int)d);
        }
        return new RotateScaleOpBitmapImpl(imageOp, d, 1.0);
    }

    public static RotateScaleOp rotateScale(ImageOp imageOp, double d, double d2) {
        if (imageOp instanceof SVGOp) {
            return new RotateScaleOpSVGImpl((SVGOp)imageOp, d, d2);
        }
        return new RotateScaleOpBitmapImpl(imageOp, d, d2);
    }

    public static CropOp crop(ImageOp imageOp, int n, int n2, int n3, int n4) {
        return new CropOpBitmapImpl(imageOp, n, n2, n3, n4);
    }

    public static GamePieceOp piece(GamePiece gamePiece) {
        return new GamePieceOpImpl(gamePiece);
    }

    public static void clearCache() {
        AbstractOpImpl.clearCache();
    }

    public static boolean handleException(Exception exception) {
        for (Throwable throwable = exception; throwable != null; throwable = throwable.getCause()) {
            if (throwable instanceof OpFailedException) {
                return true;
            }
            if (throwable instanceof ImageNotFoundException) {
                ErrorDialog.dataError(new BadDataReport("Image not found", ((ImageNotFoundException)throwable).getFile().getName(), null));
                return true;
            }
            if (throwable instanceof UnrecognizedImageTypeException) {
                ErrorDialog.dataError(new BadDataReport("Unrecognized image type", ((UnrecognizedImageTypeException)throwable).getFile().getName(), throwable));
                return true;
            }
            if (!(throwable instanceof ImageIOException)) continue;
            ErrorDialog.dataError(new BadDataReport("Error reading image", ((ImageIOException)throwable).getFile().getName(), throwable));
            return true;
        }
        return false;
    }
}

