/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.HashCode;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceTileOpBitmapImpl
extends AbstractTileOpImpl {
    private final ImageOp sop;
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int hash;

    public SourceTileOpBitmapImpl(ImageOp imageOp, int n, int n2) {
        if (imageOp == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= imageOp.getNumXTiles() || n2 < 0 || n2 >= imageOp.getNumYTiles()) {
            throw new IndexOutOfBoundsException();
        }
        this.sop = imageOp;
        int n3 = imageOp.getTileWidth();
        int n4 = imageOp.getTileHeight();
        int n5 = imageOp.getWidth();
        int n6 = imageOp.getHeight();
        this.x0 = n * n3;
        this.y0 = n2 * n4;
        this.x1 = Math.min((n + 1) * n3, n5);
        this.y1 = Math.min((n2 + 1) * n4, n6);
        this.size = new Dimension(this.x1 - this.x0, this.y1 - this.y0);
        int n7 = 1;
        n7 = 31 * n7 + HashCode.hash(imageOp);
        n7 = 31 * n7 + HashCode.hash(this.x0);
        n7 = 31 * n7 + HashCode.hash(this.y0);
        n7 = 31 * n7 + HashCode.hash(this.x1);
        this.hash = n7 = 31 * n7 + HashCode.hash(this.y1);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        BufferedImage bufferedImage = this.sop.getImage(null);
        BufferedImage bufferedImage2 = ImageUtils.createCompatibleImage(this.size.width, this.size.height, bufferedImage.getTransparency() != 1);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, this.size.width, this.size.height, this.x0, this.y0, this.x1, this.y1, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    @Override
    protected void fixSize() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SourceTileOpBitmapImpl)) {
            return false;
        }
        SourceTileOpBitmapImpl sourceTileOpBitmapImpl = (SourceTileOpBitmapImpl)object;
        return this.x0 == sourceTileOpBitmapImpl.x0 && this.y0 == sourceTileOpBitmapImpl.y0 && this.x1 == sourceTileOpBitmapImpl.x1 && this.y1 == sourceTileOpBitmapImpl.y1 && this.sop.equals(sourceTileOpBitmapImpl.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

