/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.build.GameModule;
import VASSAL.tools.DataArchive;
import VASSAL.tools.HashCode;
import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import VASSAL.tools.image.svg.SVGRenderer;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.SVGOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceTileOpSVGImpl
extends AbstractTileOpImpl
implements SVGOp {
    private final SVGOp sop;
    private final int x0;
    private final int y0;
    private final int x1;
    private final int y1;
    private final int hash;

    public SourceTileOpSVGImpl(SVGOp sVGOp, int n, int n2) {
        if (sVGOp == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= sVGOp.getNumXTiles() || n2 < 0 || n2 >= sVGOp.getNumYTiles()) {
            throw new IndexOutOfBoundsException();
        }
        this.sop = sVGOp;
        int n3 = sVGOp.getTileWidth();
        int n4 = sVGOp.getTileHeight();
        int n5 = sVGOp.getWidth();
        int n6 = sVGOp.getHeight();
        this.x0 = n * n3;
        this.y0 = n2 * n4;
        this.x1 = Math.min((n + 1) * n3, n5);
        this.y1 = Math.min((n2 + 1) * n4, n6);
        this.size = new Dimension(this.x1 - this.x0, this.y1 - this.y0);
        int n7 = 1;
        n7 = 31 * n7 + HashCode.hash(sVGOp);
        n7 = 31 * n7 + HashCode.hash(this.x0);
        n7 = 31 * n7 + HashCode.hash(this.y0);
        n7 = 31 * n7 + HashCode.hash(this.x1);
        this.hash = n7 = 31 * n7 + HashCode.hash(this.y1);
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.emptyList();
    }

    @Override
    public BufferedImage eval() throws ImageIOException {
        DataArchive dataArchive = GameModule.getGameModule().getDataArchive();
        String string = this.getName();
        try {
            SVGRenderer sVGRenderer = new SVGRenderer(dataArchive.getImageURL(string), (InputStream)new BufferedInputStream(dataArchive.getImageInputStream(string)));
            Rectangle2D.Float float_ = new Rectangle2D.Float(this.x0, this.y0, this.x1 - this.x0, this.y1 - this.y0);
            return sVGRenderer.render(0.0, 1.0, float_);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ImageNotFoundException(string, (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ImageIOException(string, (Throwable)iOException);
        }
    }

    @Override
    protected void fixSize() {
    }

    @Override
    public String getName() {
        return this.sop.getName();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SourceTileOpSVGImpl)) {
            return false;
        }
        SourceTileOpSVGImpl sourceTileOpSVGImpl = (SourceTileOpSVGImpl)object;
        return this.x0 == sourceTileOpSVGImpl.x0 && this.y0 == sourceTileOpSVGImpl.y0 && this.x1 == sourceTileOpSVGImpl.x1 && this.y1 == sourceTileOpSVGImpl.y1 && this.sop.equals(sourceTileOpSVGImpl.sop);
    }

    public int hashCode() {
        return this.hash;
    }
}

