/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imports.adc2;

import VASSAL.build.GameModule;
import VASSAL.tools.filechooser.BMPFileFilter;
import VASSAL.tools.imports.FileFormatException;
import VASSAL.tools.imports.ImportAction;
import VASSAL.tools.imports.Importer;
import VASSAL.tools.imports.adc2.ADC2Utils;
import VASSAL.tools.io.IOUtils;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;

public class SymbolSet
extends Importer {
    private static final int OLD_SYMBOL_SET_FORMAT = 253;
    private static final float[][] THREE_BAND_MATRIX = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f, 255.0f}};
    private static final float[][] ONE_BAND_MATRIX = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}, {0.0f, 0.0f}, {-255.0f, 255.0f}};
    private SymbolData[] gamePieceData;
    private SymbolData[] mapBoardData;
    private int[] mapBoardSymbolSize;
    private SymbolData[] maskData = null;
    private Shape symbolShape;
    private static final int zoomLevel = 2;
    private boolean ignoreMask;
    private boolean isCardSet;
    private int header;
    BufferedImage underlay;

    private static BufferedImage generateAlphaMask(BufferedImage bufferedImage) {
        BandCombineOp bandCombineOp = bufferedImage.getSampleModel().getNumBands() == 1 ? new BandCombineOp(ONE_BAND_MATRIX, null) : new BandCombineOp(THREE_BAND_MATRIX, null);
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        bandCombineOp.filter(bufferedImage.getRaster(), bufferedImage2.getRaster());
        return bufferedImage2;
    }

    BufferedImage loadSymbolImage(String string, char c, boolean bl) throws IOException {
        String string2 = c == '\u0000' ? string + 3 + ".bmp" : string + '-' + c + 3 + ".bmp";
        File file = this.action.getCaseInsensitiveFile(new File(string2), null, bl, new BMPFileFilter());
        if (file == null && bl) {
            throw new FileNotFoundException("Missing bitmap file: " + string2);
        }
        if (file == null) {
            return null;
        }
        return ImageIO.read(file);
    }

    BufferedImage loadSymbolImage(String string, char c) throws IOException {
        return this.loadSymbolImage(string, c, true);
    }

    Dimension readDimension(DataInputStream dataInputStream) throws IOException {
        Dimension dimension = null;
        for (int i = 0; i < 3; ++i) {
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            if (2 != i) continue;
            dimension = new Dimension(n, n2);
        }
        return dimension;
    }

    SymbolData getGamePiece(int n) {
        if (n >= 0 && n < this.gamePieceData.length) {
            return this.gamePieceData[n];
        }
        return null;
    }

    SymbolData getMapBoardSymbol(int n) {
        if (n >= 0 & n < this.mapBoardData.length) {
            return this.mapBoardData[n];
        }
        return null;
    }

    public Dimension getMaxSize(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        for (SymbolData symbolData : this.gamePieceData) {
            BufferedImage bufferedImage = symbolData.getImage();
            if (bufferedImage.getWidth() > dimension.width) {
                dimension.width = bufferedImage.getWidth();
            }
            if (bufferedImage.getHeight() <= dimension.height) continue;
            dimension.height = bufferedImage.getHeight();
        }
        return dimension;
    }

    public Dimension getMaxSize() {
        return this.getMaxSize(null);
    }

    public Dimension getModalSize() {
        HashMap<Dimension, Integer> hashMap = new HashMap<Dimension, Integer>();
        for (SymbolData object : this.gamePieceData) {
            BufferedImage bufferedImage = object.getImage();
            Dimension dimension = new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight());
            Integer n = (Integer)hashMap.get(dimension);
            if (n == null) {
                hashMap.put(dimension, 1);
                continue;
            }
            hashMap.put(dimension, n + 1);
        }
        int n = 0;
        Dimension dimension = new Dimension(0, 0);
        for (Dimension dimension2 : hashMap.keySet()) {
            int n2 = (Integer)hashMap.get(dimension2);
            if (n2 <= n) continue;
            n = n2;
            dimension.height = dimension2.height;
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    int getMapBoardSymbolSize() {
        return this.mapBoardSymbolSize[2];
    }

    double getZoomFactor(int n) {
        return (double)this.mapBoardSymbolSize[n] / (double)this.mapBoardSymbolSize[2];
    }

    Shape getMapBoardSymbolShape() {
        return this.symbolShape;
    }

    void importCardSet(ImportAction importAction, File file) throws IOException {
        this.isCardSet = true;
        this.importFile(importAction, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load(File file) throws IOException {
        super.load(file);
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.header = dataInputStream.readUnsignedByte();
            if (this.header < 250) {
                throw new FileFormatException("Invalid Symbol Set Header");
            }
            dataInputStream.readByte();
            byte by = dataInputStream.readByte();
            switch (by) {
                case 1: {
                    this.symbolShape = Shape.HEX;
                    break;
                }
                default: {
                    this.symbolShape = Shape.SQUARE;
                }
            }
            byte by2 = dataInputStream.readByte();
            switch (by2) {
                case 0: {
                    this.ignoreMask = false;
                    break;
                }
                default: {
                    this.ignoreMask = true;
                }
            }
            if (this.isCardSet) {
                this.ignoreMask = true;
            }
            int n = ADC2Utils.readBase250Word(dataInputStream);
            this.mapBoardData = new SymbolData[n];
            this.readDimension(dataInputStream);
            int n2 = ADC2Utils.readBase250Word(dataInputStream);
            this.gamePieceData = new SymbolData[n2];
            this.readDimension(dataInputStream);
            int n3 = ADC2Utils.readBase250Word(dataInputStream);
            this.readDimension(dataInputStream);
            this.maskData = new SymbolData[n3];
            String string = SymbolSet.stripExtension(file.getPath());
            BufferedImage bufferedImage = null;
            if (!this.isCardSet) {
                bufferedImage = this.loadSymbolImage(string, 't');
            }
            for (int i = 0; i < n; ++i) {
                this.mapBoardData[i] = new SymbolData(bufferedImage, false).read(dataInputStream);
                if (this.isCardSet) continue;
                if (((SymbolData)this.mapBoardData[i]).rect.height != ((SymbolData)this.mapBoardData[0]).rect.height || ((SymbolData)this.mapBoardData[i]).rect.width != ((SymbolData)this.mapBoardData[0]).rect.width) {
                    throw new FileFormatException("Map board image dimensions are inconsistent");
                }
                if (((SymbolData)this.mapBoardData[i]).rect.width == ((SymbolData)this.mapBoardData[i]).rect.height) continue;
                throw new FileFormatException("Map board image dimensions are not square");
            }
            BufferedImage bufferedImage2 = this.isCardSet ? this.loadSymbolImage(string) : this.loadSymbolImage(string, 'u');
            for (int i = 0; i < n2; ++i) {
                this.gamePieceData[i] = new SymbolData(bufferedImage2, false).read(dataInputStream);
            }
            if (!this.ignoreMask) {
                BufferedImage bufferedImage3 = this.loadSymbolImage(string, 'm');
                bufferedImage3 = SymbolSet.generateAlphaMask(bufferedImage3);
                for (int i = 0; i < n3; ++i) {
                    this.maskData[i] = new SymbolData(bufferedImage3, true).read(dataInputStream);
                }
            }
            dataInputStream.close();
            this.underlay = this.loadSymbolImage(string, 'z', false);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(dataInputStream);
        this.readPermutationFile(file);
    }

    private BufferedImage loadSymbolImage(String string) throws IOException {
        return this.loadSymbolImage(string, '\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readPermutationFile(File file) throws IOException {
        File file2 = new File(SymbolSet.forceExtension(file.getPath(), "sdx"));
        if ((file2 = this.action.getCaseInsensitiveFile(file2, file, false, null)) != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file2));
                SymbolData[] symbolDataArray = new SymbolData[this.gamePieceData.length];
                System.arraycopy(this.gamePieceData, 0, symbolDataArray, 0, symbolDataArray.length);
                String string = null;
                try {
                    int n;
                    for (n = 0; n < this.mapBoardData.length; ++n) {
                        string = bufferedReader.readLine();
                    }
                    for (n = 0; n < symbolDataArray.length; ++n) {
                        string = bufferedReader.readLine();
                        int n2 = Integer.parseInt(string);
                        symbolDataArray[n] = this.gamePieceData[n2 - 1];
                    }
                }
                catch (EOFException eOFException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new FileFormatException("SDX file has out-of-bounds index \"" + string + "\".");
                }
                catch (NumberFormatException numberFormatException) {
                    throw new FileFormatException("SDX file has invalid index \"" + string + "\".");
                }
                finally {
                    this.gamePieceData = symbolDataArray;
                }
                bufferedReader.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedReader);
                throw throwable;
            }
            IOUtils.closeQuietly(bufferedReader);
        }
    }

    public void writeToArchive() throws IOException {
        for (SymbolData symbolData : this.gamePieceData) {
            symbolData.writeToArchive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidImportFile(File file) throws IOException {
        boolean bl;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(file));
            boolean bl2 = dataInputStream.readUnsignedByte() >= 250;
            dataInputStream.close();
            bl = bl2;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dataInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly(dataInputStream);
        return bl;
    }

    static /* synthetic */ int[] access$202(SymbolSet symbolSet, int[] nArray) {
        symbolSet.mapBoardSymbolSize = nArray;
        return nArray;
    }

    class SymbolData {
        private final BufferedImage bitmap;
        private String fileName;
        private BufferedImage img;
        private final boolean isMask;
        private int maskIndex;
        private String name;
        private Rectangle rect;
        private Boolean transparent;

        SymbolData(BufferedImage bufferedImage, boolean bl) {
            this.bitmap = bufferedImage;
            this.isMask = bl;
        }

        protected SymbolData getMask() {
            if (SymbolSet.this.ignoreMask || this.isMask) {
                return null;
            }
            if (this.maskIndex > 0 && this.maskIndex <= SymbolSet.this.maskData.length) {
                return SymbolSet.this.maskData[this.maskIndex - 1];
            }
            return null;
        }

        protected SymbolData read(DataInputStream dataInputStream) throws IOException {
            this.name = Importer.readNullTerminatedString(dataInputStream);
            boolean bl = false;
            if (SymbolSet.this.mapBoardSymbolSize == null) {
                SymbolSet.access$202(SymbolSet.this, new int[3]);
                bl = true;
            }
            this.maskIndex = SymbolSet.this.header == 253 ? dataInputStream.readUnsignedByte() : ADC2Utils.readBase250Word(dataInputStream);
            for (int i = 0; i < 3; ++i) {
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                int n4 = dataInputStream.readInt();
                int n5 = n3 - n + 1;
                int n6 = n4 - n2 + 1;
                if (bl) {
                    ((SymbolSet)SymbolSet.this).mapBoardSymbolSize[i] = n6;
                }
                if (i != 2) continue;
                this.rect = new Rectangle(n, n2, n5, n6);
            }
            return this;
        }

        String getFileName() throws IOException {
            if (this.fileName == null) {
                this.writeToArchive();
            }
            return this.fileName;
        }

        boolean isTransparent() {
            if (this.transparent == null) {
                BufferedImage bufferedImage = this.getImage();
                this.transparent = Boolean.TRUE;
                block0: for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                    for (int j = 0; j < bufferedImage.getHeight(); ++j) {
                        if (bufferedImage.getRGB(i, j) == 0) continue;
                        this.transparent = Boolean.FALSE;
                        break block0;
                    }
                }
            }
            return this.transparent;
        }

        private BufferedImage getImage(Rectangle rectangle) {
            if (this.img == null) {
                if (this.isMask && (this.rect.width <= 0 || this.rect.height <= 0 || this.rect.width + this.rect.x > this.bitmap.getWidth() || this.rect.height + this.rect.y > this.bitmap.getHeight())) {
                    return new BufferedImage(rectangle.width, rectangle.height, 2);
                }
                this.img = this.bitmap.getSubimage(this.rect.x, this.rect.y, this.rect.width, this.rect.height);
                if (this.getMask() != null) {
                    BufferedImage bufferedImage = new BufferedImage(this.rect.width, this.rect.height, 2);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(this.img, null, 0, 0);
                    graphics2D.setComposite(AlphaComposite.DstAtop);
                    graphics2D.drawImage(this.getMask().getImage(this.rect), null, 0, 0);
                    this.img = bufferedImage;
                }
            }
            return this.img;
        }

        BufferedImage getImage() {
            return this.getImage(this.rect);
        }

        protected void writeToArchive() throws IOException {
            if (this.fileName == null) {
                this.fileName = Importer.getUniqueImageFileName(this.name);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)this.getImage(), "png", byteArrayOutputStream);
                GameModule.getGameModule().getArchiveWriter().addImage(this.fileName, byteArrayOutputStream.toByteArray());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Shape {
        SQUARE,
        HEX;

    }
}

