/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.io.IOException;
import java.io.InputStream;

public class CompositeInputStream
extends InputStream {
    private final InputStream[] streams;
    private int cur = 0;
    private InputStream in;

    public CompositeInputStream(InputStream ... inputStreamArray) {
        if (inputStreamArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.streams = inputStreamArray;
        this.in = inputStreamArray[this.cur];
    }

    private void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = ++this.cur < this.streams.length ? this.streams[this.cur] : null;
        }
    }

    public int available() throws IOException {
        int n = 0;
        for (int i = this.cur; i < this.streams.length; ++i) {
            n += Math.max(this.streams[i].available(), 0);
        }
        return n;
    }

    public int read() throws IOException {
        if (this.in == null) {
            return -1;
        }
        int n = this.in.read();
        if (n != -1) {
            return n;
        }
        this.nextStream();
        return this.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0) {
            return n3;
        }
        this.nextStream();
        return this.read(byArray, n, n2);
    }

    public void close() throws IOException {
        while (this.in != null) {
            this.nextStream();
        }
    }
}

