/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtils {
    private FileUtils() {
    }

    public static void delete(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file.getAbsolutePath());
        }
    }

    public static void mkdirs(File file) throws IOException {
        if (!file.mkdirs()) {
            throw new IOException("Failed to create directory " + file.getAbsolutePath());
        }
    }

    public static void recursiveDelete(File file) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        FileUtils.recursiveDeleteHelper(file, arrayList);
        if (!arrayList.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder("Failed to delete");
            for (File file2 : arrayList) {
                stringBuilder.append(' ').append(file2.getAbsolutePath());
            }
            throw new IOException(stringBuilder.toString());
        }
    }

    private static void recursiveDeleteHelper(File file, List<File> list) {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                FileUtils.recursiveDeleteHelper(file2, list);
            }
        }
        if (!file.delete()) {
            list.add(file);
        }
    }
}

