/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.io.CompositeInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RereadableInputStream
extends InputStream {
    private InputStream src;
    private boolean marked;
    private ByteArrayOutputStream savedBytes;

    public RereadableInputStream(InputStream inputStream) {
        if (inputStream == null) {
            throw new IllegalArgumentException();
        }
        this.src = inputStream;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        this.savedBytes = new ByteArrayOutputStream(n);
        this.marked = true;
    }

    public synchronized void reset() throws IOException {
        if (!this.marked) {
            throw new IOException("Cannot reset unmarked stream");
        }
        this.src = new CompositeInputStream(new ByteArrayInputStream(this.savedBytes.toByteArray()), this.src);
        this.marked = false;
    }

    public int available() throws IOException {
        return this.src.available();
    }

    public int read() throws IOException {
        int n = this.src.read();
        if (this.marked) {
            this.savedBytes.write(n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.src.read(byArray, n, n2);
        if (n3 > 0 && this.marked) {
            this.savedBytes.write(byArray, n, n3);
        }
        return n3;
    }

    public void close() throws IOException {
        this.src.close();
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[]{0, 1, 2, 3, 4, 5, 6, 7});
        RereadableInputStream rereadableInputStream = new RereadableInputStream(byteArrayInputStream);
        assert (((InputStream)rereadableInputStream).markSupported());
        ((InputStream)rereadableInputStream).mark(4);
        byte[] byArray = new byte[4];
        int n2 = ((InputStream)rereadableInputStream).read(byArray, 0, 4);
        assert (4 == n2);
        for (byte by = 0; by < 4; ++by) {
            assert (by == byArray[by]);
        }
        ((InputStream)rereadableInputStream).reset();
        byte[] byArray2 = new byte[8];
        int n3 = 0;
        for (n = 0; n < 8 && (n3 = ((InputStream)rereadableInputStream).read(byArray2, n, 8 - n)) != -1; n += n3) {
        }
        assert (8 == n) : n;
        for (byte by = 0; by < 8; ++by) {
            assert (by == byArray2[by]);
        }
    }
}

