/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.Functor;
import VASSAL.tools.menu.ParentProxy;
import java.awt.Component;
import java.awt.Container;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProxy<T extends JComponent>
implements ChildProxy<T> {
    protected final List<WeakReference<T>> peers = new ArrayList<WeakReference<T>>();
    protected final ReferenceQueue<T> queue = new ReferenceQueue();
    protected ParentProxy parent;

    protected void processQueue() {
        Reference<T> reference;
        while ((reference = this.queue.poll()) != null) {
            this.peers.remove(reference);
        }
    }

    protected void forEachPeer(Functor<T> functor) {
        this.processQueue();
        for (WeakReference<T> weakReference : this.peers) {
            JComponent jComponent = (JComponent)weakReference.get();
            if (jComponent == null) continue;
            functor.apply(jComponent);
        }
    }

    @Override
    public ParentProxy getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ParentProxy parentProxy) {
        this.parent = parentProxy;
        if (parentProxy == null) {
            this.forEachPeer(new Functor<T>(){

                @Override
                public void apply(T t) {
                    Container container = ((Component)t).getParent();
                    if (container != null) {
                        container.remove((Component)t);
                    }
                }
            });
        }
    }

    @Override
    public abstract T createPeer();
}

