/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.litesoft.p2pchat.ActivePeer;
import org.litesoft.p2pchat.ActivePeerManager;
import org.litesoft.p2pchat.IllegalArgument;
import org.litesoft.p2pchat.MyInfo;
import org.litesoft.p2pchat.PeerInfo;
import org.litesoft.p2pchat.PendingPeerManager;
import org.litesoft.p2pchat.UserDialog;

public class UserDialogConsole
extends Thread
implements UserDialog {
    private MyInfo zMyInfo;
    private ActivePeerManager zActivePeerManager = null;
    private BufferedReader zReader;

    public UserDialogConsole(String string, MyInfo myInfo) {
        IllegalArgument.ifNull("Title", string);
        this.zMyInfo = myInfo;
        IllegalArgument.ifNull("MyInfo", this.zMyInfo);
        System.out.println(string);
        this.zReader = new BufferedReader(new InputStreamReader(System.in));
        this.start();
    }

    public void setActivePeerManager(ActivePeerManager activePeerManager) {
        if (activePeerManager != null) {
            this.zActivePeerManager = activePeerManager;
        }
    }

    public void setPendingPeerManager(PendingPeerManager pendingPeerManager) {
        if (pendingPeerManager != null) {
            // empty if block
        }
    }

    public void run() {
        System.out.println("Listening At: " + this.zMyInfo.getAddresses() + ":" + this.zMyInfo.getPort());
        try {
            while (true) {
                this.processCommand(this.zReader.readLine());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void processCommand(String string) {
        String string2;
        int n;
        if ((string = string.trim()).length() == 0) {
            return;
        }
        if (string.equalsIgnoreCase("WHO")) {
            this.showWho();
            return;
        }
        if (string.toUpperCase().startsWith("I AM ") && string.length() > 5) {
            this.handleNAMEchange(string.substring(5).trim());
            this.send("Name Change from (" + this.zMyInfo.getPrevChatName() + ") to: " + this.zMyInfo.getChatName());
            return;
        }
        if (string.toUpperCase().startsWith("MSG ") && string.length() > 4 && (n = (string2 = string.substring(4).trim()).indexOf(32)) != -1) {
            this.handlePrivateMessage(string2.substring(0, n), string2.substring(n + 1).trim());
            return;
        }
        this.handleCHAT(string);
    }

    private void send(String string) {
        System.out.println(string);
    }

    private void showWho() {
        this.send("Currently Connected:");
        this.send("  " + this.zMyInfo.toString());
        PeerInfo[] peerInfoArray = this.getPeerInfos();
        for (int i = 0; i < peerInfoArray.length; ++i) {
            this.send("  " + peerInfoArray[i].toString());
        }
    }

    public void showUnrecognized(PeerInfo peerInfo, String string) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("BadMessage", string);
        this.send("Unrecognized Command from (" + peerInfo.getID() + " " + peerInfo.getChatName() + "): " + string);
    }

    public void showStreamsFailed(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Unable to Set up I/O Streams with: " + peerInfo.toString());
    }

    public void showConnectFailed(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Unable to Connect to: " + peerInfo.toString());
    }

    public void showConnect(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Connection From: " + peerInfo.toString());
    }

    public void showDisconnect(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Disconnect: " + peerInfo.getID() + " " + peerInfo.getChatName());
    }

    public void showCHAT(PeerInfo peerInfo, String string) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("Message", string);
        this.send(peerInfo.getID() + " " + peerInfo.getChatName() + ": " + string);
    }

    public void showPMSG(PeerInfo peerInfo, String string) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        IllegalArgument.ifNull("Message", string);
        this.send("Private Message From (" + peerInfo.getID() + " " + peerInfo.getChatName() + "): " + string);
    }

    public void showNAME(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("Name Change: " + peerInfo.toString());
    }

    public void showHELO(PeerInfo peerInfo) {
        IllegalArgument.ifNull("PeerInfo", peerInfo);
        this.send("HELO From: " + peerInfo.toString());
    }

    private void handleCHAT(String string) {
        IllegalArgument.ifNull("Line", string);
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zActivePeerManager.sendToAllCHAT(string);
            this.send(this.zMyInfo.getChatName() + ": " + string);
        }
    }

    private void handleNAMEchange(String string) {
        IllegalArgument.ifNull("NewName", string);
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            this.zMyInfo.setChatName(string);
            this.zActivePeerManager.sendToAllNAME();
        }
    }

    private PeerInfo[] getPeerInfos() {
        return this.zActivePeerManager != null ? this.zActivePeerManager.getPeerInfos() : new PeerInfo[]{};
    }

    private void handlePrivateMessage(String string, String string2) {
        if (this.zActivePeerManager == null) {
            this.send("No Peer Manager!");
        } else {
            ActivePeer activePeer = this.zActivePeerManager.getPeerListenerByID(string);
            if (activePeer == null) {
                this.send("Unrecognized Peer ID: " + string);
            } else {
                activePeer.sendPMSG(string2);
                this.send("Private Message sent to: " + activePeer.getPeerInfo().toString());
            }
        }
    }
}

