/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.wizard.displayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.api.wizard.WizardResultReceiver;
import org.netbeans.api.wizard.displayer.NavButtonManager;
import org.netbeans.api.wizard.displayer.NavProgress;
import org.netbeans.modules.wizard.InstructionsPanel;
import org.netbeans.modules.wizard.MergeMap;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.DeferredWizardResult;
import org.netbeans.spi.wizard.ResultProgressHandle;
import org.netbeans.spi.wizard.Summary;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPanel;

public class WizardDisplayerImpl
extends WizardDisplayer {
    ResultProgressHandle progress = null;
    JLabel ttlLabel = null;
    JPanel ttlPanel = null;
    Wizard wizard = null;
    JPanel outerPanel = null;
    NavButtonManager buttonManager = null;
    InstructionsPanel instructions = null;
    MergeMap settings = null;
    JPanel inner = null;
    JLabel problem = null;
    Object wizardResult = null;
    WizardResultReceiver receiver = null;
    JComponent wizardPanel = null;
    boolean inSummary = false;
    DeferredWizardResult deferredResult = null;

    protected void buildStepTitle() {
        this.ttlLabel = new JLabel(this.wizard.getStepDescription(this.wizard.getAllSteps()[0]));
        this.ttlLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 12, 5), BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("textText"))));
        this.ttlPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            public void doLayout() {
                Dimension dimension = WizardDisplayerImpl.this.ttlLabel.getPreferredSize();
                if (WizardDisplayerImpl.this.ttlLabel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    WizardDisplayerImpl.this.ttlLabel.setBounds(this.getWidth() - dimension.width, 0, this.getWidth(), dimension.height);
                } else {
                    WizardDisplayerImpl.this.ttlLabel.setBounds(0, 0, this.getWidth(), dimension.height);
                }
            }

            public Dimension getPreferredSize() {
                return WizardDisplayerImpl.this.ttlLabel.getPreferredSize();
            }
        };
        this.ttlPanel.add(this.ttlLabel);
        Font font = this.ttlLabel.getFont();
        if (font == null) {
            font = UIManager.getFont("controlFont");
        }
        if (font != null) {
            font = font.deriveFont(1);
            this.ttlLabel.setFont(font);
        }
    }

    private JPanel createOuterPanel(Wizard wizard, Rectangle rectangle, Action action, Map map) {
        this.wizard = wizard;
        this.outerPanel = new JPanel();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 600, 400);
        }
        if (this.wizard.getAllSteps().length == 0) {
            throw new IllegalArgumentException("Wizard has no steps");
        }
        this.buildStepTitle();
        this.buttonManager = new NavButtonManager(this);
        this.outerPanel.setLayout(new BorderLayout());
        this.instructions = new InstructionsPanel(this.wizard);
        this.buttonManager.buildButtons(action);
        this.inner = new JPanel();
        this.inner.setLayout(new BorderLayout());
        this.inner.add((Component)this.ttlPanel, "North");
        this.problem = new JLabel("  ");
        Color color = UIManager.getColor("nb.errorColor");
        this.problem.setForeground(color == null ? Color.BLUE : color);
        this.inner.add((Component)this.problem, "South");
        this.problem.setPreferredSize(new Dimension(20, 20));
        this.inner.setPreferredSize(new Dimension(450, 450));
        this.outerPanel.add((Component)this.buttonManager.getButtons(), "South");
        JSplitPane jSplitPane = new JSplitPane(1);
        jSplitPane.setLeftComponent(this.instructions);
        jSplitPane.setRightComponent(this.inner);
        this.outerPanel.add((Component)jSplitPane, "Center");
        String string = this.wizard.getAllSteps()[0];
        this.settings = new MergeMap(string);
        if (map != null) {
            this.settings.putAll(map);
        }
        this.wizardPanel = this.wizard.navigatingTo(string, (Map)this.settings);
        String string2 = this.wizard.getLongDescription(string);
        if (string2 != null) {
            this.ttlLabel.setText(string2);
        }
        this.inner.add((Component)this.wizardPanel, "Center");
        this.buttonManager.initializeNavigation();
        return this.outerPanel;
    }

    public void install(Container container, Object object, Wizard wizard, Action action, Map map, WizardResultReceiver wizardResultReceiver) {
        JPanel jPanel = this.createOuterPanel(wizard, new Rectangle(), action, map);
        if (object != null) {
            container.add((Component)jPanel, object);
        } else {
            container.add(jPanel);
        }
        this.receiver = wizardResultReceiver;
    }

    public Object show(Wizard wizard, Rectangle rectangle, Action action, Map map) {
        this.createOuterPanel(wizard, rectangle, action, map);
        Object object = this.showInDialog(rectangle);
        return object;
    }

    protected JDialog createDialog() {
        Window window = this.findLikelyOwnerWindow();
        JDialog jDialog = window instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog());
        return jDialog;
    }

    protected Object showInDialog(Rectangle rectangle) {
        Cloneable cloneable;
        JDialog jDialog = this.createDialog();
        this.buttonManager.setWindow((Window)jDialog);
        jDialog.setTitle(this.wizard.getTitle());
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)this.outerPanel, "Center");
        if (rectangle != null) {
            jDialog.setBounds(rectangle);
        } else {
            jDialog.pack();
            cloneable = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
            GraphicsConfiguration graphicsConfiguration = jDialog.getGraphicsConfiguration();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            ((Rectangle)cloneable).translate(insets.left, insets.top);
            ((Rectangle)cloneable).setSize(((Rectangle)cloneable).width - insets.left - insets.right, ((Rectangle)cloneable).height - insets.top - insets.bottom);
            if (jDialog.getWidth() > ((Rectangle)cloneable).width) {
                jDialog.setSize(((Rectangle)cloneable).width, jDialog.getHeight());
            }
        }
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent windowEvent) {
                if (!(windowEvent.getWindow() instanceof JDialog)) {
                    return;
                }
                JDialog jDialog = (JDialog)windowEvent.getWindow();
                boolean bl = false;
                if (!WizardDisplayerImpl.this.wizard.isBusy()) {
                    try {
                        if (WizardDisplayerImpl.this.deferredResult != null && WizardDisplayerImpl.this.deferredResult.canAbort()) {
                            WizardDisplayerImpl.this.deferredResult.abort();
                        } else if (WizardDisplayerImpl.this.deferredResult != null && !WizardDisplayerImpl.this.deferredResult.canAbort()) {
                            bl = true;
                            return;
                        }
                    }
                    finally {
                        if (!bl && WizardDisplayerImpl.this.wizard.cancel((Map)WizardDisplayerImpl.this.settings)) {
                            jDialog.setVisible(false);
                            jDialog.dispose();
                        }
                    }
                }
            }
        });
        cloneable = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (((Dimension)cloneable).width - jDialog.getWidth()) / 2;
        int n2 = (((Dimension)cloneable).height - jDialog.getHeight()) / 2;
        jDialog.setLocation(n, n2);
        jDialog.setModal(true);
        jDialog.getRootPane().setDefaultButton(this.buttonManager.getNext());
        jDialog.setVisible(true);
        return this.wizardResult;
    }

    private Window findLikelyOwnerWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public WizardPanel getCurrentWizardPanel() {
        JComponent jComponent = this.wizardPanel;
        if (jComponent instanceof WizardPanel) {
            return (WizardPanel)jComponent;
        }
        return null;
    }

    public String getCurrentStep() {
        return this.settings.currID();
    }

    static void checkLegalNavMode(int n) {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Illegal forward navigation mode: " + n);
    }

    public void setCurrentWizardPanel(JComponent jComponent) {
        this.inner.add((Component)jComponent, "Center");
        this.inner.remove(this.wizardPanel);
        this.wizardPanel = jComponent;
        this.inner.invalidate();
        this.inner.revalidate();
        this.inner.repaint();
        jComponent.requestFocus();
        if (!this.inSummary) {
            this.buttonManager.updateButtons();
        }
    }

    void handleSummary(Summary summary) {
        this.inSummary = true;
        JComponent jComponent = (JComponent)summary.getSummaryComponent();
        if (jComponent.getBorder() != null) {
            CompoundBorder compoundBorder = new CompoundBorder(new EmptyBorder(5, 5, 5, 5), jComponent.getBorder());
            jComponent.setBorder(compoundBorder);
        }
        this.setCurrentWizardPanel(jComponent);
        this.instructions.setInSummaryPage(true);
        this.ttlLabel.setText(NbBridge.getString("org/netbeans/api/wizard/Bundle", WizardDisplayerImpl.class, "Summary"));
        this.getButtonManager().setSummaryShowingMode();
        jComponent.requestFocus();
    }

    ResultProgressHandle createProgressDisplay(boolean bl) {
        return new NavProgress(this, bl);
    }

    void handleDeferredWizardResult(final DeferredWizardResult deferredWizardResult) {
        this.deferredResult = deferredWizardResult;
        this.wizardPanel.setEnabled(false);
        this.progress = this.createProgressDisplay(deferredWizardResult.isUseBusy());
        this.progress.addProgressComponents(this.instructions);
        this.instructions.invalidate();
        this.instructions.revalidate();
        this.instructions.repaint();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    try {
                        WizardDisplayerImpl.this.instructions.setInSummaryPage(true);
                        WizardDisplayerImpl.this.buttonManager.getWindow().setCursor(Cursor.getPredefinedCursor(3));
                        deferredWizardResult.start((Map)WizardDisplayerImpl.this.settings, WizardDisplayerImpl.this.progress);
                        if (!WizardDisplayerImpl.this.progress.isRunning()) return;
                        WizardDisplayerImpl.this.progress.failed("Start method did not inidicate failure or finished in " + deferredWizardResult, false);
                        return;
                    }
                    finally {
                        try {
                            EventQueue.invokeAndWait(this);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            return;
                        }
                        finally {
                            WizardDisplayerImpl.this.buttonManager.getWindow().setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                WizardDisplayerImpl.this.deferredResult = null;
                WizardDisplayerImpl.this.buttonManager.getCancel().setEnabled(true);
                WizardDisplayerImpl.this.instructions.removeAll();
                WizardDisplayerImpl.this.instructions.invalidate();
                WizardDisplayerImpl.this.instructions.revalidate();
                WizardDisplayerImpl.this.instructions.repaint();
            }
        };
        Thread thread = new Thread(runnable, "Wizard Background Result Thread " + deferredWizardResult);
        thread.start();
    }

    public void navigateTo(String string) {
        JComponent jComponent = this.wizard.navigatingTo(string, (Map)this.getSettings());
        String string2 = this.wizard.getLongDescription(string);
        if (string2 == null) {
            string2 = this.wizard.getStepDescription(string);
        }
        this.getTtlLabel().setText(string2);
        this.setCurrentWizardPanel(jComponent);
    }

    public NavButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public DeferredWizardResult getDeferredResult() {
        return this.deferredResult;
    }

    public InstructionsPanel getInstructions() {
        return this.instructions;
    }

    public boolean isInSummary() {
        return this.inSummary;
    }

    public void setInSummary(boolean bl) {
        this.inSummary = bl;
    }

    public JPanel getOuterPanel() {
        return this.outerPanel;
    }

    public MergeMap getSettings() {
        return this.settings;
    }

    public JLabel getTtlLabel() {
        return this.ttlLabel;
    }

    public JPanel getTtlPanel() {
        return this.ttlPanel;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public JComponent getWizardPanel() {
        return this.wizardPanel;
    }

    public Object getWizardResult() {
        return this.wizardResult;
    }

    public void setWizardResult(Object object) {
        this.wizardResult = object;
        if (this.receiver != null) {
            this.receiver.finished(object);
        }
    }

    public void setDeferredResult(DeferredWizardResult deferredWizardResult) {
        this.deferredResult = deferredWizardResult;
    }

    boolean cancel() {
        boolean bl;
        boolean bl2 = bl = this.receiver != null;
        if (bl) {
            this.receiver.cancelled((Map)this.settings);
        }
        return bl;
    }

    void updateProblem() {
        String string = this.wizard.getProblem();
        this.problem.setText(string == null ? " " : string);
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        Border border = string == null ? BorderFactory.createEmptyBorder(1, 0, 0, 0) : BorderFactory.createMatteBorder(1, 0, 0, 0, this.problem.getForeground());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12), border);
        this.problem.setBorder(compoundBorder);
    }
}

