/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardObserver;

public class InstructionsPanel
extends JComponent
implements WizardObserver,
Accessible {
    private static final long serialVersionUID = 1L;
    private final BufferedImage img;
    private final Wizard wizard;
    private static final int MARGIN = 5;
    String[] steps = new String[0];
    private int historicWidth = Integer.MIN_VALUE;
    private Dimension minSize = new Dimension();
    private boolean inSummaryPage;

    public InstructionsPanel(Wizard wizard) {
        this(null, wizard);
        Font font = UIManager.getFont("Tree.font");
        if (font != null) {
            this.setFont(font);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.wizard.addWizardObserver((WizardObserver)this);
    }

    public void removeNotify() {
        this.wizard.removeWizardObserver((WizardObserver)this);
        super.removeNotify();
    }

    BufferedImage getImage() {
        return this.img;
    }

    public InstructionsPanel(BufferedImage bufferedImage, Wizard wizard) {
        if (bufferedImage == null) {
            bufferedImage = (BufferedImage)UIManager.get("wizard.sidebar.image");
        }
        String string = System.getProperty("wizard.sidebar.image");
        if (bufferedImage == null && string != null) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            URL uRL = classLoader.getResource(string);
            if (uRL != null) {
                try {
                    bufferedImage = ImageIO.read(uRL);
                }
                catch (IOException iOException) {
                    System.err.println("Could not load wizard image " + iOException.getMessage());
                    System.setProperty("wizard.sidebar.image", null);
                    bufferedImage = null;
                }
            } else {
                System.err.println("Bad URL for wizard image " + string);
                System.setProperty("wizard.sidebar.image", null);
                bufferedImage = null;
            }
        }
        if (bufferedImage == null) {
            try {
                bufferedImage = ImageIO.read(InstructionsPanel.class.getResourceAsStream("defaultWizard.png"));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        this.img = bufferedImage;
        this.wizard = wizard;
    }

    public boolean isOpaque() {
        return this.img != null;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Font font = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Insets insets = this.getInsets();
        if (this.img != null) {
            int n = insets.left;
            int n2 = insets.top;
            graphics2D.drawImage((Image)this.img, n, n2, this);
        } else {
            graphics.setColor(Color.WHITE);
            graphics.fillRect(insets.left, insets.top, this.getWidth() - (insets.left + insets.right), this.getHeight() - (insets.top + insets.bottom));
        }
        String string = this.wizard.getCurrentStep();
        if (!this.inSummaryPage) {
            this.steps = this.wizard.getAllSteps();
        }
        String[] stringArray = this.steps;
        if (this.inSummaryPage) {
            String string2 = NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "Summary");
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray2.length - 1] = string2;
            stringArray = stringArray2;
        }
        int n = fontMetrics.getMaxAscent() + insets.top + 5;
        int n3 = insets.left + 5;
        int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 3;
        Font font2 = font.deriveFont(1);
        graphics.setFont(font2);
        graphics.drawString(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "Steps"), n3, n);
        int n5 = insets.top + 5 + fontMetrics.getAscent() + 3;
        graphics.drawLine(n3, n5, n3 + (this.getWidth() - (n3 + insets.left + 5)), n5);
        n += n4 + 10;
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl;
            boolean bl2;
            boolean bl3 = "_#UndeterminedStep".equals(stringArray[i]);
            boolean bl4 = bl2 = this.wizard.getForwardNavigationMode() == 2;
            if (bl3 && bl2) break;
            String string3 = this.inSummaryPage && i == this.steps.length ? i + 1 + ". " + stringArray[i] : i + 1 + ". " + (bl3 ? NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "elipsis") : this.wizard.getStepDescription(stringArray[i]));
            if (string3 == null) continue;
            boolean bl5 = bl = stringArray[i].equals(string) && !this.inSummaryPage || this.inSummaryPage && i == stringArray.length - 1;
            if (bl) {
                graphics.setFont(font2);
            }
            int n6 = fontMetrics.stringWidth(string3);
            while (n6 > this.getWidth() - (insets.left + insets.right) && string3.length() > 5) {
                string3 = string3.substring(0, string3.length() - 5) + NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "elipsis");
            }
            graphics.drawString(string3, n3, n);
            if (bl) {
                graphics.setFont(font);
            }
            n += n4;
        }
    }

    public Dimension getPreferredSize() {
        Font font = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            graphics = new BufferedImage(1, 1, 2).getGraphics();
        }
        font = font.deriveFont(1);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Insets insets = this.getInsets();
        int n = fontMetrics.getHeight();
        String[] stringArray = this.wizard.getAllSteps();
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = i + ". " + ("_#UndeterminedStep".equals(stringArray[i]) ? NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "elipsis") : this.wizard.getStepDescription(stringArray[i]));
            if (string == null) continue;
            n2 = Math.max(n2, fontMetrics.stringWidth(string) + 5);
        }
        if (Integer.MIN_VALUE == n2) {
            n2 = 250;
        }
        n = (n + 3) * stringArray.length;
        this.minSize.width = n2;
        this.minSize.height = n;
        if (this.img != null) {
            n2 = Math.max(n2, this.img.getWidth());
            n = Math.max(n, this.img.getHeight());
        }
        n = n + insets.top + insets.bottom;
        this.historicWidth = n2 = Math.max(n2, this.historicWidth);
        return new Dimension(n2, n);
    }

    public void setInSummaryPage(boolean bl) {
        this.inSummaryPage = bl;
        this.repaint();
    }

    public Dimension getMinimumSize() {
        this.getPreferredSize();
        return this.minSize;
    }

    public void stepsChanged(Wizard wizard) {
        this.repaint();
    }

    public void navigabilityChanged(Wizard wizard) {
    }

    public void selectionChanged(Wizard wizard) {
        this.repaint();
    }

    public void doLayout() {
        Component[] componentArray = this.getComponents();
        Insets insets = this.getInsets();
        int n = this.getHeight() - (5 + insets.bottom);
        int n2 = 5 + insets.left;
        int n3 = this.getWidth() - (10 + insets.left + insets.right);
        if (n3 < 0) {
            n3 = 0;
        }
        for (int i = componentArray.length - 1; i >= 0; --i) {
            Dimension dimension = componentArray[i].getPreferredSize();
            componentArray[i].setBounds(n2, n - dimension.height, n3, dimension.height);
            n -= dimension.height;
        }
    }

    public AccessibleContext getAccessibleContext() {
        return new ACI(this);
    }

    private static class ACI
    extends AccessibleContext {
        private final Wizard wizard;
        private final InstructionsPanel panel;
        JEditorPane pane;

        public ACI(InstructionsPanel instructionsPanel) {
            this.wizard = instructionsPanel.wizard;
            this.panel = instructionsPanel;
            if (instructionsPanel.getParent() instanceof Accessible) {
                this.setAccessibleParent((Accessible)((Object)instructionsPanel.getParent()));
            }
            this.setAccessibleName(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "ACN_InstructionsPanel"));
            this.setAccessibleDescription(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "ACSD_InstructionsPanel"));
        }

        public AccessibleText getAccessibleText() {
            if (this.pane == null) {
                this.pane = new JEditorPane();
                this.pane.setBounds(this.panel.getBounds());
                this.pane.getAccessibleContext().getAccessibleText();
                this.pane.setFont(this.panel.getFont());
                CellRendererPane cellRendererPane = new CellRendererPane();
                cellRendererPane.add(this.pane);
            }
            this.pane.setText(this.getText());
            this.pane.selectAll();
            this.pane.validate();
            return this.pane.getAccessibleContext().getAccessibleText();
        }

        public String getText() {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = this.wizard.getAllSteps();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(this.wizard.getStepDescription(stringArray[i]));
                stringBuffer.append('\n');
            }
            return stringBuffer.toString();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleState[] accessibleStateArray = new AccessibleState[]{AccessibleState.VISIBLE, AccessibleState.OPAQUE, AccessibleState.SHOWING, AccessibleState.MULTI_LINE};
            return new AccessibleStateSet(accessibleStateArray);
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            throw new IndexOutOfBoundsException("" + n);
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }
}

