/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdesktop.swingx.renderer.CellContext;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.LabelProvider;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.WrappingIconPanel;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.treetable.TreeTableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrappingProvider
extends ComponentProvider<WrappingIconPanel>
implements RolloverRenderer {
    protected ComponentProvider wrappee;
    private boolean unwrapUserObject;

    public WrappingProvider() {
        this((ComponentProvider)null);
    }

    public WrappingProvider(IconValue iconValue, StringValue wrappeeStringValue) {
        this(wrappeeStringValue);
        this.setStringValue(new MappedValue(null, iconValue));
    }

    public WrappingProvider(IconValue iconValue) {
        this();
        this.setStringValue(new MappedValue(null, iconValue));
    }

    public WrappingProvider(StringValue wrappeeStringValue) {
        this(new LabelProvider(wrappeeStringValue));
    }

    public WrappingProvider(ComponentProvider delegate) {
        this(delegate, true);
    }

    public WrappingProvider(ComponentProvider delegate, boolean unwrapUserObject) {
        this.setWrappee(delegate);
        this.setStringValue(StringValue.EMPTY);
        this.setUnwrapUserObject(unwrapUserObject);
    }

    public void setWrappee(ComponentProvider delegate) {
        if (delegate == null) {
            delegate = new LabelProvider();
        }
        this.wrappee = delegate;
    }

    public ComponentProvider getWrappee() {
        return this.wrappee;
    }

    public void setUnwrapUserObject(boolean unwrap) {
        this.unwrapUserObject = unwrap;
    }

    public boolean getUnwrapUserObject() {
        return this.unwrapUserObject;
    }

    @Override
    public String getString(Object value) {
        value = this.getUnwrappedValue(value);
        return this.wrappee.getString(value);
    }

    protected Object getUnwrappedValue(Object value) {
        if (!this.getUnwrapUserObject()) {
            return value;
        }
        if (value instanceof DefaultMutableTreeNode) {
            value = ((DefaultMutableTreeNode)value).getUserObject();
        } else if (value instanceof TreeTableNode) {
            TreeTableNode node = (TreeTableNode)value;
            value = node.getUserObject();
        }
        return value;
    }

    @Override
    public WrappingIconPanel getRendererComponent(CellContext context) {
        if (context != null) {
            ((WrappingIconPanel)this.rendererComponent).setComponent((JComponent)this.wrappee.rendererComponent);
            Object oldValue = this.adjustContextValue(context);
            super.getRendererComponent(context);
            this.wrappee.getRendererComponent(context);
            this.restoreContextValue(context, oldValue);
            return (WrappingIconPanel)this.rendererComponent;
        }
        return (WrappingIconPanel)super.getRendererComponent(context);
    }

    protected void restoreContextValue(CellContext context, Object oldValue) {
        context.replaceValue(oldValue);
    }

    protected Object adjustContextValue(CellContext context) {
        Object oldValue = context.getValue();
        if (this.getUnwrapUserObject()) {
            context.replaceValue(this.getUnwrappedValue(oldValue));
        }
        return oldValue;
    }

    @Override
    protected void configureState(CellContext context) {
        ((WrappingIconPanel)this.rendererComponent).setBorder(BorderFactory.createEmptyBorder());
    }

    @Override
    protected WrappingIconPanel createRendererComponent() {
        return new WrappingIconPanel();
    }

    @Override
    protected void format(CellContext context) {
        ((WrappingIconPanel)this.rendererComponent).setIcon(this.getValueAsIcon(context));
    }

    @Override
    protected Icon getValueAsIcon(CellContext context) {
        Icon icon = super.getValueAsIcon(context);
        if (icon == null) {
            return context.getIcon();
        }
        return IconValue.NULL_ICON == icon ? null : icon;
    }

    @Override
    public void doClick() {
        if (this.isEnabled()) {
            ((RolloverRenderer)((Object)this.wrappee)).doClick();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.wrappee instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.wrappee)).isEnabled();
    }
}

