/*
 * Decompiled with CFR 0.152.
 */
package VASSAL;

import VASSAL.tools.version.VassalVersionTokenizer;
import VASSAL.tools.version.VersionFormatException;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;

public final class Info {
    private static final String VERSION = "3.1.20";
    private static final String EXPIRY_VERSION = "3.2";
    private static File homeDir;
    private static final boolean isWindows;
    private static final boolean isMacOSX;
    private static final boolean isLinux;
    private static final boolean isX11;
    public static final String javaBinPath;
    private static final int instanceID;

    private Info() {
    }

    public static String getVersion() {
        return VERSION;
    }

    @Deprecated
    public static String getMinorVersion() {
        VassalVersionTokenizer vassalVersionTokenizer = new VassalVersionTokenizer(VERSION);
        try {
            return Integer.toString(vassalVersionTokenizer.next()) + "." + Integer.toString(vassalVersionTokenizer.next());
        }
        catch (VersionFormatException versionFormatException) {
            return null;
        }
    }

    public static int getInstanceID() {
        return instanceID;
    }

    public static Rectangle getScreenBounds(Component component) {
        Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        if (isX11) {
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            rectangle.setBounds(graphicsDevice.getDefaultConfiguration().getBounds());
            return rectangle;
        }
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        rectangle.translate(insets.left, insets.top);
        rectangle.setSize(rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
        return rectangle;
    }

    public static boolean isMacOSX() {
        return isMacOSX;
    }

    @Deprecated
    public static boolean isMacOsX() {
        return Info.isMacOSX();
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isLinux() {
        return isLinux;
    }

    public static boolean isX11() {
        return isX11;
    }

    public static boolean isModuleTooNew(String string) {
        return Info.compareVersions(string, EXPIRY_VERSION) >= 0;
    }

    public static int compareVersions(String string, String string2) {
        VassalVersionTokenizer vassalVersionTokenizer = new VassalVersionTokenizer(string);
        VassalVersionTokenizer vassalVersionTokenizer2 = new VassalVersionTokenizer(string2);
        try {
            while (vassalVersionTokenizer.hasNext() && vassalVersionTokenizer2.hasNext()) {
                int n;
                int n2 = vassalVersionTokenizer.next();
                if (n2 == (n = vassalVersionTokenizer2.next())) continue;
                return n2 - n;
            }
        }
        catch (VersionFormatException versionFormatException) {
            return 0;
        }
        return vassalVersionTokenizer.hasNext() ? 1 : (vassalVersionTokenizer2.hasNext() ? -1 : 0);
    }

    public static File getBaseDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getDocsDir() {
        String string = isMacOSX ? "Contents/Resources/doc" : "doc";
        return new File(Info.getBaseDir(), string);
    }

    public static File getBinDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File getDocDir() {
        String string = isMacOSX ? "Contents/Resources/doc" : "doc";
        return new File(Info.getBaseDir(), string);
    }

    public static File getConfDir() {
        return Info.getHomeDir();
    }

    public static File getTempDir() {
        return new File(Info.getHomeDir(), "tmp");
    }

    public static File getHomeDir() {
        if (homeDir == null && !(homeDir = isMacOSX ? new File(System.getProperty("user.home"), "Library/Application Support/VASSAL") : (isWindows ? new File(System.getenv("APPDATA") + "/VASSAL") : new File(System.getProperty("user.home"), ".VASSAL"))).exists()) {
            homeDir.mkdirs();
        }
        return homeDir;
    }

    @Deprecated
    public static boolean isDndEnabled() {
        return true;
    }

    @Deprecated
    public static boolean is2dEnabled() {
        return true;
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        isWindows = string.startsWith("windows");
        isMacOSX = string.startsWith("mac os x");
        isLinux = string.startsWith("linux");
        String string2 = System.getProperty("java.awt.graphicsenv").toLowerCase();
        isX11 = string2.indexOf("x11") != -1;
        javaBinPath = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        string = System.getProperty("VASSAL.id");
        if (string == null) {
            instanceID = 0;
        } else {
            int n;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            instanceID = n;
        }
    }
}

