/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Translatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBuildable
implements Buildable,
ValidityChecker {
    protected List<Buildable> buildComponents = new ArrayList<Buildable>();
    protected ValidityChecker validator;

    @Override
    public void build(Element element) {
        if (element != null) {
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                Attr attr = (Attr)namedNodeMap.item(i);
                this.setAttribute(attr.getName(), attr.getValue());
                if (!(this instanceof Translatable)) continue;
                Localization.getInstance().saveTranslatableAttribute((Translatable)((Object)this), attr.getName(), attr.getValue());
            }
            Builder.build(element, this);
        }
    }

    public abstract String[] getAttributeNames();

    public abstract void setAttribute(String var1, Object var2);

    public abstract String getAttributeValueString(String var1);

    @Deprecated
    public <T> Enumeration<T> getComponents(Class<T> clazz) {
        return Collections.enumeration(this.getComponentsOf(clazz));
    }

    public <T> List<T> getComponentsOf(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Buildable buildable : this.buildComponents) {
            if (!clazz.isInstance(buildable)) continue;
            arrayList.add(clazz.cast(buildable));
        }
        return arrayList;
    }

    @Deprecated
    public <T> Enumeration<T> getAllDescendantComponents(Class<T> clazz) {
        return Collections.enumeration(this.getAllDescendantComponentsOf(clazz));
    }

    public <T> List<T> getAllDescendantComponentsOf(Class<T> clazz) {
        ArrayList arrayList = new ArrayList();
        this.addComponents(clazz, arrayList);
        return arrayList;
    }

    private <T> void addComponents(Class<T> clazz, List<T> list) {
        if (clazz.isInstance(this)) {
            list.add(clazz.cast(this));
        }
        for (Buildable buildable : this.buildComponents) {
            if (clazz.isInstance(buildable)) {
                list.add(clazz.cast(buildable));
                continue;
            }
            if (!(buildable instanceof AbstractBuildable)) continue;
            ((AbstractBuildable)buildable).addComponents(clazz, list);
        }
    }

    @Override
    public Element getBuildElement(Document document) {
        Element element = document.createElement(this.getClass().getName());
        String[] stringArray = this.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            String object = this.getAttributeValueString(stringArray[i]);
            if (object == null) continue;
            element.setAttribute(stringArray[i], object);
        }
        for (Buildable buildable : this.getBuildables()) {
            element.appendChild(buildable.getBuildElement(document));
        }
        return element;
    }

    @Override
    public void add(Buildable buildable) {
        this.buildComponents.add(buildable);
    }

    @Deprecated
    public Enumeration<Buildable> getBuildComponents() {
        return Collections.enumeration(this.buildComponents);
    }

    public List<Buildable> getBuildables() {
        return Collections.unmodifiableList(this.buildComponents);
    }

    @Override
    public void validate(Buildable buildable, ValidationReport validationReport) {
        if (this.validator != null) {
            this.validator.validate(buildable, validationReport);
        }
        for (Buildable buildable2 : this.buildComponents) {
            if (!(buildable2 instanceof ValidityChecker)) continue;
            ((ValidityChecker)((Object)buildable2)).validate(buildable2, validationReport);
        }
    }
}

