/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GameModule;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangePiece;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.MovePiece;
import VASSAL.command.NullCommand;
import VASSAL.command.PlayAudioClipCommand;
import VASSAL.command.RemovePiece;
import VASSAL.counters.ActionButton;
import VASSAL.counters.AreaOfEffect;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Clone;
import VASSAL.counters.CounterGlobalKeyCommand;
import VASSAL.counters.Deck;
import VASSAL.counters.Decorator;
import VASSAL.counters.Delete;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.Embellishment;
import VASSAL.counters.Footprint;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalHotKey;
import VASSAL.counters.Hideable;
import VASSAL.counters.Immobilized;
import VASSAL.counters.Labeler;
import VASSAL.counters.Marker;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.NonRectangular;
import VASSAL.counters.Obscurable;
import VASSAL.counters.Pivot;
import VASSAL.counters.PlaceMarker;
import VASSAL.counters.PlaySound;
import VASSAL.counters.PropertySheet;
import VASSAL.counters.Replace;
import VASSAL.counters.ReportState;
import VASSAL.counters.RestrictCommands;
import VASSAL.counters.Restricted;
import VASSAL.counters.ReturnToDeck;
import VASSAL.counters.SendToLocation;
import VASSAL.counters.SetGlobalProperty;
import VASSAL.counters.Stack;
import VASSAL.counters.SubMenu;
import VASSAL.counters.TableInfo;
import VASSAL.counters.Translate;
import VASSAL.counters.TriggerAction;
import VASSAL.counters.UsePrototype;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.logging.Logger;
import java.awt.Point;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicCommandEncoder
implements CommandEncoder,
Buildable {
    private Map<String, BasicPieceFactory> basicFactories = new HashMap<String, BasicPieceFactory>();
    private Map<String, DecoratorFactory> decoratorFactories = new HashMap<String, DecoratorFactory>();
    private static final char PARAM_SEPARATOR = '/';
    public static final String ADD = "+/";
    public static final String REMOVE = "-/";
    public static final String CHANGE = "D/";
    public static final String MOVE = "M/";

    public BasicCommandEncoder() {
        this.basicFactories.put("stack", new BasicPieceFactory(){

            public GamePiece createBasicPiece(String string) {
                return new Stack();
            }
        });
        this.basicFactories.put("piece;", new BasicPieceFactory(){

            public GamePiece createBasicPiece(String string) {
                return new BasicPiece(string);
            }
        });
        this.basicFactories.put("deck;", new BasicPieceFactory(){

            public GamePiece createBasicPiece(String string) {
                return new Deck(string);
            }
        });
        this.decoratorFactories.put("immob;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Immobilized(gamePiece, string);
            }
        });
        this.decoratorFactories.put("emb2;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Embellishment(string, gamePiece);
            }
        });
        this.decoratorFactories.put("emb;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Embellishment(string, gamePiece);
            }
        });
        this.decoratorFactories.put("hide;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Hideable(string, gamePiece);
            }
        });
        this.decoratorFactories.put("obs;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Obscurable(string, gamePiece);
            }
        });
        this.decoratorFactories.put("label;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Labeler(string, gamePiece);
            }
        });
        this.decoratorFactories.put("table;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new TableInfo(string, gamePiece);
            }
        });
        this.decoratorFactories.put("propertysheet;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new PropertySheet(string, gamePiece);
            }
        });
        this.decoratorFactories.put("rotate;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new FreeRotator(string, gamePiece);
            }
        });
        this.decoratorFactories.put("pivot;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Pivot(string, gamePiece);
            }
        });
        this.decoratorFactories.put("nonRect;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new NonRectangular(string, gamePiece);
            }
        });
        this.decoratorFactories.put("mark;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Marker(string, gamePiece);
            }
        });
        this.decoratorFactories.put("restrict;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Restricted(string, gamePiece);
            }
        });
        this.decoratorFactories.put("placemark;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new PlaceMarker(string, gamePiece);
            }
        });
        this.decoratorFactories.put("replace;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Replace(string, gamePiece);
            }
        });
        this.decoratorFactories.put("report;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new ReportState(string, gamePiece);
            }
        });
        this.decoratorFactories.put("markmoved;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new MovementMarkable(string, gamePiece);
            }
        });
        this.decoratorFactories.put("footprint;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Footprint(string, gamePiece);
            }
        });
        this.decoratorFactories.put("return;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new ReturnToDeck(string, gamePiece);
            }
        });
        this.decoratorFactories.put("sendto;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new SendToLocation(string, gamePiece);
            }
        });
        this.decoratorFactories.put("prototype;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new UsePrototype(string, gamePiece);
            }
        });
        this.decoratorFactories.put("clone;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Clone(string, gamePiece);
            }
        });
        this.decoratorFactories.put("delete;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Delete(string, gamePiece);
            }
        });
        this.decoratorFactories.put("submenu;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new SubMenu(string, gamePiece);
            }
        });
        this.decoratorFactories.put("translate;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new Translate(string, gamePiece);
            }
        });
        this.decoratorFactories.put("AreaOfEffect;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new AreaOfEffect(string, gamePiece);
            }
        });
        this.decoratorFactories.put("globalkey;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new CounterGlobalKeyCommand(string, gamePiece);
            }
        });
        this.decoratorFactories.put("macro;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new TriggerAction(string, gamePiece);
            }
        });
        this.decoratorFactories.put("PROP;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new DynamicProperty(string, gamePiece);
            }
        });
        this.decoratorFactories.put("setprop;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new SetGlobalProperty(string, gamePiece);
            }
        });
        this.decoratorFactories.put("hideCmd;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new RestrictCommands(string, gamePiece);
            }
        });
        this.decoratorFactories.put("playSound;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new PlaySound(string, gamePiece);
            }
        });
        this.decoratorFactories.put("button;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new ActionButton(string, gamePiece);
            }
        });
        this.decoratorFactories.put("globalhotkey;", new DecoratorFactory(){

            public Decorator createDecorator(String string, GamePiece gamePiece) {
                return new GlobalHotKey(string, gamePiece);
            }
        });
    }

    public Decorator createDecorator(String string, GamePiece gamePiece) {
        DecoratorFactory decoratorFactory;
        Decorator decorator = null;
        String string2 = string.substring(0, string.indexOf(59) + 1);
        if (string2.length() == 0) {
            string2 = string;
        }
        if ((decoratorFactory = this.decoratorFactories.get(string2)) != null) {
            decorator = decoratorFactory.createDecorator(string, gamePiece);
        } else {
            System.err.println("Unknown type " + string);
            decorator = new Marker("mark;", gamePiece);
        }
        return decorator;
    }

    protected GamePiece createBasic(String string) {
        BasicPieceFactory basicPieceFactory;
        GamePiece gamePiece = null;
        String string2 = string.substring(0, string.indexOf(59) + 1);
        if (string2.length() == 0) {
            string2 = string;
        }
        if ((basicPieceFactory = this.basicFactories.get(string2)) != null) {
            gamePiece = basicPieceFactory.createBasicPiece(string);
        }
        return gamePiece;
    }

    public GamePiece createPiece(String string) {
        String string2;
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '\t');
        string = decoder.nextToken();
        String string3 = string2 = decoder.hasMoreTokens() ? decoder.nextToken() : null;
        if (string2 != null) {
            Decorator decorator;
            GamePiece gamePiece = this.createPiece(string2);
            if (gamePiece == null) {
                GameModule.getGameModule().getChatter().send("Invalid piece type - see Error Log for details");
                Logger.log("Could not create piece with type " + string2);
                gamePiece = new BasicPiece();
            }
            return (decorator = this.createDecorator(string, gamePiece)) != null ? decorator : gamePiece;
        }
        return this.createBasic(string);
    }

    public void build(Element element) {
        Builder.build(element, this);
    }

    public void addTo(Buildable buildable) {
        ((GameModule)buildable).addCommandEncoder(this);
    }

    public void add(Buildable buildable) {
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public Command decode(String string) {
        if (string.length() == 0) {
            return new NullCommand();
        }
        if (string.startsWith(ADD)) {
            string = string.substring(ADD.length());
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
            String string2 = this.unwrapNull(decoder.nextToken());
            String string3 = decoder.nextToken();
            String string4 = decoder.nextToken();
            GamePiece gamePiece = this.createPiece(string3);
            if (gamePiece == null) {
                return null;
            }
            gamePiece.setId(string2);
            return new AddPiece(gamePiece, string4);
        }
        if (string.startsWith(REMOVE)) {
            String string5 = string.substring(REMOVE.length());
            GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(string5);
            if (gamePiece == null) {
                return new RemovePiece(string5);
            }
            return new RemovePiece(gamePiece);
        }
        if (string.startsWith(CHANGE)) {
            string = string.substring(CHANGE.length());
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
            String string6 = decoder.nextToken();
            String string7 = decoder.nextToken();
            String string8 = decoder.hasMoreTokens() ? decoder.nextToken() : null;
            return new ChangePiece(string6, string8, string7);
        }
        if (string.startsWith(MOVE)) {
            string = string.substring(MOVE.length());
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, '/');
            String string9 = this.unwrapNull(decoder.nextToken());
            String string10 = this.unwrapNull(decoder.nextToken());
            int n = Integer.parseInt(decoder.nextToken());
            int n2 = Integer.parseInt(decoder.nextToken());
            String string11 = this.unwrapNull(decoder.nextToken());
            String string12 = this.unwrapNull(decoder.nextToken());
            int n3 = Integer.parseInt(decoder.nextToken());
            int n4 = Integer.parseInt(decoder.nextToken());
            String string13 = this.unwrapNull(decoder.nextToken());
            String string14 = decoder.nextToken(GameModule.getUserId());
            return new MovePiece(string9, string10, new Point(n, n2), string11, string12, new Point(n3, n4), string13, string14);
        }
        return PlayAudioClipCommand.decode(string);
    }

    private String wrapNull(String string) {
        return string == null ? "null" : string;
    }

    private String unwrapNull(String string) {
        return "null".equals(string) ? null : string;
    }

    public String encode(Command command) {
        SequenceEncoder sequenceEncoder = new SequenceEncoder('/');
        if (command instanceof AddPiece) {
            AddPiece addPiece = (AddPiece)command;
            return ADD + sequenceEncoder.append(this.wrapNull(addPiece.getTarget().getId())).append(addPiece.getTarget().getType()).append(addPiece.getState()).getValue();
        }
        if (command instanceof RemovePiece) {
            return REMOVE + ((RemovePiece)command).getId();
        }
        if (command instanceof ChangePiece) {
            ChangePiece changePiece = (ChangePiece)command;
            sequenceEncoder.append(changePiece.getId()).append(changePiece.getNewState());
            if (changePiece.getOldState() != null) {
                sequenceEncoder.append(changePiece.getOldState());
            }
            return CHANGE + sequenceEncoder.getValue();
        }
        if (command instanceof MovePiece) {
            MovePiece movePiece = (MovePiece)command;
            sequenceEncoder.append(movePiece.getId()).append(this.wrapNull(movePiece.getNewMapId())).append(movePiece.getNewPosition().x + "").append(movePiece.getNewPosition().y + "").append(this.wrapNull(movePiece.getNewUnderneathId())).append(this.wrapNull(movePiece.getOldMapId())).append(movePiece.getOldPosition().x + "").append(movePiece.getOldPosition().y + "").append(this.wrapNull(movePiece.getOldUnderneathId())).append(movePiece.getPlayerId());
            return MOVE + sequenceEncoder.getValue();
        }
        if (command instanceof NullCommand) {
            return "";
        }
        if (command instanceof PlayAudioClipCommand) {
            return ((PlayAudioClipCommand)command).encode();
        }
        return null;
    }

    public static interface BasicPieceFactory {
        public GamePiece createBasicPiece(String var1);
    }

    public static interface DecoratorFactory {
        public Decorator createDecorator(String var1, GamePiece var2);
    }
}

