/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.IconConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.launch.Launcher;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.Obfuscator;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.LogFileFilter;
import VASSAL.tools.io.FastByteArrayOutputStream;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicLogger
implements Logger,
Buildable,
GameComponent,
CommandEncoder {
    public static final String BEGIN = "begin_log";
    public static final String END = "end_log";
    public static final String LOG = "LOG\t";
    public static final String PROMPT_NEW_LOG = "PromptNewLog";
    public static final String PROMPT_NEW_LOG_START = "PromptNewLogStart";
    public static final String PROMPT_NEW_LOG_END = "PromptNewLogEnd";
    public static final String PROMPT_LOG_COMMENT = "promptLogComment";
    protected static final String STEP_ICON = "/images/StepForward16.gif";
    protected static final String UNDO_ICON = "/images/Undo16.gif";
    protected List<Command> logInput;
    protected List<Command> logOutput;
    protected int nextInput = 0;
    protected int nextUndo = -1;
    protected Command beginningState;
    protected File outputFile;
    protected Action stepAction = new StepAction();
    protected SaveMetaData metadata;
    protected Action undoAction = new UndoAction();
    protected Action endLogAction = new AbstractAction(Resources.getString("BasicLogger.end_logfile")){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BasicLogger.this.write();
                GameModule.getGameModule().warn(Resources.getString("BasicLogger.logfile_written"));
                BasicLogger.this.newLogAction.setEnabled(true);
                GameModule.getGameModule().appendToTitle(null);
                BasicLogger.this.outputFile = null;
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, BasicLogger.this.outputFile);
            }
        }
    };
    protected Action newLogAction = new AbstractAction(Resources.getString("BasicLogger.begin_logfile")){
        private static final long serialVersionUID = 1L;

        public void actionPerformed(ActionEvent actionEvent) {
            BasicLogger.this.beginOutput();
        }
    };

    public BasicLogger() {
        this.stepAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.endLogAction.setEnabled(false);
        this.newLogAction.setEnabled(false);
        this.logInput = new ArrayList<Command>();
        this.logOutput = new ArrayList<Command>();
    }

    public void build(Element element) {
    }

    public void addTo(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.addCommandEncoder(this);
        gameModule.getGameState().addGameComponent(this);
        MenuManager menuManager = MenuManager.getInstance();
        this.newLogAction.putValue("MnemonicKey", Resources.getString("BasicLogger.begin_logfile.shortcut").charAt(0));
        menuManager.addAction("BasicLogger.begin_logfile", this.newLogAction);
        this.endLogAction.putValue("MnemonicKey", Resources.getString("BasicLogger.end_logfile.shortcut").charAt(0));
        menuManager.addAction("BasicLogger.end_logfile", this.endLogAction);
        JButton jButton = gameModule.getToolBar().add(this.undoAction);
        jButton.setToolTipText(Resources.getString("BasicLogger.undo_last_move"));
        jButton.setAlignmentY(0.0f);
        jButton = gameModule.getToolBar().add(this.stepAction);
        jButton.setToolTipText(Resources.getString("BasicLogger.step_forward_tooltip"));
        jButton.setAlignmentY(0.0f);
        final KeyStrokeListener keyStrokeListener = new KeyStrokeListener(this.stepAction, KeyStroke.getKeyStroke(34, 0));
        gameModule.addKeyStrokeListener(keyStrokeListener);
        KeyStrokeListener keyStrokeListener2 = new KeyStrokeListener(this.newLogAction, KeyStroke.getKeyStroke(87, 8));
        gameModule.addKeyStrokeListener(keyStrokeListener2);
        final IconConfigurer iconConfigurer = new IconConfigurer("stepIcon", Resources.getString("BasicLogger.step_forward_button"), STEP_ICON);
        iconConfigurer.setValue(STEP_ICON);
        GlobalOptions.getInstance().addOption(iconConfigurer);
        iconConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicLogger.this.stepAction.putValue("SmallIcon", iconConfigurer.getIconValue());
            }
        });
        iconConfigurer.fireUpdate();
        final IconConfigurer iconConfigurer2 = new IconConfigurer("undoIcon", Resources.getString("BasicLogger.undo_icon"), UNDO_ICON);
        iconConfigurer2.setValue(UNDO_ICON);
        GlobalOptions.getInstance().addOption(iconConfigurer2);
        iconConfigurer2.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                BasicLogger.this.undoAction.putValue("SmallIcon", iconConfigurer2.getIconValue());
            }
        });
        iconConfigurer2.fireUpdate();
        final HotKeyConfigurer hotKeyConfigurer = new HotKeyConfigurer("stepHotKey", Resources.getString("BasicLogger.step_forward_hotkey"), keyStrokeListener.getKeyStroke());
        GlobalOptions.getInstance().addOption(hotKeyConfigurer);
        hotKeyConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                keyStrokeListener.setKeyStroke((KeyStroke)hotKeyConfigurer.getValue());
                BasicLogger.this.stepAction.putValue("ShortDescription", Resources.getString("BasicLogger.step_forward_tooltip2", HotKeyConfigurer.getString(keyStrokeListener.getKeyStroke())));
            }
        });
        hotKeyConfigurer.fireUpdate();
        BooleanConfigurer booleanConfigurer = new BooleanConfigurer(PROMPT_NEW_LOG_START, Resources.getString("BasicLogger.prompt_new_log_before"), Boolean.FALSE);
        gameModule.getPrefs().addOption(Resources.getString("Prefs.general_tab"), booleanConfigurer);
        BooleanConfigurer booleanConfigurer2 = new BooleanConfigurer(PROMPT_NEW_LOG_END, Resources.getString("BasicLogger.prompt_new_log_after"), Boolean.TRUE);
        gameModule.getPrefs().addOption(Resources.getString("Prefs.general_tab"), booleanConfigurer2);
        BooleanConfigurer booleanConfigurer3 = new BooleanConfigurer(PROMPT_LOG_COMMENT, Resources.getString("BasicLogger.enable_comments"), Boolean.TRUE);
        gameModule.getPrefs().addOption(Resources.getString("Prefs.general_tab"), booleanConfigurer3);
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void add(Buildable buildable) {
    }

    public void remove(Buildable buildable) {
    }

    public void setup(boolean bl) {
        this.newLogAction.setEnabled(bl);
        if (bl) {
            this.logOutput.clear();
            this.nextInput = 0;
            this.nextUndo = -1;
            this.beginningState = GameModule.getGameModule().getGameState().getRestoreCommand();
        } else {
            if (this.endLogAction.isEnabled() && JOptionPane.showConfirmDialog(GameModule.getGameModule().getFrame(), Resources.getString("BasicLogger.save_log"), Resources.getString("BasicLogger.unsaved_log"), 0) == 0) {
                try {
                    this.write();
                }
                catch (IOException iOException) {
                    WriteErrorDialog.error(iOException, this.outputFile);
                }
            }
            this.logInput.clear();
            this.beginningState = null;
            this.undoAction.setEnabled(false);
            this.endLogAction.setEnabled(false);
            this.stepAction.setEnabled(false);
            this.outputFile = null;
        }
    }

    public boolean isLogging() {
        return this.outputFile != null;
    }

    public Command getRestoreCommand() {
        return null;
    }

    public void enableDrawing(boolean bl) {
    }

    protected void step() {
        Command command = this.logInput.get(this.nextInput++);
        command.execute();
        GameModule.getGameModule().sendAndLog(command);
        this.stepAction.setEnabled(this.nextInput < this.logInput.size());
        if (this.nextInput >= this.logInput.size()) {
            this.queryNewLogFile(false);
        }
    }

    public void queryNewLogFile(boolean bl) {
        String string;
        String string2;
        if (this.isLogging()) {
            return;
        }
        if (bl) {
            string2 = PROMPT_NEW_LOG_START;
            string = Resources.getString("BasicLogger.replay_commencing");
        } else {
            string2 = PROMPT_NEW_LOG_END;
            string = Resources.getString("BasicLogger.replay_completed");
        }
        if (((Boolean)GameModule.getGameModule().getPrefs().getValue(string2)).booleanValue()) {
            Object[] objectArray = new Object[]{Resources.getString("General.yes"), Resources.getString("General.no"), Resources.getString("BasicLogger.dont_prompt_again")};
            int n = JOptionPane.showOptionDialog(GameModule.getGameModule().getFrame(), Resources.getString("BasicLogger.start_new_log_file", string), "", 1, 3, null, objectArray, objectArray[0]);
            if (n == 0) {
                this.beginOutput();
            } else if (n == 2) {
                GameModule.getGameModule().getPrefs().setValue(string2, Boolean.FALSE);
            }
        }
    }

    public void write() throws IOException {
        if (!this.logOutput.isEmpty()) {
            Command command = this.beginningState;
            for (Command object2 : this.logOutput) {
                command.append(new LogCommand(object2, this.logInput, this.stepAction));
            }
            String string = GameModule.getGameModule().encode(command);
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            new Obfuscator(string.getBytes("UTF-8")).write(fastByteArrayOutputStream);
            ArchiveWriter archiveWriter = new ArchiveWriter(this.outputFile.getPath());
            archiveWriter.addFile("savedGame", fastByteArrayOutputStream.toInputStream());
            this.metadata.save(archiveWriter);
            archiveWriter.write();
            Launcher.getInstance().sendSaveCmd(this.outputFile);
            GameModule.getGameModule().getGameState().setModified(false);
            this.undoAction.setEnabled(false);
        }
        this.endLogAction.setEnabled(false);
    }

    private File getSaveFile() {
        int n;
        String string;
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.addChoosableFileFilter(new LogFileFilter());
        String string2 = string = fileChooser.getSelectedFile() == null ? null : fileChooser.getSelectedFile().getName();
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            string = string.substring(0, n) + ".vlog";
            fileChooser.setSelectedFile(new File(fileChooser.getSelectedFile().getParent(), string));
        }
        if (fileChooser.showSaveDialog() != 0) {
            return null;
        }
        File file = fileChooser.getSelectedFile();
        if (file.getName().indexOf(46) == -1) {
            file = new File(file.getParent(), file.getName() + ".vlog");
        }
        return file;
    }

    protected void beginOutput() {
        this.outputFile = this.getSaveFile();
        if (this.outputFile == null) {
            return;
        }
        GameModule gameModule = GameModule.getGameModule();
        this.logOutput.clear();
        this.beginningState = gameModule.getGameState().getRestoreCommand();
        this.undoAction.setEnabled(false);
        this.endLogAction.setEnabled(true);
        gameModule.appendToTitle(Resources.getString("BasicLogger.logging_to", this.outputFile.getName()));
        this.newLogAction.setEnabled(false);
        this.metadata = new SaveMetaData();
    }

    protected void undo() {
        Command command;
        Command command2 = this.logOutput.get(this.nextUndo);
        Command command3 = command = this.nextInput > this.logInput.size() || this.nextInput < 1 ? null : this.logInput.get(this.nextInput - 1);
        if (command == command2) {
            while (this.nextInput-- > 0) {
                this.stepAction.setEnabled(true);
                if (this.logInput.get(this.nextInput).getUndoCommand() == null) continue;
            }
        }
        while (this.nextUndo-- > 0 && this.logOutput.get(this.nextUndo).getUndoCommand() == null) {
        }
        this.undoAction.setEnabled(this.nextUndo >= 0);
        Command command4 = command2.getUndoCommand();
        command4.execute();
        GameModule.getGameModule().getServer().sendToOthers(command4);
        this.logOutput.add(command4);
    }

    public void log(Command command) {
        if (command != null && command.isLoggable()) {
            this.logOutput.add(command);
            if (command.getUndoCommand() != null && !command.getUndoCommand().isNull()) {
                this.nextUndo = this.logOutput.size() - 1;
            }
        }
        this.undoAction.setEnabled(this.nextUndo >= 0);
    }

    public boolean hasMoreCommands() {
        return this.nextInput < this.logInput.size();
    }

    public String encode(Command command) {
        if (command instanceof LogCommand) {
            return LOG + GameModule.getGameModule().encode(((LogCommand)command).getLoggedCommand());
        }
        return null;
    }

    public Command decode(String string) {
        Command command;
        if (string.startsWith(LOG) && (command = GameModule.getGameModule().decode(string.substring(LOG.length()))) != null) {
            return new LogCommand(command, this.logInput, this.stepAction);
        }
        return null;
    }

    public class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public UndoAction() {
            URL uRL = this.getClass().getResource(BasicLogger.UNDO_ICON);
            if (uRL != null) {
                this.putValue("SmallIcon", new ImageIcon(uRL));
            } else {
                this.putValue("Name", Resources.getString("BasicLogger.undo"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicLogger.this.undo();
        }
    }

    public class StepAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public StepAction() {
            URL uRL = this.getClass().getResource(BasicLogger.STEP_ICON);
            if (uRL != null) {
                this.putValue("SmallIcon", new ImageIcon(uRL));
            } else {
                this.putValue("Name", Resources.getString("BasicLogger.step"));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicLogger.this.step();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogCommand
    extends Command {
        protected Command logged;
        protected List<Command> logInput;
        protected Action stepAction;

        public LogCommand(Command command, List<Command> list, Action action) {
            if (command instanceof LogCommand) {
                throw new UnsupportedOperationException(Resources.getString("BasicLogger.cant_log"));
            }
            this.logInput = list;
            this.stepAction = action;
            this.logged = command;
            for (Command command2 : command.getSubCommands()) {
                this.append(new LogCommand(command2, list, action));
            }
            this.logged.stripSubCommands();
        }

        @Override
        protected void executeCommand() {
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }

        public Command getLoggedCommand() {
            return this.logged;
        }

        @Override
        public void execute() {
            Command command = this.assembleCommand();
            this.logInput.add(command);
            this.stepAction.setEnabled(true);
        }

        protected Command assembleCommand() {
            Command command = this.logged;
            for (Command command2 : this.getSubCommands()) {
                command.append(((LogCommand)command2).assembleCommand());
            }
            return command;
        }
    }
}

