/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.noteswindow.PrivateNotesController;
import VASSAL.build.module.noteswindow.SecretNotesController;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesWindow
extends AbstractConfigurable
implements GameComponent,
CommandEncoder {
    protected JDialog frame;
    protected LaunchButton launch;
    protected TextConfigurer scenarioNotes;
    protected TextConfigurer publicNotes;
    protected PrivateNotesController privateNotes = new PrivateNotesController();
    protected SecretNotesController secretNotes = new SecretNotesController();
    protected static final String SCENARIO_NOTE_COMMAND_PREFIX = "NOTES\t";
    protected static final String PUBLIC_NOTE_COMMAND_PREFIX = "PNOTES\t";
    public static final String HOT_KEY = "hotkey";
    public static final String ICON = "icon";
    public static final String BUTTON_TEXT = "buttonText";
    public static final String TOOLTIP = "tooltip";
    protected String lastSavedScenarioNotes;
    protected String lastSavedPublicNotes;

    public NotesWindow() {
        this.frame = new NotesDialog();
        this.frame.setTitle(Resources.getString("Notes.notes"));
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NotesWindow.this.captureState();
                NotesWindow.this.frame.setVisible(!NotesWindow.this.frame.isShowing());
            }
        };
        this.launch = new LaunchButton(Resources.getString("Notes.notes"), TOOLTIP, BUTTON_TEXT, HOT_KEY, ICON, actionListener);
        this.launch.setAttribute(ICON, "/images/notes.gif");
        this.launch.setToolTipText(Resources.getString("Notes.notes"));
        this.frame.pack();
        this.setup(false);
    }

    protected void captureState() {
        this.lastSavedScenarioNotes = (String)this.scenarioNotes.getValue();
        this.lastSavedPublicNotes = (String)this.publicNotes.getValue();
        this.privateNotes.captureState();
        this.secretNotes.captureState();
    }

    public void cancel() {
        this.restoreState();
        this.privateNotes.restoreState();
        this.secretNotes.restoreState();
    }

    protected void restoreState() {
        this.scenarioNotes.setValue(this.lastSavedScenarioNotes);
        this.publicNotes.setValue(this.lastSavedPublicNotes);
    }

    protected void save() {
        NullCommand nullCommand = new NullCommand();
        if (!this.lastSavedScenarioNotes.equals(this.scenarioNotes.getValue())) {
            nullCommand.append(new SetScenarioNote(this.scenarioNotes.getValueString()));
        }
        if (!this.lastSavedPublicNotes.equals(this.publicNotes.getValue())) {
            nullCommand.append(new SetPublicNote(this.publicNotes.getValueString()));
        }
        nullCommand.append(this.privateNotes.save());
        nullCommand.append(this.secretNotes.save());
        GameModule.getGameModule().sendAndLog(nullCommand);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "NotesWindow");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON, HOT_KEY};
    }

    @Override
    public void setAttribute(String string, Object object) {
        this.launch.setAttribute(string, object);
    }

    @Override
    public String getAttributeValueString(String string) {
        return this.launch.getAttributeValueString(string);
    }

    @Override
    public String encode(Command command) {
        String string = null;
        if (command instanceof SetScenarioNote) {
            string = SCENARIO_NOTE_COMMAND_PREFIX + ((SetScenarioNote)command).msg;
        } else if (command instanceof SetPublicNote) {
            string = PUBLIC_NOTE_COMMAND_PREFIX + ((SetPublicNote)command).msg;
        } else {
            string = this.privateNotes.encode(command);
            if (string == null) {
                string = this.secretNotes.encode(command);
            }
        }
        return string;
    }

    @Override
    public Command decode(String string) {
        Command command;
        if (string.startsWith(SCENARIO_NOTE_COMMAND_PREFIX)) {
            command = new SetScenarioNote(string.substring(SCENARIO_NOTE_COMMAND_PREFIX.length()));
        } else if (string.startsWith(PUBLIC_NOTE_COMMAND_PREFIX)) {
            command = new SetPublicNote(string.substring(PUBLIC_NOTE_COMMAND_PREFIX.length()));
        } else {
            command = this.privateNotes.decode(string);
            if (command == null) {
                command = this.secretNotes.decode(string);
            }
        }
        return command;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Button text:  ", "Tooltip text:  ", "Button Icon:  ", "Hotkey:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, KeyStroke.class};
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    public static String getConfigureTypeName() {
        return "Notes Window";
    }

    @Override
    public void addTo(Buildable buildable) {
        GameModule.getGameModule().getToolBar().add(this.launch);
        this.launch.setAlignmentY(0.0f);
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this.privateNotes);
        GameModule.getGameModule().getGameState().addGameComponent(this.privateNotes);
        GameModule.getGameModule().addCommandEncoder(this.secretNotes);
        GameModule.getGameModule().getGameState().addGameComponent(this.secretNotes);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule.getGameModule().getToolBar().remove(this.launch);
        GameModule.getGameModule().removeCommandEncoder(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
        GameModule.getGameModule().removeCommandEncoder(this.privateNotes);
        GameModule.getGameModule().getGameState().removeGameComponent(this.privateNotes);
        GameModule.getGameModule().removeCommandEncoder(this.secretNotes);
        GameModule.getGameModule().getGameState().removeGameComponent(this.secretNotes);
    }

    @Override
    public void setup(boolean bl) {
        this.launch.setEnabled(bl);
        if (!bl) {
            this.scenarioNotes.setValue("");
            this.publicNotes.setValue("");
        }
    }

    @Override
    public Command getRestoreCommand() {
        SetScenarioNote setScenarioNote = new SetScenarioNote(this.scenarioNotes.getValueString());
        setScenarioNote.append(new SetPublicNote(this.publicNotes.getValueString()));
        setScenarioNote.append(this.privateNotes.getRestoreCommand());
        setScenarioNote.append(this.secretNotes.getRestoreCommand());
        return setScenarioNote;
    }

    protected class SetPublicNote
    extends Command {
        protected String msg;

        protected SetPublicNote(String string) {
            this.msg = string;
        }

        protected void executeCommand() {
            NotesWindow.this.publicNotes.setValue(this.msg);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    protected class SetScenarioNote
    extends Command {
        protected String msg;

        protected SetScenarioNote(String string) {
            this.msg = string;
        }

        protected void executeCommand() {
            NotesWindow.this.scenarioNotes.setValue(this.msg);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, ((NotesWindow)autoConfigurable).launch.getAttributeValueString(NotesWindow.ICON));
        }
    }

    protected class NotesDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;

        protected NotesDialog() {
            super(GameModule.getGameModule().getFrame());
            this.initComponents();
            this.setLocationRelativeTo(this.getOwner());
        }

        protected void initComponents() {
            this.setLayout(new BoxLayout(this.getContentPane(), 1));
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    NotesWindow.this.cancel();
                    NotesDialog.this.setVisible(false);
                }
            });
            NotesWindow.this.scenarioNotes = new TextConfigurer(null, null);
            NotesWindow.this.publicNotes = new TextConfigurer(null, null);
            JTabbedPane jTabbedPane = new JTabbedPane();
            this.add(jTabbedPane);
            Box box = Box.createVerticalBox();
            box.add(new JLabel(Resources.getString("Notes.visible_to_all")));
            box.add(NotesWindow.this.scenarioNotes.getControls());
            jTabbedPane.addTab(Resources.getString("Notes.scenario"), box);
            box = Box.createVerticalBox();
            box.add(new JLabel(Resources.getString("Notes.visible_to_all")));
            box.add(NotesWindow.this.publicNotes.getControls());
            jTabbedPane.addTab(Resources.getString("Notes.public"), box);
            jTabbedPane.addTab(Resources.getString("Notes.private"), NotesWindow.this.privateNotes.getControls());
            jTabbedPane.addTab(Resources.getString("Notes.delayed"), NotesWindow.this.secretNotes.getControls());
            JPanel jPanel = new JPanel();
            JButton jButton = new JButton(Resources.getString("General.save"));
            jPanel.add(jButton);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NotesWindow.this.save();
                    NotesDialog.this.setVisible(false);
                }
            });
            JButton jButton2 = new JButton(Resources.getString("General.cancel"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    NotesWindow.this.cancel();
                    NotesDialog.this.setVisible(false);
                }
            });
            jPanel.add(jButton2);
            this.add(jPanel);
        }
    }
}

