/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CounterDetailViewer;
import VASSAL.build.module.map.HandMetrics;
import VASSAL.build.module.map.StackExpander;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.counters.GamePiece;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.w3c.dom.Element;

public class PlayerHand
extends PrivateMap {
    public void build(Element element) {
        super.build(element);
        if (element == null) {
            for (StackExpander mouseMotionListener : this.getComponentsOf(StackExpander.class)) {
                this.remove(mouseMotionListener);
                this.removeLocalMouseListener(mouseMotionListener);
            }
            for (CounterDetailViewer counterDetailViewer : this.getComponentsOf(CounterDetailViewer.class)) {
                this.remove(counterDetailViewer);
                counterDetailViewer.removeFrom(this);
            }
        }
    }

    public static String getConfigureTypeName() {
        return "Player Hand";
    }

    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("PlayerHand.htm");
    }

    public StackMetrics getStackMetrics() {
        if (this.metrics == null) {
            this.metrics = new HandMetrics();
            this.metrics.build(null);
            this.add(this.metrics);
            this.metrics.addTo(this);
        }
        return this.metrics;
    }

    public Dimension mapSize() {
        Rectangle rectangle = new Rectangle(0, 0, 200, 200);
        rectangle.add(new Rectangle(super.mapSize()));
        for (GamePiece gamePiece : this.pieces.getPieces()) {
            Rectangle rectangle2 = this.boundingBoxOf(gamePiece);
            if (rectangle2 == null) continue;
            rectangle.add(rectangle2);
        }
        return rectangle.getSize();
    }
}

