/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import VASSAL.i18n.ComponentI18nData;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrototypesContainer
extends AbstractConfigurable {
    private static PrototypesContainer instance;
    private Map<String, PrototypeDefinition> definitions = new HashMap<String, PrototypeDefinition>();

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String string) {
        return null;
    }

    @Override
    public void setAttribute(String string, Object object) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable buildable) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{PrototypeDefinition.class};
    }

    public static String getConfigureTypeName() {
        return "Game Piece Prototype Definitions";
    }

    @Override
    public void add(Buildable buildable) {
        super.add(buildable);
        if (buildable instanceof PrototypeDefinition) {
            PrototypeDefinition prototypeDefinition = (PrototypeDefinition)buildable;
            this.definitions.put(prototypeDefinition.getConfigureName(), prototypeDefinition);
            prototypeDefinition.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("name".equals(propertyChangeEvent.getPropertyName())) {
                        PrototypesContainer.this.definitions.remove((String)propertyChangeEvent.getOldValue());
                        PrototypesContainer.this.definitions.put((String)propertyChangeEvent.getNewValue(), (PrototypeDefinition)propertyChangeEvent.getSource());
                    }
                }
            });
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Prototypes.htm");
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    public static PrototypeDefinition getPrototype(String string) {
        if (instance == null) {
            Iterator<PrototypesContainer> iterator = GameModule.getGameModule().getComponentsOf(PrototypesContainer.class).iterator();
            if (iterator.hasNext()) {
                instance = iterator.next();
            } else {
                return null;
            }
        }
        return PrototypesContainer.instance.definitions.get(string);
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setPrefix("");
        return componentI18nData;
    }
}

