/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.ConfigurerWindow;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.LaunchButton;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomTextButton
extends DiceButton {
    protected String[] m_faces;
    protected boolean isNumeric;
    public static final String FACES = "faces";
    public static final String NUMERIC = "numeric";

    public RandomTextButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (RandomTextButton.this.promptAlways) {
                    RandomTextButton.this.promptAlways = false;
                    AutoConfigurer autoConfigurer = (AutoConfigurer)RandomTextButton.this.getConfigurer();
                    ConfigurerWindow configurerWindow = new ConfigurerWindow(autoConfigurer, true);
                    autoConfigurer.getConfigurer("name").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("text").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("tooltip").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("icon").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("hotkey").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("prompt").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("reportFormat").getControls().setVisible(false);
                    autoConfigurer.getConfigurer("reportTotal").getControls().setVisible(false);
                    autoConfigurer.getConfigurer(RandomTextButton.FACES).getControls().setVisible(false);
                    autoConfigurer.getConfigurer(RandomTextButton.NUMERIC).getControls().setVisible(false);
                    configurerWindow.pack();
                    configurerWindow.setVisible(true);
                    autoConfigurer.getConfigurer("name").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("text").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("tooltip").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("icon").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("hotkey").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("prompt").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("reportFormat").getControls().setVisible(true);
                    autoConfigurer.getConfigurer("reportTotal").getControls().setVisible(true);
                    autoConfigurer.getConfigurer(RandomTextButton.FACES).getControls().setVisible(true);
                    autoConfigurer.getConfigurer(RandomTextButton.NUMERIC).getControls().setVisible(true);
                    if (!configurerWindow.isCancelled()) {
                        RandomTextButton.this.DR();
                    }
                    RandomTextButton.this.promptAlways = true;
                } else {
                    RandomTextButton.this.DR();
                }
            }
        };
        this.launch = new LaunchButton(null, "tooltip", "text", "hotkey", "icon", actionListener);
        this.setAttributeTranslatable(FACES, true);
    }

    public static String getConfigureTypeName() {
        return "Random Text Button";
    }

    @Override
    protected void DR() {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.addToTotal;
        for (int i = 0; i < this.nDice; ++i) {
            int n2 = (int)(this.ran.nextFloat() * (float)this.nSides + 1.0f);
            if (this.isNumeric) {
                n2 = Integer.parseInt(this.m_faces[n2 - 1]) + this.plus;
            }
            if (this.reportTotal && this.isNumeric) {
                n += n2;
                continue;
            }
            if (!this.isNumeric) {
                stringBuilder.append(this.m_faces[n2 - 1]);
            } else {
                stringBuilder.append(n2);
            }
            if (i >= this.nDice - 1) continue;
            stringBuilder.append(",");
        }
        if (this.reportTotal && this.isNumeric) {
            stringBuilder.append(n);
        }
        Command command = (string = this.formatResult(stringBuilder.toString())).length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
        command.execute();
        command.append(this.property.setPropertyValue(stringBuilder.toString()));
        GameModule.getGameModule().sendAndLog(command);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if ("reportTotal".equals(string) || "plus".equals(string) || "addToTotal".equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return RandomTextButton.this.isNumeric;
                }
            };
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public String[] getAttributeNames() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        arrayList.remove("nSides");
        arrayList.add(FACES);
        arrayList.add(NUMERIC);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String[] getAttributeDescriptions() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(super.getAttributeDescriptions()));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        arrayList.remove(arrayList2.indexOf("nSides"));
        arrayList.add("Faces");
        arrayList.add("Faces have numeric values?");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        ArrayList arrayList = new ArrayList(Arrays.asList(super.getAttributeTypes()));
        ArrayList<String> arrayList2 = new ArrayList<String>(Arrays.asList(super.getAttributeNames()));
        arrayList.remove(arrayList2.indexOf("nSides"));
        arrayList.add(String[].class);
        arrayList.add(Boolean.class);
        return arrayList.toArray(new Class[arrayList2.size()]);
    }

    @Override
    public void setAttribute(String string, Object stringArray) {
        if (NUMERIC.equals(string)) {
            this.isNumeric = Boolean.TRUE.equals(stringArray) || "true".equals(stringArray);
        } else if (FACES.equals(string)) {
            if (stringArray instanceof String) {
                stringArray = StringArrayConfigurer.stringToArray((String)stringArray);
            }
            this.m_faces = stringArray;
            this.nSides = this.m_faces.length;
        } else {
            super.setAttribute(string, stringArray);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NUMERIC.equals(string)) {
            return String.valueOf(this.isNumeric);
        }
        if (FACES.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.m_faces);
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "RandomTextButton");
    }
}

