/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.SpecialDie;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.logging.Logger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialDiceButton
extends AbstractConfigurable
implements CommandEncoder,
UniqueIdManager.Identifyable {
    protected static UniqueIdManager idMgr = new UniqueIdManager("SpecialDiceButton");
    public static final String SHOW_RESULTS_COMMAND = "SHOW_RESULTS\t";
    protected List<SpecialDie> dice = new ArrayList<SpecialDie>();
    protected Random ran;
    protected boolean reportResultAsText = true;
    protected boolean reportResultInWindow = false;
    protected boolean reportResultInButton = false;
    private LaunchButton launch;
    protected String id;
    protected String sMapName;
    protected JDialog dialog;
    protected JLabel dialogLabel;
    protected Color bgColor;
    protected ResultsIcon resultsIcon = new ResultsIcon();
    protected FormattedString format = new FormattedString();
    protected String chatResultFormat = "** $name$ = [$result1$] *** <$playerName$>";
    protected String windowTitleResultFormat = "$name$";
    protected String tooltip = "";
    protected MutableProperty.Impl property = new MutableProperty.Impl("", this);
    public static final String BUTTON_TEXT = "text";
    public static final String TOOLTIP = "tooltip";
    public static final String NAME = "name";
    public static final String ICON = "icon";
    public static final String RESULT_CHATTER = "resultChatter";
    public static final String CHAT_RESULT_FORMAT = "format";
    public static final String RESULT_N = "result#";
    public static final String RESULT_TOTAL = "numericalTotal";
    public static final String RESULT_WINDOW = "resultWindow";
    public static final String WINDOW_TITLE_RESULT_FORMAT = "windowTitleResultFormat";
    public static final String RESULT_BUTTON = "resultButton";
    public static final String WINDOW_X = "windowX";
    public static final String WINDOW_Y = "windowY";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String DICE_SET = "diceSet";
    public static final String HOTKEY = "hotkey";
    public static final String NONE = "<none>";
    private static final int[] EMPTY = new int[0];

    public SpecialDiceButton() {
        this.dialog = new JDialog(GameModule.getGameModule().getFrame());
        this.dialogLabel = new JLabel();
        this.dialogLabel.setIcon(this.resultsIcon);
        this.dialog.add(this.dialogLabel);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SpecialDiceButton.this.DR();
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, actionListener);
        this.setAttribute(NAME, "Symbols");
        this.setAttribute(BUTTON_TEXT, "Sym");
        this.launch.setAttribute(TOOLTIP, "Symbols");
    }

    public static String getConfigureTypeName() {
        return "Symbolic Dice Button";
    }

    protected String getReportPrefix() {
        return " *** " + this.getConfigureName() + " = ";
    }

    @Deprecated
    protected String getReportSuffix() {
        return " ***  <" + GameModule.getGameModule().getChatter().getHandle() + ">";
    }

    protected void DR() {
        int[] nArray = new int[this.dice.size()];
        int n = 0;
        for (SpecialDie specialDie : this.dice) {
            int n2 = specialDie.getFaceCount();
            nArray[n++] = n2 == 0 ? 0 : this.ran.nextInt(specialDie.getFaceCount());
        }
        this.setFormat(nArray);
        Object object = this.reportResults(nArray);
        if (this.reportResultAsText) {
            object = ((Command)object).append(this.reportTextResults(nArray));
        }
        GameModule.getGameModule().sendAndLog((Command)object);
    }

    private Command reportResults(int[] nArray) {
        this.resultsIcon.setResults(nArray);
        if (this.reportResultInWindow) {
            this.dialog.setVisible(true);
            this.format.setFormat(this.windowTitleResultFormat);
            this.dialog.setTitle(this.format.getLocalizedText());
            this.dialogLabel.repaint();
        }
        if (this.reportResultInButton) {
            this.launch.repaint();
        }
        return new ShowResults(this, nArray);
    }

    private Command reportTextResults(int[] nArray) {
        Object object;
        int n = 0;
        for (int i = 0; i < this.dice.size(); ++i) {
            object = this.dice.get(i);
            n += ((SpecialDie)object).getIntValue(nArray[i]);
        }
        this.format.setFormat(this.chatResultFormat);
        String string = this.format.getLocalizedText();
        if (string.length() > 0) {
            string = string.startsWith("*") ? "*" + string : "* " + string;
        }
        object = string.length() == 0 ? new NullCommand() : new Chatter.DisplayText(GameModule.getGameModule().getChatter(), string);
        ((Command)object).execute();
        ((Command)object).append(this.property.setPropertyValue(String.valueOf(n)));
        return object;
    }

    protected void setFormat(int[] nArray) {
        this.format.setProperty(NAME, this.getLocalizedConfigureName());
        int n = 0;
        for (int i = 0; i < this.dice.size(); ++i) {
            SpecialDie specialDie = this.dice.get(i);
            this.format.setProperty("result" + (i + 1), specialDie.getTextValue(nArray[i]));
            n += specialDie.getIntValue(nArray[i]);
        }
        this.format.setProperty(RESULT_TOTAL, String.valueOf(n));
        this.format.setFormat(this.chatResultFormat);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BUTTON_TEXT, TOOLTIP, ICON, HOTKEY, RESULT_CHATTER, CHAT_RESULT_FORMAT, RESULT_WINDOW, WINDOW_TITLE_RESULT_FORMAT, RESULT_BUTTON, WINDOW_X, WINDOW_Y, BACKGROUND_COLOR};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Button text:  ", "Tooltip text:  ", "Button icon:  ", "Hotkey:  ", "Report results as text?", "Report format:  ", "Show result in window?", "Window title format:  ", "Show result in button?", "Width:  ", "Height:  ", "Background color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class, IconConfig.class, KeyStroke.class, Boolean.class, ReportFormatConfig.class, Boolean.class, ReportFormatConfig.class, Boolean.class, Integer.class, Integer.class, Color.class};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (WINDOW_X.equals(string) || WINDOW_Y.equals(string) || BACKGROUND_COLOR.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SpecialDiceButton.this.reportResultInWindow || SpecialDiceButton.this.reportResultInButton;
                }
            };
        }
        if (CHAT_RESULT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SpecialDiceButton.this.reportResultAsText;
                }
            };
        }
        if (WINDOW_TITLE_RESULT_FORMAT.equals(string)) {
            return new VisibilityCondition(){

                public boolean shouldBeVisible() {
                    return SpecialDiceButton.this.reportResultInWindow;
                }
            };
        }
        return null;
    }

    public void addSpecialDie(SpecialDie specialDie) {
        this.dice.add(specialDie);
    }

    public void removeSpecialDie(SpecialDie specialDie) {
        this.dice.remove(specialDie);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.resultsIcon.setResults(new int[this.dice.size()]);
        this.launch.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (SpecialDiceButton.this.launch.isShowing()) {
                    SpecialDiceButton.this.dialog.setLocationRelativeTo(SpecialDiceButton.this.launch);
                    SpecialDiceButton.this.launch.removeHierarchyListener(this);
                }
            }
        });
        GameModule gameModule = GameModule.getGameModule();
        this.ran = gameModule.getRNG();
        gameModule.getToolBar().add(this.launch);
        idMgr.add(this);
        gameModule.addCommandEncoder(this);
        this.property.addTo((MutablePropertiesContainer)((Object)buildable));
    }

    @Override
    public void removeFrom(Buildable buildable) {
        GameModule gameModule = GameModule.getGameModule();
        gameModule.removeCommandEncoder(this);
        gameModule.getToolBar().remove(this.launch);
        gameModule.getToolBar().revalidate();
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getIdentifier() {
        return UniqueIdManager.getIdentifier(this);
    }

    private boolean getBoolVal(Object object) {
        if (object instanceof Boolean) {
            boolean bl = (Boolean)object;
            return bl;
        }
        if (object instanceof String) {
            return "true".equals(object);
        }
        return false;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (NAME.equals(string)) {
            this.setConfigureName((String)object);
            this.property.setPropertyName(this.getConfigureName() + "_result");
            this.launch.setToolTipText((String)object);
        } else if (RESULT_CHATTER.equals(string)) {
            this.reportResultAsText = this.getBoolVal(object);
        } else if (CHAT_RESULT_FORMAT.equals(string)) {
            this.chatResultFormat = (String)object;
        } else if (RESULT_BUTTON.equals(string)) {
            this.reportResultInButton = this.getBoolVal(object);
            if (this.reportResultInButton) {
                this.launch.setIcon(this.resultsIcon);
            }
        } else if (RESULT_WINDOW.equals(string)) {
            this.reportResultInWindow = this.getBoolVal(object);
        } else if (WINDOW_TITLE_RESULT_FORMAT.equals(string)) {
            this.windowTitleResultFormat = (String)object;
        } else if (WINDOW_X.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.resultsIcon.width = (Integer)object;
            this.dialog.pack();
        } else if (WINDOW_Y.equals(string)) {
            if (object instanceof String) {
                object = Integer.valueOf((String)object);
            }
            this.resultsIcon.height = (Integer)object;
            this.dialog.pack();
        } else if (BACKGROUND_COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.bgColor = (Color)object;
        } else if (TOOLTIP.equals(string)) {
            this.tooltip = (String)object;
            this.launch.setAttribute(string, object);
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (RESULT_CHATTER.equals(string)) {
            return String.valueOf(this.reportResultAsText);
        }
        if (CHAT_RESULT_FORMAT.equals(string)) {
            return this.chatResultFormat;
        }
        if (RESULT_BUTTON.equals(string)) {
            return String.valueOf(this.reportResultInButton);
        }
        if (RESULT_WINDOW.equals(string)) {
            return String.valueOf(this.reportResultInWindow);
        }
        if (WINDOW_TITLE_RESULT_FORMAT.equals(string)) {
            return this.windowTitleResultFormat;
        }
        if (WINDOW_X.equals(string)) {
            return String.valueOf(this.resultsIcon.width);
        }
        if (WINDOW_Y.equals(string)) {
            return String.valueOf(this.resultsIcon.height);
        }
        if (BACKGROUND_COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.bgColor);
        }
        if (TOOLTIP.equals(this.name)) {
            return this.tooltip.length() == 0 ? this.launch.getAttributeValueString(this.name) : this.tooltip;
        }
        return this.launch.getAttributeValueString(string);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{SpecialDie.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SpecialDiceButton.htm");
    }

    public static String intArrayToString(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return "";
        }
        SequenceEncoder sequenceEncoder = new SequenceEncoder(',');
        for (int i = 0; i < nArray.length; ++i) {
            sequenceEncoder.append(String.valueOf(nArray[i]));
        }
        return sequenceEncoder.getValue();
    }

    public static int[] stringToIntArray(String string) {
        if (string == null || string.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ',');
        ArrayList<String> arrayList = new ArrayList<String>();
        while (decoder.hasMoreTokens()) {
            arrayList.add(decoder.nextToken());
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt((String)arrayList.get(i));
        }
        return nArray;
    }

    @Override
    public String encode(Command command) {
        if (command instanceof ShowResults) {
            ShowResults showResults = (ShowResults)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder(showResults.target.getIdentifier(), '\t');
            for (int i = 0; i < showResults.rolls.length; ++i) {
                sequenceEncoder.append(showResults.rolls[i] + "");
            }
            return SHOW_RESULTS_COMMAND + sequenceEncoder.getValue();
        }
        return null;
    }

    @Override
    public Command decode(String string) {
        SequenceEncoder.Decoder decoder = null;
        if (string.startsWith(SHOW_RESULTS_COMMAND + this.getConfigureName()) || string.startsWith(SHOW_RESULTS_COMMAND + this.getId())) {
            decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
            decoder.nextToken();
        } else if (string.startsWith(this.getId() + '\t')) {
            decoder = new SequenceEncoder.Decoder(string, '\t');
            decoder.nextToken();
        }
        if (decoder != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            while (decoder.hasMoreTokens()) {
                arrayList.add(decoder.nextToken());
            }
            int[] nArray = new int[arrayList.size()];
            int n = 0;
            for (String string2 : arrayList) {
                nArray[n++] = Integer.parseInt(string2);
            }
            return new ShowResults(this, nArray);
        }
        return null;
    }

    private class ResultsIcon
    implements Icon {
        private int width;
        private int height;
        private Icon[] icons;

        private void setResults(int[] nArray) {
            this.icons = new Icon[nArray.length];
            if (nArray.length > SpecialDiceButton.this.dice.size()) {
                Logger.log("Special Die Button (" + SpecialDiceButton.this.getConfigureName() + "): more results (" + nArray.length + ") requested than dice (" + SpecialDiceButton.this.dice.size() + ")");
            }
            for (int i = 0; i < nArray.length && i < SpecialDiceButton.this.dice.size(); ++i) {
                BufferedImage bufferedImage;
                String string = SpecialDiceButton.this.dice.get(i).getImageName(nArray[i]);
                if (string.length() <= 0 || (bufferedImage = Op.load(string).getImage()) == null) continue;
                this.icons[i] = new ImageIcon(bufferedImage);
            }
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (SpecialDiceButton.this.bgColor != null) {
                graphics.setColor(SpecialDiceButton.this.bgColor);
                graphics.fillRect(n, n2, this.width, this.height);
            }
            int n3 = 0;
            for (int i = 0; i < this.icons.length; ++i) {
                if (this.icons[i] == null) continue;
                this.icons[i].paintIcon(component, graphics, n + n3, n2);
                n3 += this.icons[i].getIconWidth();
            }
        }

        public int getIconWidth() {
            return this.width;
        }

        public int getIconHeight() {
            return this.height;
        }
    }

    public static class ShowResults
    extends Command {
        private SpecialDiceButton target;
        private int[] rolls;

        public ShowResults(SpecialDiceButton specialDiceButton, int[] nArray) {
            this.target = specialDiceButton;
            this.rolls = new int[nArray.length];
            System.arraycopy(nArray, 0, this.rolls, 0, nArray.length);
        }

        protected void executeCommand() {
            this.target.setFormat(this.rolls);
            this.target.reportResults(this.rolls);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{SpecialDiceButton.NAME, SpecialDiceButton.RESULT_N, SpecialDiceButton.RESULT_TOTAL});
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, "/images/die.gif");
        }
    }
}

