/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.SpecialDie;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpecialDieFace
extends AbstractConfigurable {
    public static final String TEXT = "text";
    public static final String NUMERICAL_VALUE = "value";
    public static final String ICON = "icon";
    public static final String IMAGE = "image";
    private int value;
    private String imageName;

    public static String getConfigureTypeName() {
        return "Symbolic Die Face";
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Text Value:  ", "Numerical value:  ", "Icon:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, Integer.class, IconConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        String[] stringArray = new String[]{TEXT, NUMERICAL_VALUE, ICON};
        return stringArray;
    }

    public String getTextValue() {
        return this.getConfigureName();
    }

    public int getIntValue() {
        return this.value;
    }

    public String getImageName() {
        return this.imageName;
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (TEXT.equals(string)) {
            this.setConfigureName((String)object);
        } else if (NUMERICAL_VALUE.equals(string)) {
            try {
                if (object instanceof String) {
                    object = Integer.valueOf((String)object);
                }
                this.value = (Integer)object;
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalBuildException(numberFormatException);
            }
        } else if (ICON.equals(string)) {
            this.imageName = (String)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (TEXT.equals(string)) {
            return this.getConfigureName();
        }
        if (NUMERICAL_VALUE.equals(string)) {
            return String.valueOf(this.value);
        }
        if (ICON.equals(string)) {
            return this.imageName;
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "SpecialDiceButton");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable buildable) {
        ((SpecialDie)buildable).addFace(this);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        ((SpecialDie)buildable).removeFace(this);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, null);
        }
    }
}

