/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.dice;

import VASSAL.build.module.DieRoll;
import VASSAL.build.module.dice.DieServer;
import VASSAL.build.module.dice.RollSet;
import VASSAL.tools.FormattedString;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class ShadowDiceDieServer
extends DieServer {
    public static final String ROLL_MARKER = "VASSAL auto-generated dice roll";

    public ShadowDiceDieServer() {
        this.name = "ShadowDice";
        this.description = "ShadowDice Dice Server";
        this.emailOnly = false;
        this.maxRolls = 0;
        this.maxEmails = 0;
        this.serverURL = "http://www.gamerz.net/shadowdice/shadowdice.cgi";
        this.passwdRequired = false;
        this.canDoSeparateDice = true;
    }

    public String[] buildInternetRollString(RollSet rollSet) {
        String string = "";
        String string2 = "";
        if (this.getUseEmail()) {
            string = this.extractEmail(this.getPrimaryEmail());
            string2 = this.extractEmail(this.getSecondaryEmail());
        }
        String string3 = this.hexify(rollSet.description);
        String string4 = "mto=" + string + "&mcc=" + string2 + "&yem=" + string;
        string4 = string4 + "&sbj=" + string3;
        string4 = string4 + "&msg=VASSAL auto-generated dice roll%0D%0A" + string3 + "%0D%0A";
        int n = rollSet.getMaxDescLength();
        DieRoll[] dieRollArray = rollSet.getDieRolls();
        for (int i = 0; i < dieRollArray.length; ++i) {
            int n2;
            string4 = string4 + this.hexify(dieRollArray[i].getDescription());
            for (n2 = 0; n2 < n - dieRollArray[i].getDescription().length(); ++n2) {
                string4 = string4 + ' ';
            }
            string4 = string4 + " %23";
            n2 = dieRollArray[i].getNumDice();
            int n3 = dieRollArray[i].getNumSides();
            for (int j = 0; j < n2; ++j) {
                string4 = string4 + "%5B1d" + n3 + "%5D";
            }
            string4 = string4 + "%0D%0A";
        }
        string4 = string4 + "&todo=Action%21&hid=1";
        string4 = string4.replace(' ', '+');
        return new String[]{string4};
    }

    public String hexify(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '#') {
                stringBuilder.append('.');
                continue;
            }
            if ("~!$%^&()+`={}[]|:;'<>,?/\\\"".indexOf(c) >= 0) {
                stringBuilder.append("%" + Integer.toHexString(c).toUpperCase());
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public void parseInternetRollString(RollSet rollSet, Vector vector) {
        Enumeration enumeration = vector.elements();
        String string = (String)enumeration.nextElement();
        while (enumeration.hasMoreElements() && !string.startsWith("! VASSAL auto-generated dice roll")) {
            string = (String)enumeration.nextElement();
        }
        string = (String)enumeration.nextElement();
        DieRoll[] dieRollArray = rollSet.getDieRolls();
        for (int i = 0; i < dieRollArray.length; ++i) {
            string = (String)enumeration.nextElement();
            int n = string.indexOf("#") - 1;
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n), " ");
            for (int j = 0; j < rollSet.dieRolls[i].getNumDice(); ++j) {
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                int n2 = Integer.parseInt(string2);
                rollSet.dieRolls[i].setResult(j, n2);
            }
        }
    }

    public void roll(RollSet rollSet, FormattedString formattedString) {
        super.doInternetRoll(rollSet, formattedString);
    }
}

