/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.tools.SequenceEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeItemInstance
extends ItemInstance {
    public static final String BORDER_COLOR = "borderColor";
    private ColorSwatch borderColor = ColorSwatch.getBlack();

    public ShapeItemInstance() {
        this.setFgColor(ColorSwatch.getClear());
    }

    public ShapeItemInstance(String string, GamePieceImage gamePieceImage) {
        super(gamePieceImage);
        this.decode(string);
    }

    public ShapeItemInstance(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setFgColor(ColorSwatch.getClear());
    }

    @Override
    public String encode() {
        SequenceEncoder sequenceEncoder = new SequenceEncoder(';');
        sequenceEncoder.append(this.getType());
        sequenceEncoder.append(this.getName());
        sequenceEncoder.append(this.getLocation());
        sequenceEncoder.append(this.getFgColor().encode());
        sequenceEncoder.append(this.getBorderColor().encode());
        return sequenceEncoder.getValue();
    }

    public void decode(String string) {
        SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string, ';');
        this.setType(decoder.nextToken(""));
        this.setName(decoder.nextToken(""));
        this.setLocation(decoder.nextToken(""));
        this.setFgColor(new ColorSwatch(decoder.nextToken("")));
        this.setBorderColor(new ColorSwatch(decoder.nextToken("")));
    }

    protected void setBorderColor(ColorSwatch colorSwatch) {
        this.borderColor = colorSwatch;
    }

    protected ColorSwatch getBorderColor() {
        return this.borderColor;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Foreground Color:  ", "Border Color:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{FgColorSwatchConfig.class, BorderColorSwatchConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"fgColor", BORDER_COLOR};
    }

    @Override
    public void setAttribute(String string, Object object) {
        if ("fgColor".equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.fgColor = (ColorSwatch)object;
        } else if (BORDER_COLOR.equals(string)) {
            if (object instanceof String) {
                object = new ColorSwatch((String)object);
            }
            this.setBorderColor((ColorSwatch)object);
        }
        if (this.myConfig != null) {
            this.myConfig.rebuildViz();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if ("fgColor".equals(string)) {
            return this.fgColor.encode();
        }
        if (BORDER_COLOR.equals(string)) {
            return this.getBorderColor().encode();
        }
        return null;
    }

    public static class FgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((ItemInstance)autoConfigurable).getFgColor());
        }
    }

    public static class BorderColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((ItemInstance)autoConfigurable).getBgColor());
        }
    }
}

