/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.SetupStack;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.widget.CardSlot;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.GamePieceFormattedStringConfigurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.Deck;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.UniqueIdManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawPile
extends SetupStack {
    protected Deck dummy = new Deck();
    protected boolean reshufflable;
    protected Deck myDeck;
    private VisibilityCondition colorVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isDrawOutline();
        }
    };
    private VisibilityCondition reshuffleVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.reshufflable;
        }
    };
    private VisibilityCondition faceDownFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.getFaceDownOption().equals(DrawPile.USE_MENU);
        }
    };
    private VisibilityCondition reverseFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isReversible();
        }
    };
    private VisibilityCondition shuffleFormatVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.getShuffleOption().equals(DrawPile.USE_MENU);
        }
    };
    private VisibilityCondition expressionCountingVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.doesExpressionCounting();
        }
    };
    private VisibilityCondition hotkeyOnEmptyVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isHotkeyOnEmpty();
        }
    };
    private VisibilityCondition selectionAllowedVisibleCondition = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            return DrawPile.this.dummy.isAllowSelectDraw();
        }
    };
    protected static UniqueIdManager idMgr = new UniqueIdManager("Deck");
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String ALLOW_MULTIPLE = "allowMultiple";
    public static final String ALLOW_SELECT = "allowSelect";
    public static final String SELECT_DISPLAY_PROPERTY = "selectDisplayProperty";
    public static final String SELECT_SORT_PROPERTY = "selectSortProperty";
    public static final String FACE_DOWN = "faceDown";
    public static final String DRAW_FACE_UP = "drawFaceUp";
    public static final String FACE_DOWN_REPORT_FORMAT = "faceDownFormat";
    public static final String SHUFFLE = "shuffle";
    public static final String SHUFFLE_REPORT_FORMAT = "shuffleFormat";
    public static final String SHUFFLE_HOTKEY = "shuffleHotkey";
    public static final String REVERSIBLE = "reversible";
    public static final String REVERSE_REPORT_FORMAT = "reverseFormat";
    public static final String DRAW = "draw";
    public static final String COLOR = "color";
    public static final String MAXSTACK = "maxStack";
    public static final String EXPRESSIONCOUNTING = "expressionCounting";
    public static final String COUNTEXPRESSIONS = "countExpressions";
    public static final String RESHUFFLABLE = "reshufflable";
    public static final String RESHUFFLE_COMMAND = "reshuffleCommand";
    public static final String RESHUFFLE_TARGET = "reshuffleTarget";
    public static final String RESHUFFLE_MESSAGE = "reshuffleMessage";
    public static final String RESHUFFLE_HOTKEY = "reshuffleHotkey";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String CAN_SAVE = "canSave";
    public static final String HOTKEY_ON_EMPTY = "hotkeyOnEmpty";
    public static final String EMPTY_HOTKEY = "emptyHotkey";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String COMMAND_NAME = "commandName";
    public static final String DECK_NAME = "deckName";

    @Override
    public void addTo(Buildable buildable) {
        super.addTo(buildable);
        idMgr.add(this);
        this.setAttributeTranslatable("name", true);
    }

    protected JPopupMenu buildPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        return jPopupMenu.getComponentCount() > 0 ? jPopupMenu : null;
    }

    public void addGlobalKeyCommand(DeckGlobalKeyCommand deckGlobalKeyCommand) {
        this.dummy.addGlobalKeyCommand(deckGlobalKeyCommand);
    }

    public void removeGlobalKeyCommand(DeckGlobalKeyCommand deckGlobalKeyCommand) {
        this.dummy.removeGlobalKeyCommand(deckGlobalKeyCommand);
    }

    public static DrawPile findDrawPile(String string) {
        return (DrawPile)idMgr.findInstance(string);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", "owningBoard", "x", "y", WIDTH, HEIGHT, ALLOW_MULTIPLE, ALLOW_SELECT, SELECT_DISPLAY_PROPERTY, SELECT_SORT_PROPERTY, FACE_DOWN, DRAW_FACE_UP, FACE_DOWN_REPORT_FORMAT, SHUFFLE, SHUFFLE_REPORT_FORMAT, SHUFFLE_HOTKEY, REVERSIBLE, REVERSE_REPORT_FORMAT, DRAW, COLOR, HOTKEY_ON_EMPTY, EMPTY_HOTKEY, RESHUFFLABLE, RESHUFFLE_COMMAND, RESHUFFLE_MESSAGE, RESHUFFLE_HOTKEY, RESHUFFLE_TARGET, CAN_SAVE, MAXSTACK, EXPRESSIONCOUNTING, COUNTEXPRESSIONS};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Belongs to board:  ", "X position:  ", "Y position:  ", "Width:  ", "Height:  ", "Allow Multiple Cards to be Drawn?", "Allow Specific Cards to be Drawn?", "When selecting, list cards using", "When selecting, sort cards by", "Contents are Face-down:  ", "Draw new cards face up?", "Face-down Report Format:  ", "Re-shuffle:  ", "Re-shuffle Report Format:  ", "Re-shuffle Hot Key:  ", "Reversible?", "Reverse Report Format:  ", "Draw Outline when empty?", "Color:  ", "Send Hotkey when empty?", "Hot Key to send when Deck empties:  ", "Include command to send entire deck to another deck?", "Send Menu text:  ", "Send Report Format:  ", "Send Hot Key:  ", "Name of deck to send to:  ", "Can be saved-to/loaded-from a file?", "Maximum Cards to display in Stack:", "Perform counting of property expressions?", "Expressions to count:"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, SetupStack.OwningBoardPrompt.class, Integer.class, Integer.class, Integer.class, Integer.class, Boolean.class, Boolean.class, PiecePropertyConfig.class, String.class, Prompt.class, Boolean.class, FormattedStringConfig.class, Prompt.class, FormattedStringConfig.class, KeyStroke.class, Boolean.class, FormattedStringConfig.class, Boolean.class, Color.class, Boolean.class, KeyStroke.class, Boolean.class, String.class, FormattedStringConfig.class, KeyStroke.class, AssignedDeckPrompt.class, Boolean.class, Integer.class, Boolean.class, String[].class};
    }

    @Override
    public String getAttributeValueString(String string) {
        if (WIDTH.equals(string)) {
            return String.valueOf(this.dummy.getSize().width);
        }
        if (HEIGHT.equals(string)) {
            return String.valueOf(this.dummy.getSize().height);
        }
        if (FACE_DOWN.equals(string)) {
            return this.dummy.getFaceDownOption();
        }
        if (DRAW_FACE_UP.equals(string)) {
            return String.valueOf(this.dummy.isDrawFaceUp());
        }
        if (SHUFFLE.equals(string)) {
            return this.dummy.getShuffleOption();
        }
        if (REVERSIBLE.equals(string)) {
            return String.valueOf(this.dummy.isReversible());
        }
        if (ALLOW_MULTIPLE.equals(string)) {
            return String.valueOf(this.dummy.isAllowMultipleDraw());
        }
        if (ALLOW_SELECT.equals(string)) {
            return String.valueOf(this.dummy.isAllowSelectDraw());
        }
        if (SELECT_DISPLAY_PROPERTY.equals(string)) {
            return this.dummy.getSelectDisplayProperty();
        }
        if (SELECT_SORT_PROPERTY.equals(string)) {
            return this.dummy.getSelectSortProperty();
        }
        if (DRAW.equals(string)) {
            return String.valueOf(this.dummy.isDrawOutline());
        }
        if (COLOR.equals(string)) {
            return ColorConfigurer.colorToString(this.dummy.getOutlineColor());
        }
        if (MAXSTACK.equals(string)) {
            return String.valueOf(this.dummy.getMaxStack());
        }
        if (EXPRESSIONCOUNTING.equals(string)) {
            return String.valueOf(this.dummy.doesExpressionCounting());
        }
        if (COUNTEXPRESSIONS.equals(string)) {
            return StringArrayConfigurer.arrayToString(this.dummy.getCountExpressions());
        }
        if (RESHUFFLABLE.equals(string)) {
            return String.valueOf(this.dummy.getReshuffleCommand().length() > 0);
        }
        if (RESHUFFLE_COMMAND.equals(string)) {
            return this.dummy.getReshuffleCommand();
        }
        if (RESHUFFLE_TARGET.equals(string)) {
            return this.dummy.getReshuffleTarget();
        }
        if (RESHUFFLE_MESSAGE.equals(string)) {
            return this.dummy.getReshuffleMsgFormat();
        }
        if (RESHUFFLE_HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.dummy.getReshuffleKey());
        }
        if (SHUFFLE_REPORT_FORMAT.equals(string)) {
            return this.dummy.getShuffleMsgFormat();
        }
        if (SHUFFLE_HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.dummy.getShuffleKey());
        }
        if (REVERSE_REPORT_FORMAT.equals(string)) {
            return this.dummy.getReverseMsgFormat();
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            return this.dummy.getFaceDownMsgFormat();
        }
        if (CAN_SAVE.equals(string)) {
            return String.valueOf(this.dummy.isPersistable());
        }
        if (HOTKEY_ON_EMPTY.equals(string)) {
            return String.valueOf(this.dummy.isHotkeyOnEmpty());
        }
        if (EMPTY_HOTKEY.equals(string)) {
            return HotKeyConfigurer.encode(this.dummy.getEmptyKey());
        }
        return super.getAttributeValueString(string);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (object == null) {
            return;
        }
        if (WIDTH.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.dummy.getSize().width = (Integer)object;
        } else if (HEIGHT.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.dummy.getSize().height = (Integer)object;
        } else if (FACE_DOWN.equals(string)) {
            this.dummy.setFaceDownOption((String)object);
        } else if (DRAW_FACE_UP.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setDrawFaceUp(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setDrawFaceUp("true".equals(object));
            }
        } else if (CAN_SAVE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setPersistable(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setPersistable("true".equals(object));
            }
        } else if (SHUFFLE.equals(string)) {
            this.dummy.setShuffleOption((String)object);
        } else if (REVERSIBLE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setReversible(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setReversible("true".equals(object));
            }
        } else if (ALLOW_MULTIPLE.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setAllowMultipleDraw(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setAllowMultipleDraw("true".equals(object));
            }
        } else if (ALLOW_SELECT.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setAllowSelectDraw(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setAllowSelectDraw("true".equals(object));
            }
        } else if (SELECT_DISPLAY_PROPERTY.equals(string)) {
            this.dummy.setSelectDisplayProperty((String)object);
        } else if (SELECT_SORT_PROPERTY.equals(string)) {
            this.dummy.setSelectSortProperty((String)object);
        } else if (DRAW.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setDrawOutline(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setDrawOutline("true".equals(object));
            }
        } else if (COLOR.equals(string)) {
            if (object instanceof String) {
                object = ColorConfigurer.stringToColor((String)object);
            }
            this.dummy.setOutlineColor((Color)object);
        }
        if (MAXSTACK.equals(string)) {
            if (object instanceof String) {
                object = new Integer((String)object);
            }
            this.dummy.setMaxStack((Integer)object);
        }
        if (EXPRESSIONCOUNTING.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setExpressionCounting(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setExpressionCounting("true".equals(object));
            }
        }
        if (COUNTEXPRESSIONS.equals(string)) {
            if (object instanceof String) {
                object = StringArrayConfigurer.stringToArray((String)object);
            }
            this.dummy.setCountExpressions((String[])object);
        } else if (RESHUFFLABLE.equals(string)) {
            boolean bl = this.reshufflable = "true".equals(object) || Boolean.TRUE.equals(object);
            if (!this.reshufflable) {
                this.dummy.setReshuffleCommand("");
            }
        } else if (RESHUFFLE_COMMAND.equals(string)) {
            this.dummy.setReshuffleCommand((String)object);
        } else if (RESHUFFLE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.dummy.setReshuffleKey((KeyStroke)object);
        } else if (RESHUFFLE_TARGET.equals(string)) {
            this.dummy.setReshuffleTarget((String)object);
        } else if (RESHUFFLE_MESSAGE.equals(string)) {
            this.dummy.setReshuffleMsgFormat((String)object);
        } else if (REVERSE_REPORT_FORMAT.equals(string)) {
            this.dummy.setReverseMsgFormat((String)object);
        } else if (SHUFFLE_REPORT_FORMAT.equals(string)) {
            this.dummy.setShuffleMsgFormat((String)object);
        } else if (SHUFFLE_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.dummy.setShuffleKey((KeyStroke)object);
        } else if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            this.dummy.setFaceDownMsgFormat((String)object);
        } else if ("name".equals(string)) {
            this.dummy.setDeckName((String)object);
            super.setAttribute(string, object);
        } else if (HOTKEY_ON_EMPTY.equals(string)) {
            if (object instanceof Boolean) {
                this.dummy.setHotkeyOnEmpty(Boolean.TRUE.equals(object));
            } else {
                this.dummy.setHotkeyOnEmpty("true".equals(object));
            }
        } else if (EMPTY_HOTKEY.equals(string)) {
            if (object instanceof String) {
                object = HotKeyConfigurer.decode((String)object);
            }
            this.dummy.setEmptyKey((KeyStroke)object);
        } else {
            super.setAttribute(string, object);
        }
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (COLOR.equals(string)) {
            return this.colorVisibleCondition;
        }
        if (RESHUFFLE_COMMAND.equals(string) || RESHUFFLE_MESSAGE.equals(string) || RESHUFFLE_TARGET.equals(string) || RESHUFFLE_HOTKEY.equals(string)) {
            return this.reshuffleVisibleCondition;
        }
        if (FACE_DOWN_REPORT_FORMAT.equals(string)) {
            return this.faceDownFormatVisibleCondition;
        }
        if (SHUFFLE_REPORT_FORMAT.equals(string) || SHUFFLE_HOTKEY.equals(string)) {
            return this.shuffleFormatVisibleCondition;
        }
        if (REVERSE_REPORT_FORMAT.equals(string)) {
            return this.reverseFormatVisibleCondition;
        }
        if (COUNTEXPRESSIONS.equals(string)) {
            return this.expressionCountingVisibleCondition;
        }
        if (EMPTY_HOTKEY.equals(string)) {
            return this.hotkeyOnEmptyVisibleCondition;
        }
        if (SELECT_DISPLAY_PROPERTY.equals(string) || SELECT_SORT_PROPERTY.equals(string)) {
            return this.selectionAllowedVisibleCondition;
        }
        return null;
    }

    @Override
    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{CardSlot.class, DeckGlobalKeyCommand.class};
    }

    public Point getPosition() {
        Point point = new Point(this.pos);
        Board board = this.map.getBoardByName(this.owningBoardName);
        if (board != null) {
            point.translate(board.bounds().x, board.bounds().y);
        }
        return point;
    }

    public Map getMap() {
        return this.map;
    }

    public Rectangle boundingBox() {
        return this.myDeck == null ? null : this.myDeck.boundingBox();
    }

    public Command addToContents(GamePiece gamePiece) {
        if (this.myDeck != null && this.myDeck.indexOf(gamePiece) >= 0) {
            return new NullCommand();
        }
        return this.map.placeOrMerge(gamePiece, this.myDeck == null ? this.getPosition() : this.myDeck.getPosition());
    }

    @Override
    protected Stack initializeContents() {
        Stack stack = super.initializeContents();
        this.myDeck = new Deck(this.getDeckType());
        Iterator<GamePiece> iterator = stack.getPiecesIterator();
        while (iterator.hasNext()) {
            this.myDeck.add(iterator.next());
        }
        this.myDeck.setFaceDown(!NEVER.equals(this.dummy.getFaceDownOption()));
        return this.myDeck;
    }

    public void setDeck(Deck deck) {
        this.myDeck = deck;
    }

    @Override
    protected boolean placeNonStackingSeparately() {
        return false;
    }

    protected String getDeckType() {
        return this.dummy.getType();
    }

    public Dimension getSize() {
        return this.dummy.getSize();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Deck.htm");
    }

    public static String getConfigureTypeName() {
        return "Deck";
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setAttributeTranslatable(SELECT_DISPLAY_PROPERTY, false);
        componentI18nData.setAttributeTranslatable(SELECT_SORT_PROPERTY, false);
        return componentI18nData;
    }

    public static class PiecePropertyConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new GamePieceFormattedStringConfigurer(string, string2);
        }
    }

    public static class FormattedStringConfig
    implements TranslatableConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new PlayerIdFormattedStringConfigurer(string, string2, new String[]{DrawPile.DECK_NAME, DrawPile.COMMAND_NAME});
        }
    }

    public static class AssignedDeckPrompt
    extends StringEnum {
        public static final String NONE = "<none>";

        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(NONE);
            for (GameComponent gameComponent : GameModule.getGameModule().getGameState().getGameComponents()) {
                if (!(gameComponent instanceof Map)) continue;
                for (DrawPile drawPile : ((Map)gameComponent).getComponentsOf(DrawPile.class)) {
                    if (drawPile.getConfigureName() == null) continue;
                    arrayList.add(drawPile.getConfigureName());
                }
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
    }

    public static class Prompt
    extends StringEnum {
        public String[] getValidValues(AutoConfigurable autoConfigurable) {
            return new String[]{DrawPile.ALWAYS, DrawPile.NEVER, DrawPile.USE_MENU};
        }
    }
}

