/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Translatable;
import VASSAL.tools.LaunchButton;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HidePiecesButton
extends JPanel
implements MouseListener,
AutoConfigurable,
GameComponent,
Drawable {
    private static final long serialVersionUID = 1L;
    protected boolean piecesVisible = false;
    protected Map map;
    protected LaunchButton launch;
    protected String showingIcon;
    protected String hiddenIcon;
    protected ComponentI18nData myI18nData;
    public static final String DEFAULT_SHOWING_ICON = "/images/globe_unselected.gif";
    public static final String DEFAULT_HIDDEN_ICON = "/images/globe_selected.gif";
    public static final String HOTKEY = "hotkey";
    public static final String HIDDEN_ICON = "hiddenIcon";
    public static final String SHOWING_ICON = "showingIcon";
    public static final String LAUNCH_ICON = "icon";
    public static final String TOOLTIP = "tooltip";
    public static final String BUTTON_TEXT = "buttonText";

    public HidePiecesButton() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                HidePiecesButton.this.setPiecesVisible(!HidePiecesButton.this.piecesVisible);
            }
        };
        this.launch = new LaunchButton(null, TOOLTIP, BUTTON_TEXT, HOTKEY, LAUNCH_ICON, actionListener);
        this.launch.setAttribute(TOOLTIP, "Hide all pieces on this map");
        this.addMouseListener(this);
    }

    @Override
    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.launch);
        if (buildable instanceof Translatable) {
            this.getI18nData().setOwningComponent((Translatable)buildable);
        }
    }

    protected void setPiecesVisible(boolean bl) {
        this.map.setPiecesVisible(bl);
        this.launch.setAttribute(LAUNCH_ICON, bl ? this.showingIcon : this.hiddenIcon);
        this.piecesVisible = bl;
        this.map.repaint();
    }

    @Override
    public void add(Buildable buildable) {
    }

    @Override
    public void remove(Buildable buildable) {
    }

    @Override
    public void removeFrom(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.launch);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    @Override
    public void setAttribute(String string, Object object) {
        if (SHOWING_ICON.equals(string)) {
            this.showingIcon = (String)object;
        } else if (HIDDEN_ICON.equals(string)) {
            this.hiddenIcon = (String)object;
        } else {
            this.launch.setAttribute(string, object);
        }
    }

    @Override
    public void build(Element element) {
        AutoConfigurable.Util.buildAttributes(element, this);
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, HOTKEY, SHOWING_ICON, HIDDEN_ICON};
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        return null;
    }

    @Override
    public String getAttributeValueString(String string) {
        String string2 = null;
        string2 = HIDDEN_ICON.equals(string) ? this.hiddenIcon : (SHOWING_ICON.equals(string) ? this.showingIcon : this.launch.getAttributeValueString(string));
        return string2;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Button Text:  ", "Tooltip text:  ", "Hotkey:  ", "Icon when pieces are showing:  ", "Icon when pieces are hidden:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, KeyStroke.class, ShowingIconConfig.class, HiddenIconConfig.class};
    }

    @Override
    public void draw(Graphics graphics, Map map) {
        this.repaint();
    }

    @Override
    public boolean drawAboveCounters() {
        return false;
    }

    @Override
    public void paint(Graphics graphics) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        return null;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public void setup(boolean bl) {
        if (bl) {
            this.setPiecesVisible(true);
        }
    }

    public static String getConfigureTypeName() {
        return "Hide Pieces Button";
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public Configurer getConfigurer() {
        return new AutoConfigurer(this);
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "HidePieces");
    }

    @Override
    public Element getBuildElement(Document document) {
        return AutoConfigurable.Util.getBuildElement(document, this);
    }

    @Override
    public ComponentI18nData getI18nData() {
        if (this.myI18nData == null) {
            this.myI18nData = new ComponentI18nData(this, "HidePieces");
        }
        return this.myI18nData;
    }

    public static class HiddenIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, HidePiecesButton.DEFAULT_HIDDEN_ICON);
        }
    }

    public static class ShowingIconConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new IconConfigurer(string, string2, HidePiecesButton.DEFAULT_SHOWING_ICON);
        }
    }
}

